/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.util.GuiHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = RelationMemberConflictResolverModel.class.getName() + ".numConflicts";
    private List<RelationMemberConflictDecision> decisions = new ArrayList<RelationMemberConflictDecision>();
    private Collection<Relation> relations;
    private int numConflicts;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public int getNumConflicts() {
        return this.numConflicts;
    }

    protected void updateNumConflicts() {
        int n = 0;
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            if (relationMemberConflictDecision.isDecided()) continue;
            ++n;
        }
        int n2 = this.numConflicts;
        this.numConflicts = n;
        if (this.numConflicts != n2) {
            this.support.firePropertyChange(NUM_CONFLICTS_PROP, n2, this.numConflicts);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public int getRowCount() {
        return this.getNumDecisions();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.decisions == null) {
            return null;
        }
        RelationMemberConflictDecision relationMemberConflictDecision = this.decisions.get(n);
        switch (n2) {
            case 0: {
                return relationMemberConflictDecision.getRelation();
            }
            case 1: {
                return Integer.toString(relationMemberConflictDecision.getPos() + 1);
            }
            case 2: {
                return relationMemberConflictDecision.getRole();
            }
            case 3: {
                return relationMemberConflictDecision.getOriginalPrimitive();
            }
            case 4: {
                return relationMemberConflictDecision.getDecision();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        RelationMemberConflictDecision relationMemberConflictDecision = this.decisions.get(n);
        switch (n2) {
            case 2: {
                relationMemberConflictDecision.setRole((String)object);
                break;
            }
            case 4: {
                relationMemberConflictDecision.decide((RelationMemberConflictDecisionType)((Object)object));
                this.refresh();
            }
        }
        this.fireTableDataChanged();
    }

    protected void populate(Relation relation, OsmPrimitive osmPrimitive) {
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (!relation.getMember(i).refersTo(osmPrimitive)) continue;
            this.decisions.add(new RelationMemberConflictDecision(relation, i));
        }
    }

    public void populate(Collection<Relation> linkedList, Collection<? extends OsmPrimitive> linkedList2) {
        this.decisions.clear();
        linkedList = linkedList == null ? new LinkedList<Relation>() : linkedList;
        linkedList2 = linkedList2 == null ? new LinkedList() : linkedList2;
        for (Relation relation : linkedList) {
            for (OsmPrimitive osmPrimitive : linkedList2) {
                this.populate(relation, osmPrimitive);
            }
        }
        this.relations = linkedList;
        this.refresh();
    }

    public void populate(Collection<RelationToChildReference> linkedList) {
        linkedList = linkedList == null ? new LinkedList() : linkedList;
        this.decisions.clear();
        this.relations = new HashSet<Relation>(linkedList.size());
        for (RelationToChildReference relationToChildReference : linkedList) {
            this.decisions.add(new RelationMemberConflictDecision(relationToChildReference.getParent(), relationToChildReference.getPosition()));
            this.relations.add(relationToChildReference.getParent());
        }
        this.refresh();
    }

    public RelationMemberConflictDecision getDecision(int n) {
        return this.decisions.get(n);
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public void refresh() {
        this.updateNumConflicts();
        GuiHelper.runInEDTAndWait(new Runnable(){

            public void run() {
                RelationMemberConflictResolverModel.this.fireTableDataChanged();
            }
        });
    }

    public void applyRole(String string) {
        string = string == null ? "" : string;
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            relationMemberConflictDecision.setRole(string);
        }
        this.refresh();
    }

    protected RelationMemberConflictDecision getDecision(Relation relation, int n) {
        for (RelationMemberConflictDecision relationMemberConflictDecision : this.decisions) {
            if (!relationMemberConflictDecision.matches(relation, n)) continue;
            return relationMemberConflictDecision;
        }
        return null;
    }

    protected Command buildResolveCommand(Relation relation, OsmPrimitive osmPrimitive) {
        Relation relation2 = new Relation(relation);
        relation2.setMembers(null);
        boolean bl = false;
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMember relationMember = relation.getMember(i);
            RelationMemberConflictDecision relationMemberConflictDecision = this.getDecision(relation, i);
            if (relationMemberConflictDecision == null) {
                relation2.addMember(relationMember);
                continue;
            }
            switch (relationMemberConflictDecision.getDecision()) {
                case KEEP: {
                    RelationMember relationMember2 = new RelationMember(relationMemberConflictDecision.getRole(), osmPrimitive);
                    relation2.addMember(relationMember2);
                    bl |= !relationMember.equals(relationMember2);
                    continue block4;
                }
                case REMOVE: {
                    bl = true;
                    continue block4;
                }
            }
        }
        if (bl) {
            return new ChangeCommand(relation, relation2);
        }
        return null;
    }

    public List<Command> buildResolutionCommands(OsmPrimitive osmPrimitive) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Relation relation : this.relations) {
            Command command = this.buildResolveCommand(relation, osmPrimitive);
            if (command == null) continue;
            linkedList.add(command);
        }
        return linkedList;
    }

    protected boolean isChanged(Relation relation, OsmPrimitive osmPrimitive) {
        block4: for (int i = 0; i < relation.getMembersCount(); ++i) {
            RelationMemberConflictDecision relationMemberConflictDecision = this.getDecision(relation, i);
            if (relationMemberConflictDecision == null) continue;
            switch (relationMemberConflictDecision.getDecision()) {
                case REMOVE: {
                    return true;
                }
                case KEEP: {
                    if (!relation.getMember(i).getRole().equals(relationMemberConflictDecision.getRole())) {
                        return true;
                    }
                    if (relation.getMember(i).getMember() == osmPrimitive) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<Relation> getModifiedRelations(OsmPrimitive osmPrimitive) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        for (Relation relation : this.relations) {
            if (!this.isChanged(relation, osmPrimitive)) continue;
            hashSet.add(relation);
        }
        return hashSet;
    }
}

