/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = TagConflictResolverModel.class.getName() + ".numConflicts";
    private TagCollection tags;
    private List<String> displayedKeys;
    private Set<String> keysWithConflicts;
    private HashMap<String, MultiValueResolutionDecision> decisions;
    private int numConflicts = 0;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean showTagsWithConflictsOnly = false;
    private boolean showTagsWithMultiValuesOnly = false;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void setNumConflicts(int n) {
        int n2 = this.numConflicts;
        this.numConflicts = n;
        if (n2 != this.numConflicts) {
            this.support.firePropertyChange(NUM_CONFLICTS_PROP, n2, this.numConflicts);
        }
    }

    protected void refreshNumConflicts() {
        int n = 0;
        for (MultiValueResolutionDecision multiValueResolutionDecision : this.decisions.values()) {
            if (multiValueResolutionDecision.isDecided()) continue;
            ++n;
        }
        this.setNumConflicts(n);
    }

    protected void sort() {
        Collections.sort(this.displayedKeys, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(string)).isDecided() && !((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(string2)).isDecided()) {
                    return 1;
                }
                if (!((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(string)).isDecided() && ((MultiValueResolutionDecision)TagConflictResolverModel.this.decisions.get(string2)).isDecided()) {
                    return -1;
                }
                return string.compareTo(string2);
            }
        });
    }

    protected void rebuild() {
        if (this.tags == null) {
            return;
        }
        for (String iterator : this.tags.getKeys()) {
            MultiValueResolutionDecision multiValueResolutionDecision = new MultiValueResolutionDecision(this.tags.getTagsFor(iterator));
            if (this.decisions.get(iterator) != null) continue;
            this.decisions.put(iterator, multiValueResolutionDecision);
        }
        this.displayedKeys.clear();
        Set<String> set = this.tags.getKeys();
        if (this.showTagsWithConflictsOnly) {
            set.retainAll(this.keysWithConflicts);
            if (this.showTagsWithMultiValuesOnly) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!this.decisions.get(string).canKeepAll()) continue;
                    hashSet.add(string);
                }
                set.retainAll(hashSet);
            }
            for (String string : this.tags.getKeys()) {
                if (this.decisions.get(string).isDecided() || set.contains(string)) continue;
                set.add(string);
            }
        }
        this.displayedKeys.addAll((Collection<String>)set);
        this.refreshNumConflicts();
        this.sort();
        GuiHelper.runInEDTAndWait(new Runnable(){

            public void run() {
                TagConflictResolverModel.this.fireTableDataChanged();
            }
        });
    }

    public void populate(TagCollection tagCollection, Set<String> hashSet) {
        CheckParameterUtil.ensureParameterNotNull(tagCollection, "tags");
        this.tags = tagCollection;
        this.displayedKeys = new ArrayList<String>();
        this.keysWithConflicts = hashSet == null ? new HashSet() : hashSet;
        this.decisions = new HashMap();
        this.rebuild();
    }

    @Override
    public int getRowCount() {
        if (this.displayedKeys == null) {
            return 0;
        }
        return this.displayedKeys.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.decisions.get(this.displayedKeys.get(n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        MultiValueResolutionDecision multiValueResolutionDecision = this.decisions.get(this.displayedKeys.get(n));
        if (object instanceof String) {
            multiValueResolutionDecision.keepOne((String)object);
        } else if (object instanceof MultiValueDecisionType) {
            MultiValueDecisionType multiValueDecisionType = (MultiValueDecisionType)((Object)object);
            switch (multiValueDecisionType) {
                case KEEP_NONE: {
                    multiValueResolutionDecision.keepNone();
                    break;
                }
                case KEEP_ALL: {
                    multiValueResolutionDecision.keepAll();
                }
            }
        }
        GuiHelper.runInEDTAndWait(new Runnable(){

            public void run() {
                TagConflictResolverModel.this.fireTableDataChanged();
            }
        });
        this.refreshNumConflicts();
    }

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public TagCollection getResolution() {
        TagCollection tagCollection = new TagCollection();
        for (String string : this.displayedKeys) {
            tagCollection.add(this.decisions.get(string).getResolution());
        }
        return tagCollection;
    }

    public TagCollection getAllResolutions() {
        TagCollection tagCollection = new TagCollection();
        for (MultiValueResolutionDecision multiValueResolutionDecision : this.decisions.values()) {
            tagCollection.add(multiValueResolutionDecision.getResolution());
        }
        return tagCollection;
    }

    public MultiValueResolutionDecision getDecision(int n) {
        return this.decisions.get(this.displayedKeys.get(n));
    }

    public void setShowTagsWithConflictsOnly(boolean bl) {
        this.showTagsWithConflictsOnly = bl;
        this.rebuild();
    }

    public void setShowTagsWithMultiValuesOnly(boolean bl) {
        this.showTagsWithMultiValuesOnly = bl;
        this.rebuild();
    }

    public void prepareDefaultTagDecisions() {
        for (MultiValueResolutionDecision multiValueResolutionDecision : this.decisions.values()) {
            List<String> list = multiValueResolutionDecision.getValues();
            list.remove("");
            if (list.size() == 1) {
                multiValueResolutionDecision.keepOne(list.get(0));
                continue;
            }
            multiValueResolutionDecision.keepAll();
        }
        this.rebuild();
    }
}

