/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetContentPanel
extends JPanel
implements PropertyChangeListener {
    private ChangesetContentTableModel model;
    private Changeset currentChangeset;
    private JTable tblContent;
    private DonwloadChangesetContentAction actDownloadContentAction;
    private ShowHistoryAction actShowHistory;
    private SelectInCurrentLayerAction actSelectInCurrentLayerAction;
    private ZoomInCurrentLayerAction actZoomInCurrentLayerAction;
    private HeaderPanel pnlHeader;

    protected void buildModels() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new ChangesetContentTableModel(defaultListSelectionModel);
        this.actDownloadContentAction = new DonwloadChangesetContentAction();
        this.actDownloadContentAction.initProperties(this.currentChangeset);
        this.actShowHistory = new ShowHistoryAction();
        this.model.getSelectionModel().addListSelectionListener(this.actShowHistory);
        this.actSelectInCurrentLayerAction = new SelectInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actSelectInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actSelectInCurrentLayerAction);
        this.actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actZoomInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
            }
        });
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tblContent = new JTable(this.model, new ChangesetContentTableColumnModel(), this.model.getSelectionModel());
        this.tblContent.addMouseListener(new PopupMenuLauncher(new ChangesetContentTablePopupMenu()));
        jPanel.add((Component)new JScrollPane(this.tblContent), "Center");
        return jPanel;
    }

    protected JPanel buildActionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.actDownloadContentAction);
        jToolBar.add(this.actShowHistory);
        jToolBar.add(this.actSelectInCurrentLayerAction);
        jToolBar.add(this.actZoomInCurrentLayerAction);
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected void build() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.buildModels();
        this.pnlHeader = new HeaderPanel();
        this.add((Component)this.pnlHeader, "North");
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add((Component)this.buildContentPanel(), "Center");
    }

    public ChangesetContentPanel() {
        this.build();
    }

    public ChangesetContentTableModel getModel() {
        return this.model;
    }

    protected void setCurrentChangeset(Changeset changeset) {
        this.currentChangeset = changeset;
        if (changeset == null) {
            this.model.populate(null);
        } else {
            this.model.populate(changeset.getContent());
        }
        this.actDownloadContentAction.initProperties(changeset);
        this.pnlHeader.setChangeset(changeset);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset changeset = (Changeset)propertyChangeEvent.getNewValue();
        this.setCurrentChangeset(changeset);
    }

    private static class HeaderPanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private Changeset current;

        protected void build() {
            this.setLayout(new FlowLayout(0));
            this.lblMessage = new JMultilineLabel(I18n.tr("The content of this changeset is not downloaded yet.", new Object[0]));
            this.add(this.lblMessage);
            this.add(new JButton(new DownloadAction()));
        }

        public HeaderPanel() {
            this.build();
        }

        public void setChangeset(Changeset changeset) {
            this.setVisible(changeset != null && changeset.getContent() == null);
            this.current = changeset;
        }

        private class DownloadAction
        extends AbstractAction {
            public DownloadAction() {
                this.putValue("Name", I18n.tr("Download now", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (HeaderPanel.this.current == null) {
                    return;
                }
                ChangesetContentDownloadTask changesetContentDownloadTask = new ChangesetContentDownloadTask((Component)HeaderPanel.this, HeaderPanel.this.current.getId());
                ChangesetCacheManager.getInstance().runDownloadTask(changesetContentDownloadTask);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.putValue("ShortDescription", I18n.tr("Zoom to the corresponding objects in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToZoomTo(Collection<HistoryOsmPrimitive> collection) {
            HelpAwareOptionPane.showOptionDialog(ChangesetContentPanel.this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", collection.size(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to zoom to", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || Main.main.getEditLayer() == null) {
                return;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> set = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive historyOsmPrimitive : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(historyOsmPrimitive.getPrimitiveId());
                if (osmPrimitive == null) continue;
                hashSet.add(osmPrimitive);
            }
            if (hashSet.isEmpty()) {
                this.alertNoPrimitivesToZoomTo(set);
                return;
            }
            osmDataLayer.data.setSelected(hashSet);
            AutoScaleAction.zoomToSelection();
        }

        public void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("ShortDescription", I18n.tr("Select the corresponding primitives in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToSelect(Collection<HistoryOsmPrimitive> collection) {
            HelpAwareOptionPane.showOptionDialog(ChangesetContentPanel.this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", collection.size(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to select", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || Main.main.getEditLayer() == null) {
                return;
            }
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> set = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive historyOsmPrimitive : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive osmPrimitive = osmDataLayer.data.getPrimitiveById(historyOsmPrimitive.getPrimitiveId());
                if (osmPrimitive == null) continue;
                hashSet.add(osmPrimitive);
            }
            if (hashSet.isEmpty()) {
                this.alertNoPrimitivesToSelect(set);
                return;
            }
            osmDataLayer.data.setSelected(hashSet);
        }

        public void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("ShortDescription", I18n.tr("Download and show the history of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        protected List<HistoryOsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<HistoryOsmPrimitive> collection) {
            ArrayList<HistoryOsmPrimitive> arrayList = new ArrayList<HistoryOsmPrimitive>(collection.size());
            for (HistoryOsmPrimitive historyOsmPrimitive : collection) {
                if (HistoryDataSet.getInstance().getHistory(historyOsmPrimitive.getPrimitiveId()) != null) continue;
                arrayList.add(historyOsmPrimitive);
            }
            return arrayList;
        }

        public void showHistory(final Collection<HistoryOsmPrimitive> collection) {
            Runnable runnable;
            List<HistoryOsmPrimitive> list = this.filterPrimitivesWithUnloadedHistory(collection);
            if (!list.isEmpty()) {
                runnable = new HistoryLoadTask(ChangesetContentPanel.this);
                for (HistoryOsmPrimitive historyOsmPrimitive : list) {
                    ((HistoryLoadTask)runnable).add(historyOsmPrimitive);
                }
                Main.worker.submit(runnable);
            }
            runnable = new Runnable(){

                public void run() {
                    try {
                        for (HistoryOsmPrimitive historyOsmPrimitive : collection) {
                            final History history = HistoryDataSet.getInstance().getHistory(historyOsmPrimitive.getPrimitiveId());
                            if (history == null) continue;
                            GuiHelper.runInEDT(new Runnable(){

                                public void run() {
                                    HistoryBrowserDialogManager.getInstance().show(history);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        GuiHelper.runInEDT(new Runnable(){

                            public void run() {
                                BugReportExceptionHandler.handleException(exception);
                            }
                        });
                    }
                }
            };
            Main.worker.submit(runnable);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set<HistoryOsmPrimitive> set = ChangesetContentPanel.this.model.getSelectedPrimitives();
            if (set.isEmpty()) {
                return;
            }
            this.showHistory(set);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ChangesetContentTablePopupMenu
    extends JPopupMenu {
        public ChangesetContentTablePopupMenu() {
            this.add(ChangesetContentPanel.this.actDownloadContentAction);
            this.add(ChangesetContentPanel.this.actShowHistory);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
            this.add(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
        }
    }

    class DonwloadChangesetContentAction
    extends AbstractAction {
        public DonwloadChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download content", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
            this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ChangesetContentPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetContentDownloadTask changesetContentDownloadTask = new ChangesetContentDownloadTask((Component)ChangesetContentPanel.this, ChangesetContentPanel.this.currentChangeset.getId());
            ChangesetCacheManager.getInstance().runDownloadTask(changesetContentDownloadTask);
        }

        public void initProperties(Changeset changeset) {
            if (changeset == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            if (changeset.getContent() == null) {
                this.putValue("Name", I18n.tr("Download content", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangesetcontent"));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Update content", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "updatechangesetcontent"));
                this.putValue("ShortDescription", I18n.tr("Update the changeset content from the OSM server", new Object[0]));
            }
        }
    }
}

