/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationSorter {
    private static final Collection<AdditionalSorter> additionalSorters = new ArrayList<AdditionalSorter>();

    public List<RelationMember> sortMembers(List<RelationMember> list) {
        Integer n;
        Object object;
        ArrayList<RelationMember> arrayList2 = new ArrayList<RelationMember>();
        ArrayList<RelationMember> arrayList3 = new ArrayList<RelationMember>(list.size());
        HashMap hashMap = new HashMap();
        for (RelationMember arrayList4 : list) {
            for (AdditionalSorter additionalSorter : additionalSorters) {
                object = arrayList3;
                if (additionalSorter.acceptsMember(arrayList4) && (object = (List)hashMap.get(additionalSorter)) == null) {
                    object = new LinkedList();
                    hashMap.put(additionalSorter, object);
                }
                object.add((RelationMember)arrayList4);
            }
        }
        for (AdditionalSorter additionalSorter : hashMap.keySet()) {
            arrayList2.addAll(additionalSorter.sortMembers((List)hashMap.get(additionalSorter)));
        }
        RelationNodeMap relationNodeMap = new RelationNodeMap(arrayList3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while ((n = relationNodeMap.pop()) != null) {
            LinkedList linkedList = new LinkedList();
            linkedList.add(n);
            arrayList.add(linkedList);
            object = n;
            while ((object = relationNodeMap.popAdjacent((Integer)object)) != null) {
                linkedList.addLast(object);
            }
            object = n;
            while ((object = relationNodeMap.popAdjacent((Integer)object)) != null) {
                linkedList.addFirst(object);
            }
        }
        for (LinkedList linkedList : arrayList) {
            for (Integer n2 : linkedList) {
                arrayList2.add((RelationMember)arrayList3.get(n2));
            }
        }
        for (Integer n3 : relationNodeMap.getNotSortableMembers()) {
            arrayList2.add((RelationMember)arrayList3.get(n3));
        }
        return arrayList2;
    }

    static {
        additionalSorters.add(new AssociatedStreetSorter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssociatedStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember relationMember) {
            return relationMember != null && relationMember.getRole() != null && relationMember.getRole().equals("house") && relationMember.getMember() != null && relationMember.getMember().get("addr:housenumber") != null;
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            Collections.sort(list, new Comparator<RelationMember>(){

                @Override
                public int compare(RelationMember relationMember, RelationMember relationMember2) {
                    String string;
                    if (relationMember == relationMember2 || relationMember.getMember() == relationMember2.getMember()) {
                        return 0;
                    }
                    String string2 = relationMember.getMember().get("addr:housenumber").trim();
                    if (string2.equals(string = relationMember2.getMember().get("addr:housenumber").trim())) {
                        return 0;
                    }
                    String string3 = string2.replaceAll("\\D+", "");
                    String string4 = string.replaceAll("\\D+", "");
                    try {
                        Integer n = Integer.parseInt(string3) - Integer.parseInt(string4);
                        if (n != 0) {
                            return n;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return string2.compareTo(string);
                }
            });
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface AdditionalSorter {
        public boolean acceptsMember(RelationMember var1);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

