/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.history.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.RelationMemberTableColumnModel;
import org.openstreetmap.josm.gui.history.SelectionSynchronizer;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;

public class RelationMemberListViewer
extends JPanel {
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private SelectionSynchronizer selectionSynchronizer;

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.adjustmentSynchronizer.participateInSynchronizedScrolling(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    protected JTable buildReferenceMemberListTable() {
        JTable jTable = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new RelationMemberTableColumnModel());
        jTable.setName("table.referencememberlisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.getModel().addTableModelListener(new MemberModelChanged(jTable));
        return jTable;
    }

    protected JTable buildCurrentMemberListTable() {
        JTable jTable = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new RelationMemberTableColumnModel());
        jTable.setName("table.currentmemberlisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.getModel().addTableModelListener(new MemberModelChanged(jTable));
        return jTable;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gridBagConstraints);
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        this.selectionSynchronizer = new SelectionSynchronizer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildReferenceMemberListTable()), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.embeddInScrollPane(this.buildCurrentMemberListTable()), gridBagConstraints);
    }

    public RelationMemberListViewer(HistoryBrowserModel historyBrowserModel) {
        this.setModel(historyBrowserModel);
        this.build();
    }

    protected void unregisterAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.deleteObserver(this.referenceInfoPanel);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel historyBrowserModel) {
        if (this.currentInfoPanel != null) {
            historyBrowserModel.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            historyBrowserModel.addObserver(this.referenceInfoPanel);
        }
    }

    public void setModel(HistoryBrowserModel historyBrowserModel) {
        if (this.model != null) {
            this.unregisterAsObserver(historyBrowserModel);
        }
        this.model = historyBrowserModel;
        if (this.model != null) {
            this.registerAsObserver(historyBrowserModel);
        }
    }

    protected class MemberModelChanged
    implements TableModelListener {
        private final JTable table;

        protected MemberModelChanged(JTable jTable) {
            this.table = jTable;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            Rectangle rectangle = this.table.getCellRect(((DiffTableModel)tableModelEvent.getSource()).getFirstChange(), 0, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }
}

