/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTable
extends JTable
implements Observer {
    private VersionTablePopupMenu popupMenu;
    private final HistoryBrowserModel model;

    protected void build() {
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(9.0f));
        this.setRowSelectionAllowed(false);
        this.setShowGrid(false);
        this.setAutoResizeMode(0);
        this.setBackground(UIManager.getColor("Button.background"));
        this.setIntercellSpacing(new Dimension(6, 0));
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.popupMenu = new VersionTablePopupMenu();
        this.addMouseListener(new MouseListener());
        this.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                VersionTable.adjustColumnWidth(VersionTable.this, 0, 0);
                VersionTable.adjustColumnWidth(VersionTable.this, 1, -8);
                VersionTable.adjustColumnWidth(VersionTable.this, 2, -8);
                VersionTable.adjustColumnWidth(VersionTable.this, 3, 0);
                VersionTable.adjustColumnWidth(VersionTable.this, 4, 0);
            }
        });
    }

    public VersionTable(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel.getVersionTableModel(), new VersionTableColumnModel());
        historyBrowserModel.addObserver(this);
        this.build();
        this.model = historyBrowserModel;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        super.scrollRectToVisible(new Rectangle(0, rectangle.y, rectangle.width, rectangle.height));
    }

    protected HistoryBrowserModel.VersionTableModel getVersionTableModel() {
        return (HistoryBrowserModel.VersionTableModel)this.getModel();
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    private static void adjustColumnWidth(JTable jTable, int n, int n2) {
        Object object;
        Object object2;
        int n3 = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            object2 = jTable.getCellRenderer(i, n);
            object = jTable.getValueAt(i, n);
            Component component = object2.getTableCellRendererComponent(jTable, object, false, false, i, n);
            n3 = Math.max(component.getPreferredSize().width + n2, n3);
        }
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        object2 = jTable.getColumnModel().getColumn(n).getHeaderValue();
        object = tableCellRenderer.getTableCellRendererComponent(jTable, object2, false, false, -1, n);
        n3 = Math.max(((Component)object).getPreferredSize().width + Main.pref.getInteger("table.header-inset", 0), n3);
        int n4 = jTable.getIntercellSpacing().width;
        jTable.getColumnModel().getColumn(n).setPreferredWidth(n3 + n4);
    }

    public static class AlignedRenderer
    extends JLabel
    implements TableCellRenderer {
        public AlignedRenderer(int n) {
            this.setHorizontalAlignment(n);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object.toString();
            this.setText(string);
            return this;
        }
    }

    public static class RadioButtonEditor
    extends DefaultCellEditor
    implements ItemListener {
        private JRadioButton btn = new JRadioButton();

        public RadioButtonEditor() {
            super(new JCheckBox());
            this.btn.setHorizontalAlignment(0);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return null;
            }
            boolean bl2 = (Boolean)object;
            this.btn.setSelected(bl2);
            this.btn.addItemListener(this);
            return this.btn;
        }

        public Object getCellEditorValue() {
            this.btn.removeItemListener(this);
            return this.btn.isSelected();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped();
        }
    }

    public static class RadioButtonRenderer
    extends JRadioButton
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setSelected(object != null && (Boolean)object != false);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class VersionTablePopupMenu
    extends JPopupMenu {
        private ChangesetInfoAction changesetInfoAction;

        protected void build() {
            this.changesetInfoAction = new ChangesetInfoAction();
            this.add(this.changesetInfoAction);
        }

        public VersionTablePopupMenu() {
            this.build();
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.changesetInfoAction.prepare(historyOsmPrimitive);
            this.invalidate();
        }
    }

    static class ChangesetInfoAction
    extends AbstractInfoAction {
        private HistoryOsmPrimitive primitive;

        public ChangesetInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("Changeset info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("about"));
        }

        protected String createInfoUrl(Object object) {
            HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
            return ChangesetInfoAction.getBaseBrowseUrl() + "/changeset/" + historyOsmPrimitive.getChangesetId();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = this.createInfoUrl(this.primitive);
            this.launchBrowser(string);
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.putValue("Name", I18n.tr("Show changeset {0}", historyOsmPrimitive.getChangesetId()));
            this.primitive = historyOsmPrimitive;
        }
    }

    class MouseListener
    extends PopupMenuLauncher {
        public MouseListener() {
            super(VersionTable.this.popupMenu);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getButton() == 1) {
                int n = VersionTable.this.rowAtPoint(mouseEvent.getPoint());
                int n2 = VersionTable.this.columnAtPoint(mouseEvent.getPoint());
                if (n > 0 && (n2 == 3 || n2 == 4)) {
                    VersionTable.this.model.getVersionTableModel().setCurrentPointInTime(n);
                    VersionTable.this.model.getVersionTableModel().setReferencePointInTime(n - 1);
                }
            }
        }

        protected int checkTableSelection(JTable jTable, Point point) {
            HistoryBrowserModel.VersionTableModel versionTableModel = VersionTable.this.getVersionTableModel();
            int n = VersionTable.this.rowAtPoint(point);
            if (n > -1 && !versionTableModel.isLatest(n)) {
                VersionTable.this.popupMenu.prepare(versionTableModel.getPrimitive(n));
            }
            return n;
        }
    }
}

