/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public boolean matches(Environment var1);

    public String getSubpart();

    public Range getRange();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneralSelector
    extends AbstractSelector {
        private String base;
        public Range range;
        private String subpart;
        static final double R = 6378135.0;

        public GeneralSelector(String string, Pair<Integer, Integer> pair, List<Condition> list, String string2) {
            super(list);
            this.base = string;
            if (pair != null) {
                int n;
                int n2 = pair.a == null ? 0 : (Integer)pair.a;
                int n3 = n = pair.b == null ? Integer.MAX_VALUE : (Integer)pair.b;
                if (n2 <= n) {
                    this.range = GeneralSelector.fromLevel(n2, n);
                }
            }
            if (this.range == null) {
                this.range = new Range();
            }
            this.subpart = string2;
        }

        @Override
        public String getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        public boolean matchesBase(Environment environment) {
            if (environment.osm instanceof Node) {
                return this.base.equals("node") || this.base.equals("*");
            }
            if (environment.osm instanceof Way) {
                return this.base.equals("way") || this.base.equals("area") || this.base.equals("*");
            }
            if (environment.osm instanceof Relation) {
                if (this.base.equals("area")) {
                    return ((Relation)environment.osm).isMultipolygon();
                }
                if (this.base.equals("relation")) {
                    return true;
                }
                if (this.base.equals("canvas")) {
                    return environment.osm.get("#canvas") != null;
                }
            }
            return false;
        }

        @Override
        public boolean matches(Environment environment) {
            if (!this.matchesBase(environment)) {
                return false;
            }
            return this.matchesConditions(environment);
        }

        public String getBase() {
            return this.base;
        }

        public static Range fromLevel(int n, int n2) {
            if (n > n2) {
                throw new AssertionError();
            }
            double d = 0.0;
            double d2 = Double.POSITIVE_INFINITY;
            if (n2 != Integer.MAX_VALUE) {
                d = GeneralSelector.level2scale(n2 + 1);
            }
            if (n != 0) {
                d2 = GeneralSelector.level2scale(n);
            }
            return new Range(d, d2);
        }

        public static double level2scale(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return 4.0075004119207874E7 / Math.pow(2.0, n) / 2.56;
        }

        public String toString() {
            return this.base + (this.range == null ? "" : this.range) + Utils.join("", this.conds) + (this.subpart != null ? "::" + this.subpart : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> list) {
            super(list);
        }

        @Override
        public boolean matches(Environment environment) {
            Utils.ensure(environment.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{environment.getContext()});
            return this.matchesConditions(environment);
        }

        @Override
        public String getSubpart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> list) {
            this.conds = list == null || list.isEmpty() ? null : list;
        }

        public final boolean matchesConditions(Environment environment) {
            if (this.conds == null) {
                return true;
            }
            for (Condition condition : this.conds) {
                try {
                    if (condition.applies(environment)) continue;
                    return false;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println("PatternSyntaxException while applying condition" + condition + ": " + patternSyntaxException.getMessage());
                    return false;
                }
            }
            return true;
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        private final Selector left;
        private final LinkSelector link;
        private final Selector right;
        private final boolean parentSelector;

        public ChildOrParentSelector(Selector selector, LinkSelector linkSelector, Selector selector2, boolean bl) {
            this.left = selector;
            this.link = linkSelector;
            this.right = selector2;
            this.parentSelector = bl;
        }

        public boolean matches(Environment environment) {
            block5: {
                block6: {
                    block4: {
                        if (!this.right.matches(environment)) {
                            return false;
                        }
                        if (this.parentSelector) break block4;
                        MatchingReferrerFinder matchingReferrerFinder = new MatchingReferrerFinder(environment);
                        environment.osm.visitReferrers(matchingReferrerFinder);
                        if (environment.parent != null) {
                            return true;
                        }
                        break block5;
                    }
                    if (!(environment.osm instanceof Way)) break block6;
                    List<Node> list = ((Way)environment.osm).getNodes();
                    for (int i = 0; i < list.size(); ++i) {
                        Node node = list.get(i);
                        if (!this.left.matches(environment.withPrimitive(node)) || !this.link.matches(environment.withChild(node).withIndex(i).withLinkContext())) continue;
                        environment.child = node;
                        environment.index = i;
                        return true;
                    }
                    break block5;
                }
                if (!(environment.osm instanceof Relation)) break block5;
                List<RelationMember> list = ((Relation)environment.osm).getMembers();
                for (int i = 0; i < list.size(); ++i) {
                    OsmPrimitive osmPrimitive = list.get(i).getMember();
                    if (!this.left.matches(environment.withPrimitive(osmPrimitive)) || !this.link.matches(environment.withChild(osmPrimitive).withIndex(i).withLinkContext())) continue;
                    environment.child = osmPrimitive;
                    environment.index = i;
                    return true;
                }
            }
            return false;
        }

        public String getSubpart() {
            return this.right.getSubpart();
        }

        public Range getRange() {
            return this.right.getRange();
        }

        public String toString() {
            return this.left + " " + (this.parentSelector ? "<" : ">") + this.link + " " + this.right;
        }

        private class MatchingReferrerFinder
        extends AbstractVisitor {
            private Environment e;

            public MatchingReferrerFinder(Environment environment) {
                this.e = environment;
            }

            public void visit(Node node) {
                throw new AssertionError();
            }

            public void visit(Way way) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(way))) {
                    return;
                }
                for (int i = 0; i < way.getNodesCount(); ++i) {
                    Node node = way.getNode(i);
                    if (!node.equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParent(way).withIndex(i).withLinkContext())) continue;
                    this.e.parent = way;
                    this.e.index = i;
                    return;
                }
            }

            public void visit(Relation relation) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(relation))) {
                    return;
                }
                for (int i = 0; i < relation.getMembersCount(); ++i) {
                    RelationMember relationMember = relation.getMember(i);
                    if (!relationMember.getMember().equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParent(relation).withIndex(i).withLinkContext())) continue;
                    this.e.parent = relation;
                    this.e.index = i;
                    return;
                }
            }
        }
    }
}

