/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.Main;

public class InvalidXmlCharacterFilter
extends FilterInputStream {
    public static boolean firstWarning = true;
    public static final boolean[] INVALID_CHARS = new boolean[32];

    public InvalidXmlCharacterFilter(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        return this.filter((byte)super.read());
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        for (int i = n; i < n + n3; ++i) {
            byArray[i] = this.filter(byArray[i]);
        }
        return n3;
    }

    private byte filter(byte by) {
        if (by < 32 && by >= 0 && INVALID_CHARS[by]) {
            if (firstWarning) {
                Main.warn("Invalid xml character encountered.");
                firstWarning = false;
            }
            return 32;
        }
        return by;
    }

    static {
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            InvalidXmlCharacterFilter.INVALID_CHARS[i] = true;
        }
        InvalidXmlCharacterFilter.INVALID_CHARS[9] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[10] = false;
        InvalidXmlCharacterFilter.INVALID_CHARS[13] = false;
    }
}

