/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmServerObjectReader
extends OsmServerReader {
    private PrimitiveId id;
    private boolean full;
    private int version;

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl) throws IllegalArgumentException {
        this(l, osmPrimitiveType, bl, -1);
    }

    public OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, int n) throws IllegalArgumentException {
        this(l, osmPrimitiveType, false, n);
    }

    protected OsmServerObjectReader(long l, OsmPrimitiveType osmPrimitiveType, boolean bl, int n) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value > 0 for parameter ''{0}'', got {1}", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        this.id = new SimplePrimitiveId(l, osmPrimitiveType);
        this.full = bl;
        this.version = n;
    }

    public OsmServerObjectReader(PrimitiveId primitiveId, boolean bl) {
        this(primitiveId, bl, -1);
    }

    public OsmServerObjectReader(PrimitiveId primitiveId, int n) {
        this(primitiveId, false, n);
    }

    protected OsmServerObjectReader(PrimitiveId primitiveId, boolean bl, int n) {
        CheckParameterUtil.ensureValidPrimitiveId(primitiveId, "id");
        this.id = primitiveId;
        this.full = bl;
        this.version = n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream;
        block15: {
            DataSet dataSet2;
            block14: {
                if (progressMonitor == null) {
                    progressMonitor = NullProgressMonitor.INSTANCE;
                }
                progressMonitor.beginTask("", 1);
                inputStream = null;
                try {
                    DataSet dataSet3;
                    progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data...", new Object[0]));
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.id.getType().getAPIName());
                    stringBuffer.append("/");
                    stringBuffer.append(this.id.getUniqueId());
                    if (this.full && !this.id.getType().equals((Object)OsmPrimitiveType.NODE)) {
                        stringBuffer.append("/full");
                    } else if (this.version > 0) {
                        stringBuffer.append("/" + this.version);
                    }
                    inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
                    if (inputStream == null) {
                        dataSet2 = null;
                        progressMonitor.finishTask();
                        break block14;
                    }
                    dataSet = dataSet3 = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(-1, false));
                    progressMonitor.finishTask();
                    break block15;
                }
                catch (OsmTransferException osmTransferException) {
                    if (!this.cancel) throw osmTransferException;
                    DataSet dataSet4 = null;
                    return dataSet4;
                }
            }
            Utils.close(inputStream);
            this.activeConnection = null;
            return dataSet2;
        }
        Utils.close(inputStream);
        this.activeConnection = null;
        return dataSet;
        catch (Exception exception) {
            if (!this.cancel) throw new OsmTransferException(exception);
            DataSet dataSet5 = null;
            return dataSet5;
        }
        finally {
            progressMonitor.finishTask();
            Utils.close(inputStream);
            this.activeConnection = null;
        }
    }
}

