/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSessionExporter
implements SessionLayerExporter {
    private MarkerLayer layer;
    private JCheckBox export;

    public MarkerSessionExporter(MarkerLayer markerLayer) {
        this.layer = markerLayer;
    }

    @Override
    public Collection<Layer> getDependencies() {
        GpxLayer gpxLayer = this.layer.fromLayer;
        if (gpxLayer != null && Main.map.mapView.hasLayer(gpxLayer)) {
            return Collections.singleton(gpxLayer);
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export = new JCheckBox();
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(this.layer.getName(), this.layer.getIcon(), 2);
        jLabel.setToolTipText(this.layer.getToolTipText());
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public boolean shallExport() {
        return this.export.isSelected();
    }

    @Override
    public boolean requiresZip() {
        return true;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "markers");
        element.setAttribute("version", "0.1");
        Element element2 = exportSupport.createElement("file");
        element.appendChild(element2);
        String string = "layers/" + String.format("%02d", exportSupport.getLayerIndex()) + "/data.gpx";
        element2.appendChild(exportSupport.createTextNode(string));
        this.addDataFile(exportSupport.getOutputStreamZip(string));
        return element;
    }

    protected void addDataFile(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        MarkerWriter markerWriter = new MarkerWriter(new PrintWriter(outputStreamWriter));
        markerWriter.write(this.layer);
        markerWriter.flush();
    }

    public static class MarkerWriter
    extends GpxWriter {
        public MarkerWriter(PrintWriter printWriter) {
            super(printWriter);
        }

        public void write(MarkerLayer markerLayer) {
            GpxData gpxData = new GpxData();
            gpxData.attr.put("meta.desc", "exported JOSM marker layer");
            for (Marker marker : markerLayer.data) {
                gpxData.waypoints.add(marker.convertToWayPoint());
            }
            super.write(gpxData);
        }
    }
}

