/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInformation {
    public File file = null;
    public String name = null;
    public int mainversion = 0;
    public int localmainversion = 0;
    public String className = null;
    public boolean oldmode = false;
    public String requires = null;
    public String localrequires = null;
    public String link = null;
    public String description = null;
    public boolean early = false;
    public String author = null;
    public int stage = 50;
    public String version = null;
    public String localversion = null;
    public String downloadlink = null;
    public String iconPath;
    public ImageIcon icon;
    public List<URL> libraries = new LinkedList<URL>();
    public final Map<String, String> attr = new TreeMap<String, String>();
    private static final ImageIcon emptyIcon = new ImageIcon(new BufferedImage(24, 24, 2));

    public PluginInformation(File file) throws PluginException {
        this(file, file.getName().substring(0, file.getName().length() - 4));
    }

    public PluginInformation(File file, String string) throws PluginException {
        if (!PluginHandler.isValidJar(file)) {
            throw new PluginException(string, I18n.tr("Invalid jar file ''{0}''", file));
        }
        this.name = string;
        this.file = file;
        FileInputStream fileInputStream = null;
        JarInputStream jarInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            jarInputStream = new JarInputStream(fileInputStream);
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) {
                throw new PluginException(string, I18n.tr("The plugin file ''{0}'' does not include a Manifest.", file.toString()));
            }
            this.scanManifest(manifest, false);
            this.libraries.add(0, PluginInformation.fileToURL(file));
        }
        catch (IOException iOException) {
            try {
                throw new PluginException(string, iOException);
            }
            catch (Throwable throwable) {
                Utils.close(jarInputStream);
                Utils.close(fileInputStream);
                throw throwable;
            }
        }
        Utils.close(jarInputStream);
        Utils.close(fileInputStream);
    }

    public PluginInformation(InputStream inputStream, String string, String string2) throws PluginException {
        this.name = string;
        try {
            Manifest manifest = new Manifest();
            manifest.read(inputStream);
            if (string2 != null) {
                this.downloadlink = string2;
            }
            this.scanManifest(manifest, string2 != null);
        }
        catch (IOException iOException) {
            throw new PluginException(string, iOException);
        }
    }

    public void updateFromPluginSite(PluginInformation pluginInformation) {
        this.mainversion = pluginInformation.mainversion;
        this.className = pluginInformation.className;
        this.requires = pluginInformation.requires;
        this.link = pluginInformation.link;
        this.description = pluginInformation.description;
        this.early = pluginInformation.early;
        this.author = pluginInformation.author;
        this.stage = pluginInformation.stage;
        this.version = pluginInformation.version;
        this.downloadlink = pluginInformation.downloadlink;
        this.icon = pluginInformation.icon;
        this.iconPath = pluginInformation.iconPath;
        this.libraries = pluginInformation.libraries;
        this.attr.clear();
        this.attr.putAll(pluginInformation.attr);
    }

    public void updateFromJar(PluginInformation pluginInformation) {
        this.updateLocalInfo(pluginInformation);
        if (pluginInformation.icon != null) {
            this.icon = pluginInformation.icon;
        }
        this.early = pluginInformation.early;
        this.className = pluginInformation.className;
        this.libraries = pluginInformation.libraries;
        this.stage = pluginInformation.stage;
    }

    private void scanManifest(Manifest manifest, boolean bl) {
        String string;
        Object object;
        Object object2;
        String string2 = LanguageInfo.getLanguageCodeManifest();
        Attributes attributes = manifest.getMainAttributes();
        this.className = attributes.getValue("Plugin-Class");
        String string3 = attributes.getValue(string2 + "Plugin-Link");
        if (string3 == null) {
            string3 = attributes.getValue("Plugin-Link");
        }
        if (string3 != null) {
            try {
                object2 = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(I18n.tr("Invalid URL ''{0}'' in plugin {1}", string3, this.name));
                string3 = null;
            }
        }
        this.link = string3;
        this.requires = attributes.getValue("Plugin-Requires");
        string3 = attributes.getValue(string2 + "Plugin-Description");
        if (string3 == null && (string3 = attributes.getValue("Plugin-Description")) != null) {
            try {
                string3 = I18n.tr(string3, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(I18n.tr("Invalid plugin description ''{0}'' in plugin {1}", string3, this.name));
            }
        }
        this.description = string3;
        this.early = Boolean.parseBoolean(attributes.getValue("Plugin-Early"));
        object2 = attributes.getValue("Plugin-Stage");
        this.stage = object2 == null ? 50 : Integer.parseInt((String)object2);
        this.version = attributes.getValue("Plugin-Version");
        try {
            this.mainversion = Integer.parseInt(attributes.getValue("Plugin-Mainversion"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.author = attributes.getValue("Author");
        this.iconPath = attributes.getValue("Plugin-Icon");
        if (this.iconPath != null && this.file != null) {
            this.icon = new ImageProvider(this.iconPath).setArchive(this.file).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
        }
        if (bl && this.mainversion > Version.getInstance().getVersion()) {
            int n = Version.getInstance().getVersion();
            for (Map.Entry entry : attributes.entrySet()) {
                try {
                    int n2;
                    int n3;
                    String string4 = ((Attributes.Name)entry.getKey()).toString();
                    if (!string4.endsWith("_Plugin-Url") || (n3 = Integer.parseInt(string4.substring(0, string4.length() - 11))) > n || n3 <= this.mainversion && this.mainversion <= n || (n2 = ((String)(object = (String)entry.getValue())).indexOf(";")) <= 0) continue;
                    this.downloadlink = ((String)object).substring(n2 + 1);
                    this.mainversion = n3;
                    this.version = ((String)object).substring(0, n2);
                    this.oldmode = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if ((string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String string5 : string.split(" ")) {
                object = new File(string5).isAbsolute() || this.file == null ? new File(string5) : new File(this.file.getParent(), string5);
                this.libraries.add(PluginInformation.fileToURL((File)object));
            }
        }
        for (Object e : attributes.keySet()) {
            this.attr.put(e.toString(), attributes.getValue(e.toString()));
        }
    }

    public String getDescriptionAsHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        stringBuilder.append(this.description == null ? I18n.tr("no description available", new Object[0]) : this.description);
        if (this.link != null) {
            stringBuilder.append(" <a href=\"").append(this.link).append("\">").append(I18n.tr("More info...", new Object[0])).append("</a>");
        }
        if (this.downloadlink != null && !this.downloadlink.startsWith("http://svn.openstreetmap.org/applications/editors/josm/dist/") && !this.downloadlink.startsWith("http://trac.openstreetmap.org/browser/applications/editors/josm/dist/")) {
            stringBuilder.append("<p>&nbsp;</p><p>" + I18n.tr("<b>Plugin provided by an external source:</b> {0}", this.downloadlink) + "</p>");
        }
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    public PluginProxy load(Class<?> clazz) throws PluginException {
        try {
            Constructor<?> constructor = clazz.getConstructor(PluginInformation.class);
            Object obj = constructor.newInstance(this);
            return new PluginProxy(obj, this);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PluginException(this.name, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PluginException(this.name, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new PluginException(this.name, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PluginException(this.name, invocationTargetException);
        }
    }

    public Class<?> loadClass(ClassLoader classLoader) throws PluginException {
        if (this.className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PluginException(this.name, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new PluginException(this.name, classCastException);
        }
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static PluginInformation findPlugin(String string) throws PluginException {
        String string2 = string;
        string2 = string2.replaceAll("[-. ]", "");
        InputStream inputStream = PluginInformation.class.getResourceAsStream("/org/openstreetmap/josm/plugins/" + string2 + "/MANIFEST.MF");
        if (inputStream != null) {
            return new PluginInformation(inputStream, string, null);
        }
        Collection<String> collection = PluginInformation.getPluginLocations();
        for (String string3 : collection) {
            File file = new File(string3, string + ".jar");
            if (!file.exists()) continue;
            PluginInformation pluginInformation = new PluginInformation(file);
            return pluginInformation;
        }
        return null;
    }

    public static Collection<String> getPluginLocations() {
        Collection<String> collection = Main.pref.getAllPossiblePreferenceDirs();
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(string + "plugins");
        }
        return arrayList;
    }

    public boolean isUpdateRequired(String string) {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.version == null && string != null) {
            return true;
        }
        return this.version != null && !this.version.equals(string);
    }

    public boolean isUpdateRequired() {
        if (this.downloadlink == null) {
            return false;
        }
        if (this.localversion == null) {
            return true;
        }
        return this.isUpdateRequired(this.localversion);
    }

    protected boolean matches(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string2 == null) {
            return false;
        }
        return string2.toLowerCase().contains(string.toLowerCase());
    }

    public boolean matches(String string) {
        String[] stringArray;
        if (string == null) {
            return true;
        }
        for (String string2 : stringArray = string.split("\\s+")) {
            if (!this.matches(string2, this.name) && !this.matches(string2, this.description) && !this.matches(string2, this.version) && !this.matches(string2, this.localversion)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ImageIcon getScaledIcon() {
        if (this.icon == null) {
            return emptyIcon;
        }
        return new ImageIcon(this.icon.getImage().getScaledInstance(24, 24, 4));
    }

    public String toString() {
        return this.getName();
    }

    private static List<String> getRequiredPlugins(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            for (String string2 : string.split(";")) {
                String string3 = string2.trim();
                if (string3.isEmpty()) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public List<String> getRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.requires);
    }

    public List<String> getLocalRequiredPlugins() {
        return PluginInformation.getRequiredPlugins(this.localrequires);
    }

    public void updateLocalInfo(PluginInformation pluginInformation) {
        if (pluginInformation != null) {
            this.localversion = pluginInformation.version;
            this.localmainversion = pluginInformation.mainversion;
            this.localrequires = pluginInformation.requires;
        }
    }
}

