/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import javax.vecmath.Point3d;

public class RtHalton3d {
    double[] invBase = new double[3];
    double[] prev = new double[3];

    public RtHalton3d() {
        this.invBase[0] = 0.5;
        this.invBase[1] = 0.3333333333333333;
        this.invBase[2] = 0.25;
        this.prev[0] = 0.0;
        this.prev[1] = 0.0;
        this.prev[2] = 0.0;
    }

    final double halton(int index) {
        double hh;
        double r = 1.0 - this.prev[index] - 1.0E-10;
        if (this.invBase[index] < r) {
            this.prev[index] = this.prev[index] + this.invBase[index];
            return this.prev[index];
        }
        double h = this.invBase[index];
        do {
            hh = h;
        } while ((h *= this.invBase[index]) >= r);
        this.prev[index] = this.prev[index] + hh + h - 1.0;
        return this.prev[index];
    }

    void reset() {
        this.prev[0] = 0.0;
        this.prev[1] = 0.0;
        this.prev[2] = 0.0;
    }

    Point3d GetNext() {
        return new Point3d(this.halton(0), this.halton(1), this.halton(2));
    }
}

