/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtPhoton;
import javax.vecmath.Point3d;

class RtPhotonMap {
    int mapCount = 0;
    int mapSize = 0;
    RtPhoton[] photonMap;
    int foundCount = 0;
    double foundFurthest = 0.0;
    int[] foundIndex = new int[50];
    double[] foundDistance = new double[50];

    public RtPhotonMap(int size) {
        this.mapSize = size;
        this.mapCount = 0;
    }

    public final void getRadiance(Point3d origin, int samples) {
        this.insertIntoFound(0, origin.distance(this.photonMap[0].origin));
        int i = 1;
        while (i < this.mapCount) {
            RtPhoton photon = this.photonMap[i];
            double distance = origin.distance(this.photonMap[i].origin);
            if (distance < this.foundFurthest || (double)this.foundCount < distance) {
                this.insertIntoFound(i, distance);
            }
            ++i;
        }
    }

    public final void insertIntoFound(int index, double distance) {
        int insertAt = -1;
        int i = 0;
        while (i < this.foundCount) {
            if (this.foundDistance[i] < distance) {
                insertAt = i;
                break;
            }
            ++i;
        }
        if (insertAt == -1) {
            ++this.foundCount;
            insertAt = this.foundCount - 1;
        }
        i = this.foundCount - 1;
        while (i > insertAt) {
            this.foundIndex[i] = this.foundIndex[i] - 1;
            this.foundDistance[i] = this.foundDistance[i];
            --i;
        }
        this.foundIndex[insertAt] = index;
        this.foundDistance[insertAt] = distance;
        this.foundFurthest = distance;
    }
}

