/*
 * Decompiled with CFR 0.152.
 */
package inyo;

import inyo.RtCamera;
import inyo.RtIrradianceCache;
import inyo.RtKdTree;
import inyo.RtLight;
import inyo.RtModel;
import inyo.RtPathNode;
import java.util.ArrayList;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import patterns.Texture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RtWorld {
    static int OCTREE = 0;
    static int KDTREE = 1;
    public static final int PATHTRACE_OFF = 0;
    public static final int PATHTRACE_COSINE = 1;
    public static final int PATHTRACE_HEMISPHERE = 2;
    int subdivisionMethod;
    boolean traceFlag;
    RtCamera camera;
    Matrix4d m4World2Cam;
    Matrix4d m4Cam2World;
    int height;
    int width;
    double scale;
    double progress;
    boolean stopRendering;
    boolean showStats;
    boolean debugOversampling;
    boolean displayIrradianceSamples;
    String outputFormat;
    int maxOctreeDepth;
    int maxOctreeItems;
    boolean multisample;
    int jitter;
    int maxDepth;
    boolean useOversampling;
    boolean useFakeOversampling;
    double colorTolerance;
    boolean useZBuffer;
    boolean useSoftShadows;
    int softShadowSamples;
    boolean useBlackShadows;
    boolean useFakeCaustics;
    boolean useOversampledCaustics;
    boolean useAmbientOcclusion;
    double skyPower;
    Color3f skyColor;
    Color3f skyLightColor;
    Texture skyTexture;
    boolean ambientOcclusionAdditive;
    int ambientOcclusionSamples;
    double ambientOcclusionDistance;
    double colorBleed;
    int pathTracing;
    int pathTracingThetaSamples;
    int pathTracingPhiSamples;
    int pathTracingMaxBounces;
    boolean useFocalBlur;
    double aperture;
    double focalDepth;
    int blurSamples;
    boolean useIrradianceCache;
    int irradianceMaxTreeDepth;
    boolean irradianceSampled;
    double irradianceCacheTolerance;
    double irradianceCacheSpacing;
    double irradianceScale;
    double irradianceCacheMinDistance;
    double irradianceCacheMaxDistance;
    RtIrradianceCache irradianceCache;
    double fov;
    ArrayList lightList;
    ArrayList modelList;
    RtModel currentModel;
    int triangleCount;
    RtKdTree kdTree;
    RtPathNode[] pathNodeList;
    int pathNodeCount;
    int nextRayId;

    RtPathNode getPathNode() {
        int n = 0;
        while (n < this.pathNodeCount) {
            if (!this.pathNodeList[n].inUse) {
                RtPathNode rtPathNode = this.pathNodeList[n];
                rtPathNode.inUse = true;
                rtPathNode.red = 0.0;
                rtPathNode.green = 0.0;
                rtPathNode.blue = 0.0;
                rtPathNode.stopAtFirstHit = true;
                rtPathNode.hit = false;
                rtPathNode.needsOversampling = false;
                rtPathNode.rayId = this.nextRayId++;
                rtPathNode.maxDistance = 0.0;
                rtPathNode.inside = false;
                return rtPathNode;
            }
            ++n;
        }
        System.out.println("Out of path nodes!");
        return null;
    }

    final void setCamera(RtCamera rtCamera) {
        this.camera = rtCamera;
        this.m4World2Cam.set(rtCamera.getMatrix());
        this.m4Cam2World.invert(this.m4World2Cam);
        this.fov = rtCamera.getFocalLength(this.width);
    }

    final RtLight addLight(double d, double d2, double d3, double d4, double d5) {
        Point3d point3d = new Point3d(d, d2, d3);
        this.m4World2Cam.transform(point3d);
        RtLight rtLight = new RtLight(point3d.x, point3d.y, point3d.z, d4, d5 *= this.m4World2Cam.getScale());
        this.lightList.add(rtLight);
        return rtLight;
    }

    final Point3d transformPoint(double d, double d2, double d3) {
        Point3d point3d = new Point3d(d, d2, d3);
        this.m4World2Cam.transform(point3d);
        return point3d;
    }

    final Point3d transformPoint(Point3d point3d) {
        Point3d point3d2 = new Point3d(point3d);
        this.m4World2Cam.transform(point3d2);
        return point3d2;
    }

    final Vector3d transformNormal(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        this.m4World2Cam.transform(vector3d2);
        vector3d2.normalize();
        return vector3d2;
    }

    final Vector3d transformNormal(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.m4World2Cam.transform(vector3d);
        vector3d.normalize();
        return vector3d;
    }

    final void addModel() {
        this.currentModel = new RtModel();
        this.modelList.add(this.currentModel);
    }

    void setSkyTexture(Texture texture) {
        this.skyTexture = texture;
    }

    private final /* synthetic */ void this() {
        this.subdivisionMethod = OCTREE;
        this.traceFlag = false;
        this.camera = new RtCamera();
        this.m4World2Cam = new Matrix4d(this.camera.getMatrix());
        this.m4Cam2World = new Matrix4d();
        this.height = 640;
        this.width = 480;
        this.scale = 1.0;
        this.progress = 0.0;
        this.stopRendering = false;
        this.showStats = true;
        this.debugOversampling = false;
        this.displayIrradianceSamples = true;
        this.outputFormat = new String("png");
        this.maxOctreeDepth = 6;
        this.maxOctreeItems = 14;
        this.multisample = false;
        this.jitter = 1;
        this.maxDepth = 6;
        this.useOversampling = false;
        this.useFakeOversampling = false;
        this.colorTolerance = 30.0;
        this.useZBuffer = false;
        this.useSoftShadows = false;
        this.softShadowSamples = 8;
        this.useBlackShadows = false;
        this.useFakeCaustics = true;
        this.useOversampledCaustics = false;
        this.useAmbientOcclusion = false;
        this.skyPower = 1.0;
        this.skyColor = new Color3f(0.0f, 1.0f, 1.0f);
        this.skyLightColor = new Color3f(1.0f, 1.0f, 1.0f);
        this.ambientOcclusionAdditive = false;
        this.ambientOcclusionSamples = 3;
        this.ambientOcclusionDistance = 1000.0;
        this.colorBleed = 0.25;
        this.pathTracing = 0;
        this.pathTracingThetaSamples = 2;
        this.pathTracingPhiSamples = 2;
        this.pathTracingMaxBounces = 3;
        this.useFocalBlur = false;
        this.aperture = 20.0;
        this.focalDepth = -250.0;
        this.blurSamples = 12;
        this.useIrradianceCache = false;
        this.irradianceMaxTreeDepth = 6;
        this.irradianceSampled = false;
        this.irradianceCacheTolerance = 10.0;
        this.irradianceCacheSpacing = 100.0;
        this.irradianceScale = 0.1;
        this.irradianceCacheMinDistance = 0.5;
        this.irradianceCacheMaxDistance = 10000.0;
        this.lightList = new ArrayList();
        this.modelList = new ArrayList();
        this.currentModel = null;
        this.triangleCount = 0;
        this.kdTree = null;
        this.pathNodeCount = 0;
        this.nextRayId = 1;
    }

    public RtWorld() {
        this.this();
        this.m4Cam2World.invert(this.m4World2Cam);
        this.pathNodeCount = this.maxDepth * 3;
        this.pathNodeList = new RtPathNode[this.pathNodeCount];
        int n = 0;
        while (n < this.pathNodeCount) {
            this.pathNodeList[n] = new RtPathNode();
            ++n;
        }
    }
}

