/*
 * Decompiled with CFR 0.152.
 */
package jpatch.auxilary;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.Functions;

public final class BezierPatch {
    private static float cp0x;
    private static float cp1x;
    private static float cp2x;
    private static float cp3x;
    private static float cp4x;
    private static float cp5x;
    private static float cp6x;
    private static float cp7x;
    private static float cp8x;
    private static float cp9x;
    private static float cp10x;
    private static float cp11x;
    private static float cp12x;
    private static float cp13x;
    private static float cp14x;
    private static float cp15x;
    private static float cp16x;
    private static float cp0y;
    private static float cp1y;
    private static float cp2y;
    private static float cp3y;
    private static float cp4y;
    private static float cp5y;
    private static float cp6y;
    private static float cp7y;
    private static float cp8y;
    private static float cp9y;
    private static float cp10y;
    private static float cp11y;
    private static float cp12y;
    private static float cp13y;
    private static float cp14y;
    private static float cp15y;
    private static float cp16y;
    private static float cp0z;
    private static float cp1z;
    private static float cp2z;
    private static float cp3z;
    private static float cp4z;
    private static float cp5z;
    private static float cp6z;
    private static float cp7z;
    private static float cp8z;
    private static float cp9z;
    private static float cp10z;
    private static float cp11z;
    private static float cp12z;
    private static float cp13z;
    private static float cp14z;
    private static float cp15z;
    private static float cp16z;
    private static int is;
    private static int it;
    private static int rows;
    private static int cols;
    private static float s1;
    private static float s1_2;
    private static float s_2;
    private static float B0s;
    private static float B1s;
    private static float B2s;
    private static float B3s;
    private static float B0ds;
    private static float B1ds;
    private static float B2ds;
    private static float B3ds;
    private static float t1;
    private static float t1_2;
    private static float t_2;
    private static float B0t;
    private static float B1t;
    private static float B2t;
    private static float B3t;
    private static float B0dt;
    private static float B1dt;
    private static float B2dt;
    private static float B3dt;
    private static float px;
    private static float py;
    private static float pz;
    private static float s;
    private static float t;
    private static Vector3f v3ds;
    private static Vector3f v3dt;
    private static float x0;
    private static float x1;
    private static float x2;
    private static float x3;
    private static float y0;
    private static float y1;
    private static float y2;
    private static float y3;
    private static float z0;
    private static float z1;
    private static float z2;
    private static float z3;

    private static final float b0(float f) {
        return (1.0f - f) * (1.0f - f) * (1.0f - f);
    }

    private static final float b1(float f) {
        return (float)3 * f * (1.0f - f) * (1.0f - f);
    }

    private static final float b2(float f) {
        return (float)3 * f * f * (1.0f - f);
    }

    private static final float b3(float f) {
        return f * f * f;
    }

    private static final float db0(float f) {
        return -3.0f * (1.0f - f) * (1.0f - f);
    }

    private static final float db1(float f) {
        return -6.0f * f * (1.0f - f) + (float)3 * (1.0f - f) * (1.0f - f);
    }

    private static final float db2(float f) {
        return -3.0f * f * f + 6.0f * f * (1.0f - f);
    }

    private static final float db3(float f) {
        return (float)3 * f * f;
    }

    private static final void prepare(Point3f[] point3fArray) {
        cp0x = point3fArray[0].x;
        cp1x = point3fArray[1].x;
        cp2x = point3fArray[2].x;
        cp3x = point3fArray[3].x;
        cp4x = point3fArray[4].x;
        cp5x = point3fArray[5].x;
        cp6x = point3fArray[6].x;
        cp7x = point3fArray[7].x;
        cp8x = point3fArray[8].x;
        cp9x = point3fArray[9].x;
        cp10x = point3fArray[10].x;
        cp11x = point3fArray[11].x;
        cp12x = point3fArray[12].x;
        cp13x = point3fArray[13].x;
        cp14x = point3fArray[14].x;
        cp15x = point3fArray[15].x;
        cp0y = point3fArray[0].y;
        cp1y = point3fArray[1].y;
        cp2y = point3fArray[2].y;
        cp3y = point3fArray[3].y;
        cp4y = point3fArray[4].y;
        cp5y = point3fArray[5].y;
        cp6y = point3fArray[6].y;
        cp7y = point3fArray[7].y;
        cp8y = point3fArray[8].y;
        cp9y = point3fArray[9].y;
        cp10y = point3fArray[10].y;
        cp11y = point3fArray[11].y;
        cp12y = point3fArray[12].y;
        cp13y = point3fArray[13].y;
        cp14y = point3fArray[14].y;
        cp15y = point3fArray[15].y;
        cp0z = point3fArray[0].z;
        cp1z = point3fArray[1].z;
        cp2z = point3fArray[2].z;
        cp3z = point3fArray[3].z;
        cp4z = point3fArray[4].z;
        cp5z = point3fArray[5].z;
        cp6z = point3fArray[6].z;
        cp7z = point3fArray[7].z;
        cp8z = point3fArray[8].z;
        cp9z = point3fArray[9].z;
        cp10z = point3fArray[10].z;
        cp11z = point3fArray[11].z;
        cp12z = point3fArray[12].z;
        cp13z = point3fArray[13].z;
        cp14z = point3fArray[14].z;
        cp15z = point3fArray[15].z;
    }

    public static final int evalPatch(Point3f[] point3fArray, Point3f[] point3fArray2, Vector3f[] vector3fArray, int n, int n2) {
        BezierPatch.prepare(point3fArray);
        cols = n;
        rows = n;
        is = 0;
        while (is <= cols) {
            s = (float)is / (float)cols;
            s1 = 1.0f - s;
            s1_2 = s1 * s1;
            s_2 = s * s;
            B0s = s1_2 * s1;
            B1s = (float)3 * s * s1_2;
            B2s = (float)3 * s_2 * s1;
            B3s = s_2 * s;
            B0ds = -3.0f * s1_2;
            B1ds = -6.0f * s * s1 + (float)3 * s1_2;
            B2ds = -3.0f * s_2 + 6.0f * s * s1;
            B3ds = (float)3 * s_2;
            it = 0;
            while (it <= rows) {
                t = (float)it / (float)cols;
                t1 = 1.0f - t;
                t1_2 = t1 * t1;
                t_2 = t * t;
                B0t = t1_2 * t1;
                B1t = (float)3 * t * t1_2;
                B2t = (float)3 * t_2 * t1;
                B3t = t_2 * t;
                B0dt = -3.0f * t1_2;
                B1dt = -6.0f * t * t1 + (float)3 * t1_2;
                B2dt = -3.0f * t_2 + 6.0f * t * t1;
                B3dt = (float)3 * t_2;
                x0 = cp0x * B0t + cp1x * B1t + cp2x * B2t + cp3x * B3t;
                x1 = cp4x * B0t + cp5x * B1t + cp6x * B2t + cp7x * B3t;
                x2 = cp8x * B0t + cp9x * B1t + cp10x * B2t + cp11x * B3t;
                x3 = cp12x * B0t + cp13x * B1t + cp14x * B2t + cp15x * B3t;
                y0 = cp0y * B0t + cp1y * B1t + cp2y * B2t + cp3y * B3t;
                y1 = cp4y * B0t + cp5y * B1t + cp6y * B2t + cp7y * B3t;
                y2 = cp8y * B0t + cp9y * B1t + cp10y * B2t + cp11y * B3t;
                y3 = cp12y * B0t + cp13y * B1t + cp14y * B2t + cp15y * B3t;
                z0 = cp0z * B0t + cp1z * B1t + cp2z * B2t + cp3z * B3t;
                z1 = cp4z * B0t + cp5z * B1t + cp6z * B2t + cp7z * B3t;
                z2 = cp8z * B0t + cp9z * B1t + cp10z * B2t + cp11z * B3t;
                z3 = cp12z * B0t + cp13z * B1t + cp14z * B2t + cp15z * B3t;
                px = B0s * x0 + B1s * x1 + B2s * x2 + B3s * x3;
                py = B0s * y0 + B1s * y1 + B2s * y2 + B3s * y3;
                pz = B0s * z0 + B1s * z1 + B2s * z2 + B3s * z3;
                point3fArray2[n2].set(px, py, pz);
                px = B0ds * x0 + B1ds * x1 + B2ds * x2 + B3ds * x3;
                py = B0ds * y0 + B1ds * y1 + B2ds * y2 + B3ds * y3;
                pz = B0ds * z0 + B1ds * z1 + B2ds * z2 + B3ds * z3;
                v3ds.set(px, py, pz);
                px = B0s * (cp0x * B0dt + cp1x * B1dt + cp2x * B2dt + cp3x * B3dt) + B1s * (cp4x * B0dt + cp5x * B1dt + cp6x * B2dt + cp7x * B3dt) + B2s * (cp8x * B0dt + cp9x * B1dt + cp10x * B2dt + cp11x * B3dt) + B3s * (cp12x * B0dt + cp13x * B1dt + cp14x * B2dt + cp15x * B3dt);
                py = B0s * (cp0y * B0dt + cp1y * B1dt + cp2y * B2dt + cp3y * B3dt) + B1s * (cp4y * B0dt + cp5y * B1dt + cp6y * B2dt + cp7y * B3dt) + B2s * (cp8y * B0dt + cp9y * B1dt + cp10y * B2dt + cp11y * B3dt) + B3s * (cp12y * B0dt + cp13y * B1dt + cp14y * B2dt + cp15y * B3dt);
                pz = B0s * (cp0z * B0dt + cp1z * B1dt + cp2z * B2dt + cp3z * B3dt) + B1s * (cp4z * B0dt + cp5z * B1dt + cp6z * B2dt + cp7z * B3dt) + B2s * (cp8z * B0dt + cp9z * B1dt + cp10z * B2dt + cp11z * B3dt) + B3s * (cp12z * B0dt + cp13z * B1dt + cp14z * B2dt + cp15z * B3dt);
                v3dt.set(px, py, pz);
                vector3fArray[n2].cross(v3dt, v3ds);
                vector3fArray[n2++].normalize();
                ++it;
            }
            ++is;
        }
        return n2;
    }

    public static final Point3f evalPoint(float f, float f2, Point3f[] point3fArray) {
        Point3f point3f = new Point3f();
        point3f.x = BezierPatch.b0(f) * (point3fArray[0].x * BezierPatch.b0(f2) + point3fArray[1].x * BezierPatch.b1(f2) + point3fArray[2].x * BezierPatch.b2(f2) + point3fArray[3].x * BezierPatch.b3(f2)) + BezierPatch.b1(f) * (point3fArray[4].x * BezierPatch.b0(f2) + point3fArray[5].x * BezierPatch.b1(f2) + point3fArray[6].x * BezierPatch.b2(f2) + point3fArray[7].x * BezierPatch.b3(f2)) + BezierPatch.b2(f) * (point3fArray[8].x * BezierPatch.b0(f2) + point3fArray[9].x * BezierPatch.b1(f2) + point3fArray[10].x * BezierPatch.b2(f2) + point3fArray[11].x * BezierPatch.b3(f2)) + BezierPatch.b3(f) * (point3fArray[12].x * BezierPatch.b0(f2) + point3fArray[13].x * BezierPatch.b1(f2) + point3fArray[14].x * BezierPatch.b2(f2) + point3fArray[15].x * BezierPatch.b3(f2));
        point3f.y = BezierPatch.b0(f) * (point3fArray[0].y * BezierPatch.b0(f2) + point3fArray[1].y * BezierPatch.b1(f2) + point3fArray[2].y * BezierPatch.b2(f2) + point3fArray[3].y * BezierPatch.b3(f2)) + BezierPatch.b1(f) * (point3fArray[4].y * BezierPatch.b0(f2) + point3fArray[5].y * BezierPatch.b1(f2) + point3fArray[6].y * BezierPatch.b2(f2) + point3fArray[7].y * BezierPatch.b3(f2)) + BezierPatch.b2(f) * (point3fArray[8].y * BezierPatch.b0(f2) + point3fArray[9].y * BezierPatch.b1(f2) + point3fArray[10].y * BezierPatch.b2(f2) + point3fArray[11].y * BezierPatch.b3(f2)) + BezierPatch.b3(f) * (point3fArray[12].y * BezierPatch.b0(f2) + point3fArray[13].y * BezierPatch.b1(f2) + point3fArray[14].y * BezierPatch.b2(f2) + point3fArray[15].y * BezierPatch.b3(f2));
        point3f.z = BezierPatch.b0(f) * (point3fArray[0].z * BezierPatch.b0(f2) + point3fArray[1].z * BezierPatch.b1(f2) + point3fArray[2].z * BezierPatch.b2(f2) + point3fArray[3].z * BezierPatch.b3(f2)) + BezierPatch.b1(f) * (point3fArray[4].z * BezierPatch.b0(f2) + point3fArray[5].z * BezierPatch.b1(f2) + point3fArray[6].z * BezierPatch.b2(f2) + point3fArray[7].z * BezierPatch.b3(f2)) + BezierPatch.b2(f) * (point3fArray[8].z * BezierPatch.b0(f2) + point3fArray[9].z * BezierPatch.b1(f2) + point3fArray[10].z * BezierPatch.b2(f2) + point3fArray[11].z * BezierPatch.b3(f2)) + BezierPatch.b3(f) * (point3fArray[12].z * BezierPatch.b0(f2) + point3fArray[13].z * BezierPatch.b1(f2) + point3fArray[14].z * BezierPatch.b2(f2) + point3fArray[15].z * BezierPatch.b3(f2));
        return point3f;
    }

    public static final void computeInnerControlPoints(Point3f[] point3fArray) {
        point3fArray[5] = Functions.parallelogram(point3fArray[0], point3fArray[1], point3fArray[4]);
        point3fArray[6] = Functions.parallelogram(point3fArray[3], point3fArray[2], point3fArray[7]);
        point3fArray[9] = Functions.parallelogram(point3fArray[12], point3fArray[8], point3fArray[13]);
        point3fArray[10] = Functions.parallelogram(point3fArray[15], point3fArray[11], point3fArray[14]);
    }

    static {
        v3ds = new Vector3f();
        v3dt = new Vector3f();
    }
}

