/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BMenuSeparator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jpatch.boundary.Animator;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.RendererPrefs;
import jpatch.boundary.filefilters.JPatchFilter;
import jpatch.control.AnimationImporter;
import jpatch.control.importer.JPatchImport;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.Model;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AnimatorMainMenu
extends BMenuBar {
    BMenu menuFile;
    BMenuItem miNew;
    BMenuItem miProperties;
    BMenuItem miExit;
    BMenuItem miLoadTimesheet;
    BMenuItem miRenderFrame;
    BMenuItem miRenderAnim;
    BMenuItem miLoadAudioClip;
    BMenuItem miDumpXml;
    BMenuItem miLoad;
    BMenuItem miSave;
    BMenu menuOptions;
    BMenuItem miPreferences;
    BMenuItem miRendererOptions;
    BMenu menuObjects;
    BMenuItem miAddModel;
    BMenuItem miAddLight;
    static /* synthetic */ Class class$buoy$event$CommandEvent;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    private final void addModel() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strModelDir);
        JPatchFilter jPatchFilter = new JPatchFilter();
        jFileChooser.setFileFilter(jPatchFilter);
        if (jFileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
            String string = jFileChooser.getSelectedFile().getName();
            Model model = new Model();
            new JPatchImport().importModel(model, jFileChooser.getSelectedFile().getPath());
            AnimModel animModel = new AnimModel(model);
            Animator.getInstance().addObject(animModel, string);
            Animator.getInstance().setActiveObject(animModel);
        }
    }

    private final void addLight() {
        AnimLight animLight = new AnimLight();
        Animator.getInstance().addObject(animLight);
        Animator.getInstance().setActiveObject(animLight);
    }

    private final void rendererOptions() {
        RendererPrefs rendererPrefs = new RendererPrefs();
        ((JDialog)rendererPrefs.getComponent()).setLocationRelativeTo(Animator.getInstance().getComponent());
        rendererPrefs.setVisible(true);
    }

    private final void dumpXml() {
        System.out.println(Animator.getInstance().xml());
    }

    private final void load() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strModelDir);
        if (jFileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            Animator.getInstance().NEW();
            new AnimationImporter().loadAnimation(string);
        }
        Animator.getInstance().setPosition(Animator.getInstance().getStart());
        Animator.getInstance().setActiveObject(Animator.getInstance().getActiveCamera());
    }

    private final void save() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strJPatchPath);
        if (jFileChooser.showSaveDialog(MainFrame.getInstance()) == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                bufferedWriter.write(Animator.getInstance().xml().toString());
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Unable to save file \"" + string + "\"\n" + iOException, "Error", 0);
            }
        }
    }

    private final void loadTimesheet() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strJPatchPath);
        if (jFileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            Animator.getInstance().parseTimesheet(string);
        }
    }

    private final void loadAudioClip() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strJPatchPath);
        if (jFileChooser.showOpenDialog(MainFrame.getInstance()) == 0) {
            try {
                DataLine.Info info;
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(jFileChooser.getSelectedFile());
                Class clazz = class$javax$sound$sampled$Clip;
                if (clazz == null) {
                    clazz = class$javax$sound$sampled$Clip = AnimatorMainMenu.class("[Ljavax.sound.sampled.Clip;", false);
                }
                if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, audioInputStream.getFormat()))) {
                    System.err.println("audioformat not supported");
                } else {
                    Clip clip = (Clip)AudioSystem.getLine(info);
                    clip.open(audioInputStream);
                    Animator.getInstance().setClip(clip);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.menuFile = new BMenu("File");
        this.miNew = new BMenuItem("New");
        this.miProperties = new BMenuItem("Properties...");
        this.miExit = new BMenuItem("Exit");
        this.miLoadTimesheet = new BMenuItem("Load JLipsync timesheet...");
        this.miRenderFrame = new BMenuItem("Render current frame");
        this.miRenderAnim = new BMenuItem("Render animation...");
        this.miLoadAudioClip = new BMenuItem("Load audio clip...");
        this.miDumpXml = new BMenuItem("Dump XML...");
        this.miLoad = new BMenuItem("Open...");
        this.miSave = new BMenuItem("Save...");
        this.menuOptions = new BMenu("Options");
        this.miPreferences = new BMenuItem("Preferences...");
        this.miRendererOptions = new BMenuItem("Renderer options...");
        this.menuObjects = new BMenu("Objects");
        this.miAddModel = new BMenuItem("Add model...");
        this.miAddLight = new BMenuItem("Add lightsource");
    }

    public AnimatorMainMenu() {
        this.this();
        Object object = new Object(){

            private final void processEvent() {
                if (JOptionPane.showConfirmDialog(Animator.getInstance().getComponent(), "Are you sure?", "Confirm", 0) == 0) {
                    Animator.getInstance().NEW();
                }
            }
        };
        Class clazz = class$buoy$event$CommandEvent;
        if (clazz == null) {
            clazz = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miNew.addEventLink(clazz, object);
        Class clazz2 = class$buoy$event$CommandEvent;
        if (clazz2 == null) {
            clazz2 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miExit.addEventLink(clazz2, (Object)Animator.getInstance(), "quit");
        Class clazz3 = class$buoy$event$CommandEvent;
        if (clazz3 == null) {
            clazz3 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miAddModel.addEventLink(clazz3, (Object)this, "addModel");
        Class clazz4 = class$buoy$event$CommandEvent;
        if (clazz4 == null) {
            clazz4 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miAddLight.addEventLink(clazz4, (Object)this, "addLight");
        Class clazz5 = class$buoy$event$CommandEvent;
        if (clazz5 == null) {
            clazz5 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miLoadTimesheet.addEventLink(clazz5, (Object)this, "loadTimesheet");
        Class clazz6 = class$buoy$event$CommandEvent;
        if (clazz6 == null) {
            clazz6 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miRenderFrame.addEventLink(clazz6, (Object)Animator.getInstance(), "renderCurrentFrame");
        Class clazz7 = class$buoy$event$CommandEvent;
        if (clazz7 == null) {
            clazz7 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miLoadAudioClip.addEventLink(clazz7, (Object)this, "loadAudioClip");
        Class clazz8 = class$buoy$event$CommandEvent;
        if (clazz8 == null) {
            clazz8 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miRenderAnim.addEventLink(clazz8, (Object)Animator.getInstance(), "renderAnimation");
        Class clazz9 = class$buoy$event$CommandEvent;
        if (clazz9 == null) {
            clazz9 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miPreferences.addEventLink(clazz9, (Object)Animator.getInstance(), "preferences");
        Class clazz10 = class$buoy$event$CommandEvent;
        if (clazz10 == null) {
            clazz10 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miProperties.addEventLink(clazz10, (Object)Animator.getInstance(), "properties");
        Class clazz11 = class$buoy$event$CommandEvent;
        if (clazz11 == null) {
            clazz11 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miDumpXml.addEventLink(clazz11, (Object)this, "dumpXml");
        Class clazz12 = class$buoy$event$CommandEvent;
        if (clazz12 == null) {
            clazz12 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miLoad.addEventLink(clazz12, (Object)this, "load");
        Class clazz13 = class$buoy$event$CommandEvent;
        if (clazz13 == null) {
            clazz13 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miSave.addEventLink(clazz13, (Object)this, "save");
        this.menuFile.add(this.miNew);
        this.menuFile.add(this.miLoad);
        this.menuFile.add(this.miSave);
        this.menuFile.add(new BMenuSeparator());
        this.menuFile.add(this.miLoadTimesheet);
        this.menuFile.add(this.miLoadAudioClip);
        this.menuFile.add(new BMenuSeparator());
        this.menuFile.add(this.miRenderFrame);
        this.menuFile.add(this.miRenderAnim);
        this.menuFile.add(new BMenuSeparator());
        this.menuFile.add(this.miProperties);
        this.menuFile.add(new BMenuSeparator());
        this.menuFile.add(this.miExit);
        this.add(this.menuFile);
        Class clazz14 = class$buoy$event$CommandEvent;
        if (clazz14 == null) {
            clazz14 = class$buoy$event$CommandEvent = AnimatorMainMenu.class("[Lbuoy.event.CommandEvent;", false);
        }
        this.miRendererOptions.addEventLink(clazz14, (Object)this, "rendererOptions");
        this.menuOptions.add(this.miPreferences);
        this.menuOptions.add(this.miRendererOptions);
        this.add(this.menuOptions);
        this.menuObjects.add(this.miAddModel);
        this.menuObjects.add(this.miAddLight);
        this.add(this.menuObjects);
    }
}

