/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import buoy.widget.AWTWidget;
import buoy.widget.BDialog;
import buoy.widget.BTextField;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import jpatch.boundary.Animator;
import jpatch.boundary.JPatchSettings;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.AnimObject;
import jpatch.entity.Camera;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CameraViewport {
    private static JPatchSettings settings = JPatchSettings.getInstance();
    private static int iCurveSubdiv = 5;
    private static float[] cB0;
    private static float[] cB1;
    private static float[] cB2;
    private static float[] cB3;
    private float fNearClip;
    private float fOverScan;
    private ArrayList listObjects;
    private int X;
    private int Y;
    private int mouseX;
    private int mouseY;
    private Robot robot;
    private AnimObject activeObject;
    private boolean bChange;
    private Matrix3d m3Rot;
    private Matrix3d m3RotBackup;
    private double dRoll;
    private double dPitch;
    private double dYaw;
    private VButton buttonPan;
    private VButton buttonWalk;
    private VButton buttonMove;
    private VButton buttonZoom;
    private VButton buttonRoll;
    private VButton buttonObjectRoll;
    private VButton buttonObjectMove;
    private VButton buttonObjectScale;
    private VButton[] aButtons;
    private boolean ignoreMouseMove;
    private JPanel panel;
    private AWTWidget widget;
    private final Camera camera;
    private BufferedImage image;
    private int[] aiActiveFrameBuffer;
    private int iWidth;
    private int iHeight;
    private int color;
    private BDialog dialog;
    private BTextField textName;
    private BTextField textAspectRatio;
    private BTextField textPosX;
    private BTextField textPosY;
    private BTextField textPosZ;
    private BTextField textRotX;
    private BTextField textRotY;
    private BTextField textRotZ;
    private BTextField textFocalLength;

    static void init() {
        cB0 = new float[iCurveSubdiv];
        cB1 = new float[iCurveSubdiv];
        cB2 = new float[iCurveSubdiv];
        cB3 = new float[iCurveSubdiv];
        int n = 0;
        while (n < iCurveSubdiv) {
            float f = (float)n / (float)(iCurveSubdiv - 1);
            CameraViewport.cB0[n] = (1.0f - f) * (1.0f - f) * (1.0f - f);
            CameraViewport.cB1[n] = (float)3 * f * (1.0f - f) * (1.0f - f);
            CameraViewport.cB2[n] = (float)3 * f * f * (1.0f - f);
            CameraViewport.cB3[n] = f * f * f;
            ++n;
        }
    }

    public void setActiveObject(AnimObject animObject) {
        this.activeObject = animObject;
    }

    public AWTWidget getWidget() {
        return this.widget;
    }

    private final void updateImage() {
        this.iWidth = this.panel.getWidth();
        this.iHeight = this.panel.getHeight();
        this.image = new BufferedImage(this.iWidth, this.iHeight, 1);
        this.aiActiveFrameBuffer = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        this.render();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public void rerender() {
        if (this.image == null) {
            this.updateImage();
        } else {
            this.render();
        }
    }

    public void render() {
        Object object;
        float f;
        int n;
        int n2;
        int n3 = this.panel.getWidth();
        int n4 = this.panel.getHeight();
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setColor(CameraViewport.settings.cBackground);
        graphics2D.fillRect(0, 0, n3, n4);
        float f2 = CameraViewport.settings.fRenderAspectWidth / CameraViewport.settings.fRenderAspectHeight;
        if ((float)n3 / f2 < (float)n4) {
            n2 = (int)((float)n3 / this.fOverScan);
            n = (int)((float)n2 / f2);
            f = this.camera.getFocalLength() * (float)n3 / this.fOverScan / this.camera.getFilmSize();
        } else {
            n = (int)((float)n4 / this.fOverScan);
            n2 = (int)((float)n * f2);
            f = this.camera.getFocalLength() * (float)n4 / this.fOverScan / (this.camera.getFilmSize() / f2);
        }
        Matrix4f matrix4f = new Matrix4f(this.camera.getTransform());
        matrix4f.invert();
        Matrix4f matrix4f2 = new Matrix4f();
        Matrix4f matrix4f3 = new Matrix4f(f, 0.0f, 0.0f, 0.0f, 0.0f, -f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f matrix4f4 = new Matrix4f();
        this.X = this.image.getWidth(null) >> 1;
        this.Y = this.image.getHeight(null) >> 1;
        Object object2 = this.listObjects.iterator();
        while (object2.hasNext()) {
            Point3f[] point3fArray;
            AnimObject animObject;
            object = object2.next();
            if (object instanceof AnimModel) {
                animObject = (AnimModel)object;
                matrix4f4.set(animObject.getTransform());
                matrix4f2.setIdentity();
                matrix4f2.mul(matrix4f3);
                matrix4f2.mul(matrix4f);
                matrix4f2.mul(matrix4f4);
                Point3f point3f = new Point3f();
                point3fArray = new Point3f();
                Point3f point3f2 = new Point3f();
                Point3f point3f3 = new Point3f();
                if (Animator.getInstance().getActiveObject() == animObject) {
                    this.setColor(CameraViewport.settings.cSelection);
                } else {
                    this.setColor(CameraViewport.settings.cCurve);
                }
                Curve curve = ((AnimModel)animObject).getModel().getFirstCurve();
                while (curve != null) {
                    if (!curve.getStart().isStartHook()) {
                        ControlPoint controlPoint = curve.getStart();
                        while (controlPoint != null) {
                            if (controlPoint.getNext() != null) {
                                point3f.set(controlPoint.getPosition());
                                point3fArray.set(controlPoint.getOutTangent());
                                point3f2.set(controlPoint.getNext().getInTangent());
                                point3f3.set(controlPoint.getNext().getPosition());
                                matrix4f2.transform(point3f);
                                matrix4f2.transform((Point3f)point3fArray);
                                matrix4f2.transform(point3f2);
                                matrix4f2.transform(point3f3);
                                this.drawCurve3D(graphics2D, point3f, (Point3f)point3fArray, point3f2, point3f3);
                            }
                            controlPoint = controlPoint.getNextCheckNextLoop();
                        }
                    }
                    curve = curve.getNext();
                }
                continue;
            }
            if (!(object instanceof AnimLight)) continue;
            animObject = (AnimLight)object;
            if (Animator.getInstance().getActiveObject() == animObject) {
                this.setColor(CameraViewport.settings.cSelection);
            } else {
                this.setColor(CameraViewport.settings.cCurve);
            }
            matrix4f4.set(animObject.getTransform());
            matrix4f2.setIdentity();
            matrix4f2.mul(matrix4f3);
            matrix4f2.mul(matrix4f);
            matrix4f2.mul(matrix4f4);
            float f3 = 1.0f / (float)Math.sqrt(3);
            point3fArray = new Point3f[]{new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(-f3, -f3, -f3), new Point3f(f3, f3, f3), new Point3f(-f3, -f3, f3), new Point3f(f3, f3, -f3), new Point3f(f3, -f3, -f3), new Point3f(-f3, f3, f3), new Point3f(f3, -f3, f3), new Point3f(-f3, f3, -f3)};
            int n5 = 0;
            while (n5 < point3fArray.length) {
                matrix4f2.transform(point3fArray[n5++]);
            }
            this.drawLine3D(graphics2D, point3fArray[0], point3fArray[1]);
            this.drawLine3D(graphics2D, point3fArray[2], point3fArray[3]);
            this.drawLine3D(graphics2D, point3fArray[4], point3fArray[5]);
            this.drawLine3D(graphics2D, point3fArray[6], point3fArray[7]);
            this.drawLine3D(graphics2D, point3fArray[8], point3fArray[9]);
            this.drawLine3D(graphics2D, point3fArray[10], point3fArray[11]);
            this.drawLine3D(graphics2D, point3fArray[12], point3fArray[13]);
        }
        if (Animator.getInstance().getActiveObject() == this.camera) {
            graphics2D.setColor(CameraViewport.settings.cSelection);
        } else {
            graphics2D.setColor(CameraViewport.settings.cGrid);
        }
        graphics2D.drawRect(n3 - n2 >> 1, n4 - n >> 1, n2, n);
        graphics2D.drawRect((n3 - n2 >> 1) - 1, (n4 - n >> 1) - 1, n2 + 2, n + 2);
        graphics2D.setColor(CameraViewport.settings.cText);
        graphics2D.drawString(this.camera.getName(), 8, 15);
        graphics2D.drawString("Position", 158, 15);
        graphics2D.drawString(this.number(this.camera.getPosition().x) + '/' + this.number(this.camera.getPosition().y) + '/' + this.number(this.camera.getPosition().z), 158, 30);
        graphics2D.drawString("Roll/Pitch/Yaw", 308, 15);
        graphics2D.drawString(this.number(this.camera.getRoll() * 180.0 / Math.PI) + '/' + this.number(this.camera.getPitch() * 180.0 / Math.PI) + '/' + this.number(this.camera.getYaw() * 180.0 / Math.PI), 308, 30);
        graphics2D.drawString("Focal length", 458, 15);
        graphics2D.drawString(this.number(this.camera.getFocalLength()), 458, 30);
        object2 = Animator.getInstance().getActiveObject();
        if (object2 != this.camera) {
            graphics2D.drawString(((AnimObject)object2).getName(), 9, n4 - 25);
            graphics2D.drawString("Position", 158, n4 - 25);
            graphics2D.drawString(this.number(((AnimObject)object2).getPosition().x) + '/' + this.number(((AnimObject)object2).getPosition().y) + '/' + this.number(((AnimObject)object2).getPosition().z), 158, n4 - 10);
            graphics2D.drawString("Roll/Pitch/Yaw", 308, n4 - 25);
            graphics2D.drawString(this.number(((AnimObject)object2).getRoll() * 180.0 / Math.PI) + '/' + this.number(((AnimObject)object2).getPitch() * 180.0 / Math.PI) + '/' + this.number(((AnimObject)object2).getYaw() * 180.0 / Math.PI), 308, n4 - 10);
            graphics2D.drawString("Scale", 458, n4 - 25);
            graphics2D.drawString(this.number(((AnimObject)object2).getScale()), 458, n4 - 10);
        }
        graphics2D.drawString("Frame " + (int)(Animator.getInstance().getPosition() - Animator.getInstance().getStart() + 1.0f), (n3 - n2 >> 1) + 3, (n4 - n >> 1) + 13);
        object = this.buttonZoom.isPressed() ? "zoom camera mode" : (this.buttonRoll.isPressed() ? "roll camera mode" : (this.buttonPan.isPressed() ? "pan camera mode" : (this.buttonWalk.isPressed() ? "dolly camera mode" : (this.buttonMove.isPressed() ? "crane camera mode" : (this.buttonObjectMove.isPressed() ? "move object mode" : (this.buttonObjectRoll.isPressed() ? "rotate object mode" : (this.buttonObjectScale.isPressed() ? "scale object mode" : "")))))));
        graphics2D.drawString((String)object, (n3 - n2 >> 1) + 3, (n4 - n >> 1) + n - 7);
        int n6 = 0;
        while (n6 < this.aButtons.length) {
            this.aButtons[n6++].paint(graphics2D);
        }
        this.panel.getGraphics().drawImage(this.image, 0, 0, this.panel);
    }

    private final String number(double d) {
        double d2 = (double)Math.round(d * 10.0) / 10.0;
        return Double.toString(d2);
    }

    private final void setColor(Color color) {
        this.color = color.getRGB();
    }

    private final void drawLine3D(Graphics2D graphics2D, Point3f point3f, Point3f point3f2) {
        if (point3f.z < this.fNearClip) {
            if (point3f2.z < this.fNearClip) {
                return;
            }
            float f = (this.fNearClip - point3f.z) / (point3f2.z - point3f.z);
            int n = (int)(point3f.x * (1.0f - f) + point3f2.x * f);
            int n2 = (int)(point3f.y * (1.0f - f) + point3f2.y * f);
            int n3 = (int)(point3f2.x / point3f2.z);
            int n4 = (int)(point3f2.y / point3f2.z);
            this.drawLine(n + this.X, n2 + this.Y, n3 + this.X, n4 + this.Y);
        } else if (point3f2.z < this.fNearClip) {
            float f = (this.fNearClip - point3f2.z) / (point3f.z - point3f2.z);
            int n = (int)(point3f2.x * (1.0f - f) + point3f.x * f);
            int n5 = (int)(point3f2.y * (1.0f - f) + point3f.y * f);
            int n6 = (int)(point3f.x / point3f.z);
            int n7 = (int)(point3f.y / point3f.z);
            this.drawLine(n6 + this.X, n7 + this.Y, n + this.X, n5 + this.Y);
        } else {
            int n = (int)(point3f.x / point3f.z);
            int n8 = (int)(point3f.y / point3f.z);
            int n9 = (int)(point3f2.x / point3f2.z);
            int n10 = (int)(point3f2.y / point3f2.z);
            this.drawLine(n + this.X, n8 + this.Y, n9 + this.X, n10 + this.Y);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        if (n < 0 && n3 < 0 || n2 < 0 && n4 < 0 || n >= this.iWidth && n3 >= this.iWidth || n2 >= this.iHeight && n4 >= this.iHeight) {
            return;
        }
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            return;
        }
        if (Math.abs(n5) > Math.abs(n6)) {
            int n7;
            int n8;
            int n9;
            if (n5 > 0) {
                n9 = n;
                n8 = n2 << 32784;
                n6 = (n6 << 16) / n5;
                n7 = n3 < this.iWidth ? n3 : this.iWidth;
            } else {
                n9 = n3;
                n8 = n4 << 32784;
                n6 = (n6 << 16) / n5;
                int n10 = n7 = n < this.iWidth ? n : this.iWidth;
            }
            if (n9 < 0) {
                n8 -= n6 * n9;
                n9 = 0;
            }
            int n11 = this.iHeight << 16;
            while (n9 < n7) {
                if (n8 >= 0 && n8 < n11) {
                    int n12 = this.iWidth * (n8 >> 16) + n9;
                    this.aiActiveFrameBuffer[n12] = this.color;
                }
                ++n9;
                n8 += n6;
            }
        } else {
            int n13;
            int n14;
            int n15;
            if (n6 > 0) {
                n15 = n2;
                n14 = n << 32784;
                n5 = (n5 << 16) / n6;
                n13 = n4 < this.iHeight ? n4 : this.iHeight;
            } else {
                n15 = n4;
                n14 = n3 << 32784;
                n5 = (n5 << 16) / n6;
                int n16 = n13 = n2 < this.iHeight ? n2 : this.iHeight;
            }
            if (n15 < 0) {
                n14 -= n5 * n15;
                n15 = 0;
            }
            int n17 = this.iWidth << 16;
            while (n15 < n13) {
                if (n14 >= 0 && n14 < n17) {
                    int n18 = this.iWidth * n15 + (n14 >> 16);
                    this.aiActiveFrameBuffer[n18] = this.color;
                }
                ++n15;
                n14 += n5;
            }
        }
    }

    private final void drawCurve3D(Graphics2D graphics2D, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        Point3f point3f5 = new Point3f(point3f);
        Point3f point3f6 = new Point3f();
        int n = 0;
        while (n < iCurveSubdiv - 1) {
            point3f6.set(cB0[n] * point3f.x + cB1[n] * point3f2.x + cB2[n] * point3f3.x + cB3[n] * point3f4.x, cB0[n] * point3f.y + cB1[n] * point3f2.y + cB2[n] * point3f3.y + cB3[n] * point3f4.y, cB0[n] * point3f.z + cB1[n] * point3f2.z + cB2[n] * point3f3.z + cB3[n] * point3f4.z);
            this.drawLine3D(graphics2D, point3f5, point3f6);
            point3f5.set(point3f6);
            ++n;
        }
        this.drawLine3D(graphics2D, point3f5, point3f4);
    }

    static /* synthetic */ boolean access$10(CameraViewport cameraViewport) {
        return cameraViewport.bChange;
    }

    private final /* synthetic */ void this() {
        this.fNearClip = 1.0f;
        this.fOverScan = 1.2f;
        this.activeObject = null;
        this.m3Rot = new Matrix3d();
        this.m3RotBackup = new Matrix3d();
        this.buttonPan = new VButton(-40, 10, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/pan.png")).getImage());
        this.buttonWalk = new VButton(-40, 50, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/walk.png")).getImage());
        this.buttonMove = new VButton(-40, 90, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/move.png")).getImage());
        this.buttonZoom = new VButton(-40, 130, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/zoom.png")).getImage());
        this.buttonRoll = new VButton(-40, 170, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/roll.png")).getImage());
        this.buttonObjectRoll = new VButton(-40, 250, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/rotateobject.png")).getImage());
        this.buttonObjectMove = new VButton(-40, 290, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/moveobject.png")).getImage());
        this.buttonObjectScale = new VButton(-40, 330, 31, 31, new ImageIcon(ClassLoader.getSystemResource("jpatch/images/anim/scaleobject.png")).getImage());
        this.aButtons = new VButton[]{this.buttonPan, this.buttonWalk, this.buttonMove, this.buttonZoom, this.buttonRoll, this.buttonObjectRoll, this.buttonObjectMove, this.buttonObjectScale};
        this.ignoreMouseMove = false;
        this.panel = new JPanel(){

            public final void paintComponent(Graphics graphics) {
                if (CameraViewport.this.image == null || CameraViewport.this.image.getWidth(null) != CameraViewport.this.panel.getWidth() || CameraViewport.this.image.getHeight(null) != CameraViewport.this.panel.getHeight()) {
                    CameraViewport.this.updateImage();
                }
                graphics.drawImage(CameraViewport.this.image, 0, 0, this);
            }
        };
        this.widget = new AWTWidget(this.panel);
    }

    public CameraViewport(Camera camera, ArrayList arrayList) {
        this.this();
        this.camera = camera;
        this.listObjects = arrayList;
        try {
            this.robot = new Robot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.panel.addMouseMotionListener(new MouseMotionAdapter(){

            public final void mouseMoved(MouseEvent mouseEvent) {
            }

            public final void mouseDragged(MouseEvent mouseEvent) {
                Point3d point3d;
                Matrix3d matrix3d;
                float f;
                AnimObject animObject = Animator.getInstance().getActiveObject();
                int n = mouseEvent.getX() - CameraViewport.this.mouseX;
                int n2 = mouseEvent.getY() - CameraViewport.this.mouseY;
                CameraViewport.this.mouseX = mouseEvent.getX();
                CameraViewport.this.mouseY = mouseEvent.getY();
                if (CameraViewport.this.ignoreMouseMove) {
                    return;
                }
                if (CameraViewport.this.buttonZoom.isPressed()) {
                    f = Math.min(2.0f, (float)Math.max(0.5, (double)(1.0f + (float)n / 500.0f - (float)n2 / 500.0f)));
                    CameraViewport.this.camera.setFocalLength(CameraViewport.this.camera.getFocalLength() * f);
                    CameraViewport.this.bChange = true;
                    CameraViewport.this.rerender();
                }
                if (CameraViewport.this.buttonWalk.isPressed()) {
                    Vector3d vector3d = new Vector3d(0.0, 0.0, (double)n2 * Math.sqrt(Math.abs(n2)) * -0.05);
                    matrix3d = new Matrix3d();
                    CameraViewport.this.camera.getTransform().getRotationScale(matrix3d);
                    matrix3d.transform(vector3d);
                    point3d = CameraViewport.this.camera.getPosition();
                    point3d.add(vector3d);
                    CameraViewport.this.camera.setPosition(point3d);
                    CameraViewport.this.bChange = true;
                    CameraViewport.this.rerender();
                }
                if (CameraViewport.this.buttonMove.isPressed()) {
                    Vector3d vector3d = new Vector3d((double)n * Math.sqrt(Math.abs(n)) * 0.01, (double)n2 * Math.sqrt(Math.abs(n2)) * -0.01, 0.0);
                    matrix3d = new Matrix3d();
                    CameraViewport.this.camera.getTransform().getRotationScale(matrix3d);
                    matrix3d.transform(vector3d);
                    point3d = CameraViewport.this.camera.getPosition();
                    point3d.add(vector3d);
                    CameraViewport.this.camera.setPosition(point3d);
                    CameraViewport.this.bChange = true;
                    CameraViewport.this.rerender();
                }
                if (CameraViewport.this.buttonPan.isPressed()) {
                    CameraViewport cameraViewport = CameraViewport.this;
                    cameraViewport.dPitch = cameraViewport.dPitch - (double)n2 * 0.1 / (double)CameraViewport.this.camera.getFocalLength();
                    CameraViewport cameraViewport2 = CameraViewport.this;
                    cameraViewport2.dYaw = cameraViewport2.dYaw + (double)n * 0.1 / (double)CameraViewport.this.camera.getFocalLength();
                    CameraViewport.this.camera.setOrientation(CameraViewport.this.dRoll, CameraViewport.this.dPitch, CameraViewport.this.dYaw);
                    CameraViewport.this.bChange = true;
                    CameraViewport.this.rerender();
                }
                if (CameraViewport.this.buttonRoll.isPressed()) {
                    CameraViewport cameraViewport = CameraViewport.this;
                    cameraViewport.dRoll = cameraViewport.dRoll - (double)n * -0.003;
                    CameraViewport.this.camera.setOrientation(CameraViewport.this.dRoll, CameraViewport.this.dPitch, CameraViewport.this.dYaw);
                    CameraViewport.this.bChange = true;
                    CameraViewport.this.rerender();
                }
                if (animObject != CameraViewport.this.camera) {
                    if (CameraViewport.this.buttonObjectMove.isPressed()) {
                        Point3d point3d2 = animObject.getPosition();
                        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                            point3d2.z += (double)n2 * 0.5;
                        } else {
                            point3d2.x += (double)n * 0.5;
                            point3d2.y -= (double)n2 * 0.5;
                        }
                        animObject.setPosition(point3d2);
                        CameraViewport.this.rerender();
                    }
                    if (CameraViewport.this.buttonObjectRoll.isPressed()) {
                        double d = animObject.getRoll();
                        double d2 = animObject.getPitch();
                        double d3 = animObject.getYaw();
                        if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                            d += (double)n2 * 0.01;
                        } else if (Math.abs(n) > Math.abs(n2)) {
                            d3 -= (double)n * 0.01;
                        } else {
                            d2 += (double)n2 * 0.01;
                        }
                        animObject.setOrientation(d, d2, d3);
                        CameraViewport.this.rerender();
                    }
                    if (CameraViewport.this.buttonObjectScale.isPressed()) {
                        f = 1.0f + (float)(n - n2) * 0.01f;
                        if (f < 0.5f) {
                            f = 0.5f;
                        }
                        if (f > 2.0f) {
                            f = 2.0f;
                        }
                        animObject.setScale(animObject.getScale() * f);
                        CameraViewport.this.rerender();
                    }
                }
            }
        });
        this.panel.addMouseListener(new MouseAdapter(){

            public final void mouseExited(MouseEvent mouseEvent) {
                CameraViewport.this.ignoreMouseMove = false;
            }

            public final void mousePressed(MouseEvent mouseEvent) {
                CameraViewport.this.mouseX = mouseEvent.getX();
                CameraViewport.this.mouseY = mouseEvent.getY();
                CameraViewport.this.bChange = false;
                if (mouseEvent.getButton() == 1) {
                    int n = -1;
                    int n2 = 0;
                    while (n2 < CameraViewport.this.aButtons.length) {
                        if (CameraViewport.this.aButtons[n2].isHit(CameraViewport.this.mouseX, CameraViewport.this.mouseY)) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (n != -1) {
                        CameraViewport.this.ignoreMouseMove = true;
                        n2 = 0;
                        while (n2 < CameraViewport.this.aButtons.length) {
                            VButton vButton = CameraViewport.this.aButtons[n2];
                            boolean bl = false;
                            if (n == n2) {
                                bl = true;
                            }
                            vButton.setPressedState(bl);
                            ++n2;
                        }
                        CameraViewport.this.rerender();
                    }
                }
                CameraViewport.this.dRoll = CameraViewport.this.camera.getRoll();
                CameraViewport.this.dPitch = CameraViewport.this.camera.getPitch();
                CameraViewport.this.dYaw = CameraViewport.this.camera.getYaw();
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                CameraViewport.this.ignoreMouseMove = false;
                Animator.getInstance().updateCurvesFor(CameraViewport.this.camera);
                if (CameraViewport.this.activeObject != CameraViewport.this.camera) {
                    Animator.getInstance().updateCurvesFor(Animator.getInstance().getActiveObject());
                }
            }
        });
        this.panel.setPreferredSize(new Dimension(640, 480));
    }

    static {
        CameraViewport.init();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class VButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private Image image;
        private boolean pressed;

        private final void setPressedState(boolean bl) {
            this.pressed = bl;
            Graphics graphics = CameraViewport.this.panel.getGraphics();
            int n = this.x < 0 ? CameraViewport.this.panel.getWidth() + this.x : this.x;
            int n2 = this.y < 0 ? CameraViewport.this.panel.getHeight() + this.y : this.y;
            graphics.setColor(new Color(0xFFFFFF));
            graphics.draw3DRect(n, n2, this.w, this.h, bl ^ true);
        }

        private final boolean isPressed() {
            return this.pressed;
        }

        private final boolean isHit(int n, int n2) {
            int n3 = this.x < 0 ? CameraViewport.this.panel.getWidth() + this.x : this.x;
            int n4 = this.y < 0 ? CameraViewport.this.panel.getHeight() + this.y : this.y;
            boolean bl = false;
            if (n > n3 && n < n3 + this.w && n2 > n4 && n2 < n4 + this.h) {
                bl = true;
            }
            return bl;
        }

        private final void paint(Graphics graphics) {
            int n = this.x < 0 ? CameraViewport.this.panel.getWidth() + this.x : this.x;
            int n2 = this.y < 0 ? CameraViewport.this.panel.getHeight() + this.y : this.y;
            graphics.setColor(new Color(0xFFFFFF));
            graphics.drawImage(this.image, n, n2, null);
            graphics.draw3DRect(n, n2, this.w, this.h, this.pressed ^ true);
        }

        private VButton(int n, int n2, int n3, int n4, Image image) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.image = image;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MyCursor
    extends Cursor {
        public MyCursor() {
            super("test");
            int n = 0;
            while (n < predefined.length) {
                System.out.println("" + n + ' ' + predefined[n]);
                ++n;
            }
        }
    }
}

