/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpatch.boundary.ColorButton;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ColorPreferences
extends JDialog
implements ActionListener,
WindowListener {
    private JButton buttonBackground;
    private JButton buttonPoint;
    private JButton buttonCurve;
    private JButton buttonHeadPoint;
    private JButton buttonMultiPoint;
    private JButton buttonSelectedPoint;
    private JButton buttonHotPoint;
    private JButton buttonSelection;
    private JButton buttonText;
    private JButton buttonGrid;
    private JButton buttonMinorGrid;
    private JButton buttonXAxis;
    private JButton buttonYAxis;
    private JButton buttonZAxis;
    private JButton buttonTangent;
    private JButton buttonBackface;
    private JButton buttonOK;
    private JButton buttonDefaults;
    private JButton buttonCancel;
    private Map mapping;
    private ArrayList list;
    private JPatchColor cBackground;
    private JPatchColor cPoint;
    private JPatchColor cCurve;
    private JPatchColor cHeadPoint;
    private JPatchColor cMultiPoint;
    private JPatchColor cSelected;
    private JPatchColor cHot;
    private JPatchColor cSelection;
    private JPatchColor cText;
    private JPatchColor cGrid;
    private JPatchColor cGridMin;
    private JPatchColor cX;
    private JPatchColor cY;
    private JPatchColor cZ;
    private JPatchColor cTangent;
    private JPatchColor cBackface;
    private JPanel colorPanel;
    private JPanel buttonPanel;
    private Color[] colors;
    private boolean bChanged;

    public static void main(String[] stringArray) {
        ColorPreferences colorPreferences = new ColorPreferences(null);
    }

    private final void setButtonColors() {
        Iterator iterator = this.mapping.keySet().iterator();
        while (iterator.hasNext()) {
            JButton jButton = (JButton)iterator.next();
            JPatchColor jPatchColor = (JPatchColor)this.mapping.get(jButton);
            jButton.setBackground(jPatchColor.getColor());
        }
    }

    private final void setColors(Color[] colorArray) {
        this.cBackground.setColor(colorArray[0]);
        this.cPoint.setColor(colorArray[1]);
        this.cCurve.setColor(colorArray[2]);
        this.cHeadPoint.setColor(colorArray[3]);
        this.cMultiPoint.setColor(colorArray[4]);
        this.cSelected.setColor(colorArray[5]);
        this.cHot.setColor(colorArray[6]);
        this.cSelection.setColor(colorArray[7]);
        this.cText.setColor(colorArray[8]);
        this.cGrid.setColor(colorArray[9]);
        this.cGridMin.setColor(colorArray[10]);
        this.cX.setColor(colorArray[11]);
        this.cY.setColor(colorArray[12]);
        this.cZ.setColor(colorArray[13]);
        this.cTangent.setColor(colorArray[14]);
        this.cBackface.setColor(colorArray[15]);
    }

    private final Color[] getColors() {
        return new Color[]{this.cBackground.getColor(), this.cPoint.getColor(), this.cCurve.getColor(), this.cHeadPoint.getColor(), this.cMultiPoint.getColor(), this.cSelected.getColor(), this.cHot.getColor(), this.cSelection.getColor(), this.cText.getColor(), this.cGrid.getColor(), this.cGridMin.getColor(), this.cX.getColor(), this.cY.getColor(), this.cZ.getColor(), this.cTangent.getColor(), this.cBackface.getColor()};
    }

    private final void ok() {
        if (!this.bChanged) {
            this.dispose();
        } else {
            int n = JOptionPane.showConfirmDialog(this, "Do you want to keep the color changes you've made?", "Are you sure?", 0);
            if (n == 0) {
                this.dispose();
            }
        }
    }

    private final void defaults() {
        int n = JOptionPane.showConfirmDialog(this, "This will reset all colors to their default values. Proceed?", "Are you sure?", 0);
        if (n == 0) {
            this.setColors(JPatchSettings.getInstance().getDefaultColors());
            JPatchSettings.getInstance().setColors(this.getColors());
            this.setButtonColors();
            MainFrame.getInstance().getJPatchScreen().update_all();
            this.bChanged = false;
            this.colors = this.getColors();
        }
    }

    private final void cancel() {
        if (!this.bChanged) {
            this.dispose();
        } else {
            int n = JOptionPane.showConfirmDialog(this, "This will revert to the old colors and you'd loose all changes to the colors you've made. Proceed?", "Are you sure?", 0);
            if (n == 0) {
                JPatchSettings.getInstance().setColors(this.colors);
                this.dispose();
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
        }
    }

    private final void close() {
        if (!this.bChanged) {
            this.dispose();
        } else {
            int n = JOptionPane.showConfirmDialog(this, "Do you want to keep the color changes you've made?", "Are you sure?", 0);
            if (n == 1) {
                JPatchSettings.getInstance().setColors(this.colors);
                MainFrame.getInstance().getJPatchScreen().update_all();
            }
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.buttonCancel) {
            this.cancel();
        } else if (jButton == this.buttonOK) {
            this.ok();
        } else if (jButton == this.buttonDefaults) {
            this.defaults();
        } else {
            JPatchColor jPatchColor = (JPatchColor)this.mapping.get(actionEvent.getSource());
            Color color = JColorChooser.showDialog(this, jPatchColor.getName(), jPatchColor.getColor());
            if (color != null) {
                jPatchColor.setColor(color);
                JPatchSettings.getInstance().setColors(this.getColors());
                this.setButtonColors();
                MainFrame.getInstance().getJPatchScreen().update_all();
                this.bChanged = true;
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    private final /* synthetic */ void this() {
        this.buttonBackground = new ColorButton();
        this.buttonPoint = new ColorButton();
        this.buttonCurve = new ColorButton();
        this.buttonHeadPoint = new ColorButton();
        this.buttonMultiPoint = new ColorButton();
        this.buttonSelectedPoint = new ColorButton();
        this.buttonHotPoint = new ColorButton();
        this.buttonSelection = new ColorButton();
        this.buttonText = new ColorButton();
        this.buttonGrid = new ColorButton();
        this.buttonMinorGrid = new ColorButton();
        this.buttonXAxis = new ColorButton();
        this.buttonYAxis = new ColorButton();
        this.buttonZAxis = new ColorButton();
        this.buttonTangent = new ColorButton();
        this.buttonBackface = new ColorButton();
        this.buttonOK = new JButton("OK");
        this.buttonDefaults = new JButton("Defaults");
        this.buttonCancel = new JButton("Cancel");
        this.mapping = new HashMap();
        this.list = new ArrayList();
        this.cBackground = new JPatchColor("Background");
        this.cPoint = new JPatchColor("Unattached points");
        this.cCurve = new JPatchColor("Curves");
        this.cHeadPoint = new JPatchColor("Points");
        this.cMultiPoint = new JPatchColor("Multiattached points");
        this.cSelected = new JPatchColor("Selected points");
        this.cHot = new JPatchColor("Hot point");
        this.cSelection = new JPatchColor("Tools");
        this.cText = new JPatchColor("Text");
        this.cGrid = new JPatchColor("Grid (major)");
        this.cGridMin = new JPatchColor("Grid (minor)");
        this.cX = new JPatchColor("X Axis");
        this.cY = new JPatchColor("Y Axis");
        this.cZ = new JPatchColor("Z Axis");
        this.cTangent = new JPatchColor("Tangents");
        this.cBackface = new JPatchColor("Backfacing patches");
        this.colorPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.colors = JPatchSettings.getInstance().getColors();
        this.bChanged = false;
    }

    public ColorPreferences(Frame frame) {
        super(frame, "Color settings", true);
        this.this();
        this.setColors(JPatchSettings.getInstance().getColors());
        this.mapping.put(this.buttonBackground, this.cBackground);
        this.mapping.put(this.buttonText, this.cText);
        this.mapping.put(this.buttonGrid, this.cGrid);
        this.mapping.put(this.buttonMinorGrid, this.cGridMin);
        this.mapping.put(this.buttonCurve, this.cCurve);
        this.mapping.put(this.buttonHeadPoint, this.cHeadPoint);
        this.mapping.put(this.buttonPoint, this.cPoint);
        this.mapping.put(this.buttonMultiPoint, this.cMultiPoint);
        this.mapping.put(this.buttonSelectedPoint, this.cSelected);
        this.mapping.put(this.buttonHotPoint, this.cHot);
        this.mapping.put(this.buttonSelection, this.cSelection);
        this.mapping.put(this.buttonXAxis, this.cX);
        this.mapping.put(this.buttonYAxis, this.cY);
        this.mapping.put(this.buttonZAxis, this.cZ);
        this.mapping.put(this.buttonTangent, this.cTangent);
        this.mapping.put(this.buttonBackface, this.cBackface);
        this.list.add(this.buttonBackground);
        this.list.add(this.buttonText);
        this.list.add(this.buttonGrid);
        this.list.add(this.buttonMinorGrid);
        this.list.add(this.buttonCurve);
        this.list.add(this.buttonHeadPoint);
        this.list.add(this.buttonPoint);
        this.list.add(this.buttonMultiPoint);
        this.list.add(this.buttonSelectedPoint);
        this.list.add(this.buttonHotPoint);
        this.list.add(this.buttonSelection);
        this.list.add(this.buttonXAxis);
        this.list.add(this.buttonYAxis);
        this.list.add(this.buttonZAxis);
        this.list.add(this.buttonTangent);
        this.list.add(this.buttonBackface);
        this.setButtonColors();
        GridLayout gridLayout = new GridLayout(this.list.size(), 2);
        gridLayout.setHgap(20);
        gridLayout.setVgap(4);
        this.colorPanel.setLayout(gridLayout);
        this.colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            JButton jButton = (JButton)iterator.next();
            JPatchColor jPatchColor = (JPatchColor)this.mapping.get(jButton);
            this.colorPanel.add(new JLabel(jPatchColor.getName()));
            this.colorPanel.add(jButton);
            jButton.addActionListener(this);
        }
        this.buttonPanel.add(this.buttonOK);
        this.buttonPanel.add(this.buttonDefaults);
        this.buttonPanel.add(this.buttonCancel);
        this.buttonOK.addActionListener(this);
        this.buttonDefaults.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.colorPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.show();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JPatchColor {
        private int iRGB;
        private String strName;

        public void setColor(Color color) {
            this.iRGB = color.getRGB();
        }

        public Color getColor() {
            return new Color(this.iRGB);
        }

        public String getName() {
            return this.strName;
        }

        public JPatchColor(String string) {
            this.strName = string;
        }
    }
}

