/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jpatch.boundary.MainFrame;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.action.AlignAction;
import jpatch.boundary.action.AlignPatchesAction;
import jpatch.boundary.action.AlwaysUseZBufferAction;
import jpatch.boundary.action.ApplyMaterialAction;
import jpatch.boundary.action.AutoMirrorAction;
import jpatch.boundary.action.ChangeTangentModeAction;
import jpatch.boundary.action.ClearRotoscopeAction;
import jpatch.boundary.action.ClearViewLockAction;
import jpatch.boundary.action.ExtendSelectionAction;
import jpatch.boundary.action.FlipAction;
import jpatch.boundary.action.FlipPatchesAction;
import jpatch.boundary.action.InvertSelectionAction;
import jpatch.boundary.action.LightingHeadAction;
import jpatch.boundary.action.LightingOffAction;
import jpatch.boundary.action.LightingSimpleAction;
import jpatch.boundary.action.LightingStickyAction;
import jpatch.boundary.action.LightingThreePointAction;
import jpatch.boundary.action.SelectAllAction;
import jpatch.boundary.action.SelectNoneAction;
import jpatch.boundary.action.SetRotoscopeAction;
import jpatch.boundary.action.SetViewLockAction;
import jpatch.boundary.action.ShowBezierAction;
import jpatch.boundary.action.ShowCurvesAction;
import jpatch.boundary.action.ShowPatchesAction;
import jpatch.boundary.action.ShowPointsAction;
import jpatch.boundary.action.ShowRotoscopeAction;
import jpatch.boundary.action.ViewAction;
import jpatch.boundary.action.ZBufferQualityAction;

public class JPatchPopupMenu
extends JPopupMenu {
    private JMenu menuShow;
    private JMenu menuView;
    private JMenu menuZBuffer;
    private JMenu menuLight;
    private JMenu menuRotoscope;
    private JMenu menuSelection;
    private JMenu menuTangents;
    private JMenu menuTools;
    private JCheckBoxMenuItem miPoints;
    private JCheckBoxMenuItem miCurves;
    private JCheckBoxMenuItem miPatches;
    private JCheckBoxMenuItem miRotoscope;
    private JCheckBoxMenuItem miBezier;
    private JCheckBoxMenuItem miZBuffer;
    private JCheckBoxMenuItem miLightOff;
    private JCheckBoxMenuItem miLightSimple;
    private JCheckBoxMenuItem miLightHead;
    private JCheckBoxMenuItem miLightThreePoint;
    private JCheckBoxMenuItem miLightSticky;
    private JMenuItem miSetRotoscope;
    private JMenuItem miClearRotoscope;

    public JPatchPopupMenu(ViewDefinition viewDefinition) {
        JMenuItem jMenuItem;
        this.miPoints = new JCheckBoxMenuItem(new ShowPointsAction(viewDefinition));
        this.miCurves = new JCheckBoxMenuItem(new ShowCurvesAction(viewDefinition));
        this.miPatches = new JCheckBoxMenuItem(new ShowPatchesAction(viewDefinition));
        this.miBezier = new JCheckBoxMenuItem(new ShowBezierAction(viewDefinition));
        this.miRotoscope = new JCheckBoxMenuItem(new ShowRotoscopeAction(viewDefinition));
        this.miZBuffer = new JCheckBoxMenuItem(new AlwaysUseZBufferAction(viewDefinition));
        this.miLightOff = new JCheckBoxMenuItem(new LightingOffAction(MainFrame.getInstance().getJPatchScreen()));
        this.miLightSimple = new JCheckBoxMenuItem(new LightingSimpleAction(MainFrame.getInstance().getJPatchScreen()));
        this.miLightHead = new JCheckBoxMenuItem(new LightingHeadAction(MainFrame.getInstance().getJPatchScreen()));
        this.miLightThreePoint = new JCheckBoxMenuItem(new LightingThreePointAction(MainFrame.getInstance().getJPatchScreen()));
        this.miLightSticky = new JCheckBoxMenuItem(new LightingStickyAction(MainFrame.getInstance().getJPatchScreen()));
        this.miPoints.setState(viewDefinition.renderPoints());
        this.miCurves.setState(viewDefinition.renderCurves());
        this.miPatches.setState(viewDefinition.renderPatches());
        this.miRotoscope.setState(viewDefinition.showRotoscope());
        this.miBezier.setState(viewDefinition.renderBezierCPs());
        this.miZBuffer.setState(viewDefinition.alwaysUseZBuffer());
        boolean bl = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 0) {
            bl = true;
        }
        this.miLightOff.setState(bl);
        boolean bl2 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 1) {
            bl2 = true;
        }
        this.miLightSimple.setState(bl2);
        boolean bl3 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 2) {
            bl3 = true;
        }
        this.miLightHead.setState(bl3);
        boolean bl4 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 3) {
            bl4 = true;
        }
        this.miLightThreePoint.setState(bl4);
        this.miLightSticky.setState(MainFrame.getInstance().getJPatchScreen().isStickyLight());
        this.menuShow = new JMenu("show");
        this.menuShow.add(this.miPoints);
        this.menuShow.add(this.miCurves);
        this.menuShow.add(this.miPatches);
        this.menuShow.add(this.miRotoscope);
        this.menuShow.add(this.miBezier);
        this.menuView = new JMenu("view");
        int n = 1;
        while (n <= 7) {
            jMenuItem = new JRadioButtonMenuItem(new ViewAction(viewDefinition, n));
            if (viewDefinition.getView() == n) {
                jMenuItem.setSelected(true);
            }
            this.menuView.add(jMenuItem);
            ++n;
        }
        this.menuZBuffer = new JMenu("z-buffer renderer");
        this.menuLight = new JMenu("light");
        this.menuLight.add(this.miLightOff);
        this.menuLight.add(this.miLightSimple);
        this.menuLight.add(this.miLightHead);
        this.menuLight.add(this.miLightThreePoint);
        this.menuLight.addSeparator();
        this.menuLight.add(this.miLightSticky);
        this.menuZBuffer.add(this.miZBuffer);
        this.menuZBuffer.add(this.menuLight);
        this.menuZBuffer.add(new ZBufferQualityAction());
        this.menuRotoscope = new JMenu("rotoscope");
        this.miSetRotoscope = new JMenuItem(new SetRotoscopeAction(viewDefinition));
        this.miClearRotoscope = new JMenuItem(new ClearRotoscopeAction(viewDefinition));
        this.menuRotoscope.add(this.miSetRotoscope);
        this.menuRotoscope.add(this.miClearRotoscope);
        if (viewDefinition.getView() == 7) {
            this.miSetRotoscope.setEnabled(false);
        }
        if (MainFrame.getInstance().getModel().getRotoscope(viewDefinition.getView()) == null) {
            this.miClearRotoscope.setEnabled(false);
        }
        this.menuSelection = new JMenu("selection");
        this.menuTools = new JMenu("tools");
        this.menuTangents = new JMenu("tangents");
        JMenuItem jMenuItem2 = new JMenuItem(new SelectNoneAction());
        jMenuItem = new JMenuItem(new ExtendSelectionAction());
        JMenuItem jMenuItem3 = new JMenuItem(new InvertSelectionAction());
        JMenuItem jMenuItem4 = new JMenuItem(new ClearViewLockAction(viewDefinition));
        jMenuItem4.setEnabled(viewDefinition.isLocked());
        JMenuItem jMenuItem5 = new JMenuItem(new SetViewLockAction(viewDefinition));
        if (MainFrame.getInstance().getPointSelection() == null) {
            jMenuItem2.setEnabled(false);
            jMenuItem.setEnabled(false);
            jMenuItem3.setEnabled(false);
            this.menuTools.setEnabled(false);
            this.menuTangents.setEnabled(false);
            jMenuItem5.setEnabled(false);
        }
        this.menuSelection.add(jMenuItem2);
        this.menuSelection.add(new SelectAllAction());
        this.menuSelection.add(jMenuItem3);
        this.menuSelection.add(jMenuItem);
        this.menuSelection.add(new ApplyMaterialAction());
        this.menuTangents.add(new ChangeTangentModeAction(0));
        this.menuTangents.add(new ChangeTangentModeAction(1));
        this.menuTangents.add(new ChangeTangentModeAction(2));
        this.menuTools.add(new FlipAction(0));
        this.menuTools.add(new FlipAction(1));
        this.menuTools.add(new FlipAction(2));
        this.menuTools.add(new AlignAction());
        this.menuTools.add(new AutoMirrorAction());
        this.menuTools.add(new FlipPatchesAction());
        this.menuTools.add(new AlignPatchesAction());
        this.menuTools.add(this.menuTangents);
        this.add(this.menuShow);
        this.add(this.menuView);
        this.add(this.menuRotoscope);
        this.add(jMenuItem5);
        this.add(jMenuItem4);
        this.add(this.miZBuffer);
        this.addSeparator();
        this.add(this.menuSelection);
        this.add(this.menuTools);
    }
}

