/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.Lighting;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.ZBufferRenderer;
import jpatch.boundary.action.ZoomToFitAction;
import jpatch.boundary.mouse.ActiveViewportMouseAdapter;
import jpatch.boundary.mouse.MoveZoomRotateMouseAdapter;
import jpatch.boundary.mouse.PopupMouseListener;
import jpatch.boundary.tools.JPatchTool;
import jpatch.boundary.tools.TangentTool;
import jpatch.entity.Model;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JPatchScreen
extends JPanel {
    public static final int SINGLE = 1;
    public static final int HORIZONTAL_SPLIT = 2;
    public static final int VERTICAL_SPLIT = 3;
    public static final int QUAD = 4;
    public static final int LIGHT_OFF = 0;
    public static final int LIGHT_SIMPLE = 1;
    public static final int LIGHT_HEAD = 2;
    public static final int LIGHT_THREE_POINT = 3;
    public static final int NUMBER_OF_VIEWPORTS = 4;
    private Viewport activeViewport;
    private JPatchCanvas[] aComponent;
    private ViewDefinition[] aViewDef;
    private boolean bSnapToGrid;
    private float fGridSpacing;
    private Model model;
    private int iMode;
    private boolean bBackfaceNormalFlip;
    private int iBackfaceCulling;
    private boolean bSynchronized;
    private int iLightMode;
    private boolean bStickyLight;
    private JPatchTool tool;
    private int[] aiView;
    private PopupMouseListener popupMouseListener;
    private MoveZoomRotateMouseAdapter moveZoomRotateMouseAdapter;
    private boolean bPopupEnabled;
    private ActiveViewportMouseAdapter activeViewportMouseAdapter;
    private boolean bShowTangents;
    private TangentTool tangentTool;

    public final boolean isSynchronized() {
        return this.bSynchronized;
    }

    public final boolean flipBackfacingNormals() {
        return this.bBackfaceNormalFlip;
    }

    public final int cullBackfacingPolys() {
        return this.iBackfaceCulling;
    }

    public final void flipBackfacingNormals(boolean bl) {
        this.bBackfaceNormalFlip = bl;
        int n = 0;
        while (n < 4) {
            JPatchDrawable jPatchDrawable = this.aComponent[n].getDrawable();
            if (jPatchDrawable != null) {
                jPatchDrawable.getLighting().setBackfaceNormalFlip(bl);
            }
            ++n;
        }
    }

    public final void cullBackfacingPolys(int n) {
        this.iBackfaceCulling = n;
        int n2 = 0;
        while (n2 < 4) {
            JPatchDrawable jPatchDrawable = this.aComponent[n2].getDrawable();
            if (jPatchDrawable instanceof ZBufferRenderer) {
                ((ZBufferRenderer)((Object)jPatchDrawable)).setCulling(n);
            }
            ++n2;
        }
    }

    public final void synchronize(boolean bl) {
        this.bSynchronized = bl;
    }

    public final boolean showTangents() {
        return this.bShowTangents;
    }

    public final void showTangents(boolean bl) {
        this.bShowTangents = bl;
        int n = 0;
        while (n < 4) {
            if (bl && !this.bShowTangents) {
                this.aComponent[n].addMouseListener(this.tangentTool);
            } else {
                this.aComponent[n].removeMouseListener(this.tangentTool);
            }
            ++n;
        }
    }

    public final TangentTool getTangentTool() {
        return this.tangentTool;
    }

    public final void setLightingMode(int n) {
        this.iLightMode = n;
        int n2 = 0;
        while (n2 < 4) {
            switch (this.iLightMode) {
                case 0: {
                    this.aComponent[n2].flatShade(true);
                    this.aComponent[n2].setLighting(Lighting.createSimpleLight());
                    break;
                }
                case 1: {
                    this.aComponent[n2].flatShade(false);
                    this.aComponent[n2].setLighting(Lighting.createSimpleLight());
                    break;
                }
                case 2: {
                    this.aComponent[n2].flatShade(false);
                    this.aComponent[n2].setLighting(Lighting.createHeadLight());
                    break;
                }
                case 3: {
                    this.aComponent[n2].flatShade(false);
                    this.aComponent[n2].setLighting(Lighting.createThreePointLight());
                    break;
                }
            }
            ++n2;
        }
        this.update_all();
    }

    public final int getLightingMode() {
        return this.iLightMode;
    }

    public final void setActiveViewport(Viewport viewport) {
        if (viewport != this.activeViewport) {
            this.activeViewport = viewport;
            this.update_all();
        }
    }

    public final Viewport getActiveViewport() {
        return this.activeViewport;
    }

    public final void setStickyLight(boolean bl) {
        this.bStickyLight = bl;
        int n = 0;
        while (n < 4) {
            this.aComponent[n].getLighting().setStickyLight(bl);
            ++n;
        }
        this.update_all();
    }

    public final boolean snapToGrid() {
        return this.bSnapToGrid;
    }

    public final void snapToGrid(boolean bl) {
        this.bSnapToGrid = bl;
        int n = 0;
        while (n < 4) {
            this.aComponent[n].getGrid().snap(bl);
            ++n;
        }
        this.update_all();
        JPatchSettings.getInstance().bGridSnap = bl;
    }

    public final float getGridSpacing() {
        return this.fGridSpacing;
    }

    public final void setGridSpacing(float f) {
        this.fGridSpacing = f;
        int n = 0;
        while (n < 4) {
            this.aComponent[n].getGrid().setSpacing(f);
            ++n;
        }
        this.update_all();
    }

    public final boolean isStickyLight() {
        return this.bStickyLight;
    }

    public final void single_update(Component component) {
        if (this.bSynchronized) {
            this.update_all();
        } else {
            ((JPatchCanvas)component).render();
        }
    }

    public final void full_update() {
        if (!this.bSynchronized) {
            this.update_all();
        }
    }

    public final void update_all() {
        switch (this.iMode) {
            case 1: {
                this.aComponent[0].render();
                break;
            }
            case 2: {
                this.aComponent[0].render();
                this.aComponent[1].render();
                break;
            }
            case 3: {
                this.aComponent[0].render();
                this.aComponent[2].render();
                break;
            }
            case 4: {
                this.aComponent[0].render();
                this.aComponent[1].render();
                this.aComponent[2].render();
                this.aComponent[3].render();
                break;
            }
        }
    }

    public final void zoomToFit_all() {
        switch (this.iMode) {
            case 1: {
                ZoomToFitAction.zoomToFit(this.aComponent[0]);
                break;
            }
            case 2: {
                ZoomToFitAction.zoomToFit(this.aComponent[0]);
                ZoomToFitAction.zoomToFit(this.aComponent[1]);
                break;
            }
            case 3: {
                ZoomToFitAction.zoomToFit(this.aComponent[0]);
                ZoomToFitAction.zoomToFit(this.aComponent[2]);
                break;
            }
            case 4: {
                ZoomToFitAction.zoomToFit(this.aComponent[0]);
                ZoomToFitAction.zoomToFit(this.aComponent[1]);
                ZoomToFitAction.zoomToFit(this.aComponent[2]);
                ZoomToFitAction.zoomToFit(this.aComponent[3]);
                break;
            }
        }
    }

    public final void prepareBackground(Component component) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.bSynchronized) {
            int n = 0;
            while (n < 4) {
                if (this.aComponent[n].isVisible()) {
                    this.aComponent[n].prepareBackground();
                }
                ++n;
            }
        } else {
            ((JPatchCanvas)component).prepareBackground();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public final void clearBackground() {
        int n = 0;
        while (n < 4) {
            this.aComponent[n].clearBackground();
            ++n;
        }
    }

    public final void addMouseListeners(MouseListener mouseListener) {
        int n = 0;
        while (n < 4) {
            this.aComponent[n].addMouseListener(mouseListener);
            ++n;
        }
    }

    public final void setTool(JPatchTool jPatchTool) {
        this.tool = jPatchTool;
        this.removeAllMouseListeners();
        int n = 0;
        while (n < 4) {
            this.aComponent[n].setTool(jPatchTool);
            ++n;
        }
        this.update_all();
    }

    public final JPatchTool getTool() {
        return this.tool;
    }

    public final void removeAllMouseListeners() {
        int n = 0;
        while (n < 4) {
            MouseListener[] mouseListenerArray = this.aComponent[n].getMouseListeners();
            MouseMotionListener[] mouseMotionListenerArray = this.aComponent[n].getMouseMotionListeners();
            MouseWheelListener[] mouseWheelListenerArray = this.aComponent[n].getMouseWheelListeners();
            int n2 = 0;
            while (n2 < mouseListenerArray.length) {
                this.aComponent[n].removeMouseListener(mouseListenerArray[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < mouseMotionListenerArray.length) {
                this.aComponent[n].removeMouseMotionListener(mouseMotionListenerArray[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < mouseWheelListenerArray.length) {
                this.aComponent[n].removeMouseWheelListener(mouseWheelListenerArray[n2]);
                ++n2;
            }
            ++n;
        }
        this.enablePopupMenu(false);
        this.enablePopupMenu(true);
        this.addMMBListener();
    }

    public final void enablePopupMenu(boolean bl) {
        if (bl != this.bPopupEnabled) {
            int n = 0;
            while (n < 4) {
                if (bl) {
                    this.aComponent[n].addMouseListener(this.popupMouseListener);
                } else {
                    this.aComponent[n].removeMouseListener(this.popupMouseListener);
                }
                ++n;
            }
            this.bPopupEnabled = bl;
        }
    }

    public final void addMMBListener() {
        int n = 0;
        while (n < 4) {
            this.aComponent[n].addMouseListener(this.moveZoomRotateMouseAdapter);
            this.aComponent[n].addMouseWheelListener(this.moveZoomRotateMouseAdapter);
            this.aComponent[n].addMouseListener(this.activeViewportMouseAdapter);
            this.aComponent[n].addMouseWheelListener(this.activeViewportMouseAdapter);
            if (this.bShowTangents) {
                this.aComponent[n].addMouseListener(this.tangentTool);
            }
            ++n;
        }
    }

    public final int getMode() {
        return this.iMode;
    }

    public final void setMode(int n) {
        this.iMode = n;
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        this.aComponent[0].setVisible(false);
        this.aComponent[1].setVisible(false);
        this.aComponent[2].setVisible(false);
        this.aComponent[3].setVisible(false);
        this.aComponent[0].clearImage();
        this.aComponent[1].clearImage();
        this.aComponent[2].clearImage();
        this.aComponent[3].clearImage();
        if (n2 > 0 && n3 > 0) {
            switch (n) {
                case 1: {
                    this.activeViewport = this.aComponent[0];
                    this.aComponent[0].setBounds(0, 0, n3, n2);
                    this.aComponent[0].setVisible(true);
                    break;
                }
                case 2: {
                    if (this.activeViewport != this.aComponent[0] && this.activeViewport != this.aComponent[1]) {
                        this.activeViewport = this.aComponent[0];
                    }
                    this.aComponent[0].setBounds(0, 0, n5 - 1, n2);
                    this.aComponent[0].setVisible(true);
                    this.aComponent[1].setBounds(n5 + 1, 0, n5 - 1, n2);
                    this.aComponent[1].setVisible(true);
                    break;
                }
                case 3: {
                    if (this.activeViewport != this.aComponent[0] && this.activeViewport != this.aComponent[2]) {
                        this.activeViewport = this.aComponent[0];
                    }
                    this.aComponent[0].setBounds(0, 0, n3, n4 - 1);
                    this.aComponent[0].setVisible(true);
                    this.aComponent[2].setBounds(0, n4 + 1, n3, n4 - 1);
                    this.aComponent[2].setVisible(true);
                    break;
                }
                case 4: {
                    this.aComponent[0].setBounds(0, 0, n5 - 1, n4 - 1);
                    this.aComponent[0].setVisible(true);
                    this.aComponent[1].setBounds(n5 + 1, 0, n5 - 1, n4 - 1);
                    this.aComponent[1].setVisible(true);
                    this.aComponent[2].setBounds(0, n4 + 1, n5 - 1, n4 - 1);
                    this.aComponent[2].setVisible(true);
                    this.aComponent[3].setBounds(n5 + 1, n4 + 1, n5 - 1, n4 - 1);
                    this.aComponent[3].setVisible(true);
                    break;
                }
            }
        }
        JPatchSettings.getInstance().iScreenMode = this.iMode;
    }

    public final void doLayout() {
        this.setMode(this.iMode);
    }

    public final void resetMode(int n) {
        this.setMode(n);
    }

    private final /* synthetic */ void this() {
        this.aComponent = new JPatchCanvas[4];
        this.bSnapToGrid = JPatchSettings.getInstance().bGridSnap;
        this.fGridSpacing = JPatchSettings.getInstance().fGridSpacing;
        this.bBackfaceNormalFlip = false;
        this.iBackfaceCulling = 0;
        this.bSynchronized = JPatchSettings.getInstance().bSyncWindows;
        this.iLightMode = JPatchSettings.getInstance().iLightingMode;
        this.bStickyLight = JPatchSettings.getInstance().bStickyLight;
        this.aiView = new int[]{1, 5, 3, 7};
        this.popupMouseListener = new PopupMouseListener(3);
        this.moveZoomRotateMouseAdapter = new MoveZoomRotateMouseAdapter();
        this.activeViewportMouseAdapter = new ActiveViewportMouseAdapter();
        this.bShowTangents = false;
        this.tangentTool = new TangentTool();
    }

    public JPatchScreen(Model model, int n, ViewDefinition[] viewDefinitionArray) {
        this.this();
        this.model = model;
        this.aViewDef = viewDefinitionArray;
        int n2 = 0;
        while (n2 < 4) {
            this.aComponent[n2] = new JPatchCanvas(model, this.aViewDef[n2]);
            this.add(this.aComponent[n2]);
            this.aComponent[n2].setFocusable(false);
            ++n2;
        }
        this.setFocusable(false);
        this.setMode(n);
        this.setLightingMode(this.iLightMode);
        this.enablePopupMenu(true);
        this.activeViewport = this.aComponent[0];
        this.snapToGrid(this.bSnapToGrid);
    }
}

