/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchSettings;
import jpatch.entity.MaterialProperties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lighting {
    private Vector3f[] av3LightDirection;
    private Vector3f[] av3TransformedLightDirection;
    private float[] afLightIntensity;
    private boolean[] abLightSpecular;
    private float fAmbientLight;
    private Vector3f v3View;
    private Matrix3f m3View;
    private boolean bStickyLight;
    private boolean bBackfaceNormalFlip;
    private Vector3f N;
    private Vector3f LV;

    public static Lighting createSimpleLight() {
        Lighting lighting = new Lighting();
        lighting.initSimpleLight();
        return lighting;
    }

    public static Lighting createHeadLight() {
        Lighting lighting = new Lighting();
        lighting.initHeadLight();
        return lighting;
    }

    public static Lighting createThreePointLight() {
        Lighting lighting = new Lighting();
        lighting.initThreePointLight();
        return lighting;
    }

    public static Lighting createDefaultLight() {
        return Lighting.createSimpleLight();
    }

    public void setBackfaceNormalFlip(boolean bl) {
        this.bBackfaceNormalFlip = bl;
    }

    public boolean isBackfaceNormalFlip() {
        return this.bBackfaceNormalFlip;
    }

    private final void initThreePointLight() {
        this.av3LightDirection = new Vector3f[]{new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(0.0f, -1.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
        this.afLightIntensity = new float[]{0.6f, 0.9f, 0.3f};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        this.abLightSpecular = blArray;
        this.fAmbientLight = 1.0f;
        int n = 0;
        while (n < this.av3LightDirection.length) {
            this.av3LightDirection[n].normalize();
            ++n;
        }
        this.init();
    }

    private final void initSimpleLight() {
        this.av3LightDirection = new Vector3f[]{new Vector3f(-1.0f, -1.0f, -1.0f)};
        this.afLightIntensity = new float[]{1.0f};
        this.abLightSpecular = new boolean[1];
        this.fAmbientLight = 1.0f;
        this.av3LightDirection[0].normalize();
        this.init();
    }

    private final void initHeadLight() {
        this.av3LightDirection = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f)};
        this.afLightIntensity = new float[]{1.0f};
        this.abLightSpecular = new boolean[]{true};
        this.fAmbientLight = 1.0f;
        this.init();
    }

    private final void init() {
        this.av3TransformedLightDirection = new Vector3f[this.av3LightDirection.length];
        int n = 0;
        while (n < this.av3LightDirection.length) {
            this.av3TransformedLightDirection[n] = new Vector3f();
            ++n;
        }
        this.setStickyLight(JPatchSettings.getInstance().bStickyLight);
    }

    public final void setStickyLight(boolean bl) {
        this.bStickyLight = bl;
        int n = 0;
        while (n < this.av3LightDirection.length) {
            this.av3TransformedLightDirection[n].set(this.av3LightDirection[n]);
            ++n;
        }
    }

    public final boolean isStickyLight() {
        return this.bStickyLight;
    }

    public final void setRotation(float f, float f2) {
        Matrix3f matrix3f = new Matrix3f();
        this.m3View.rotX(-f);
        matrix3f.rotY(f2);
        this.m3View.mul(matrix3f);
    }

    public final void transform() {
        if (!this.bStickyLight) {
            int n = 0;
            while (n < this.av3LightDirection.length) {
                this.av3TransformedLightDirection[n].set(this.av3LightDirection[n]);
                this.m3View.transform(this.av3TransformedLightDirection[n]);
                this.av3TransformedLightDirection[n].normalize();
                ++n;
            }
        }
    }

    public final int shade(Point3f point3f, Vector3f vector3f, MaterialProperties materialProperties) {
        float f;
        float f2 = materialProperties.ambient * this.fAmbientLight;
        float f3 = 0.0f;
        if (vector3f.z < 0.0f) {
            this.N.set(vector3f);
        } else {
            this.N.set(-vector3f.x, -vector3f.y, -vector3f.z);
        }
        int n = 0;
        while (n < this.av3LightDirection.length) {
            if (materialProperties.diffuse != 0.0f) {
                f = Math.max(this.av3TransformedLightDirection[n].dot(this.N) * this.afLightIntensity[n], 0.0f);
                f2 += (float)Math.pow(f, materialProperties.brilliance) * materialProperties.diffuse;
            }
            if (this.abLightSpecular[n] && materialProperties.specular != 0.0f) {
                this.LV.sub(this.av3TransformedLightDirection[n], this.v3View);
                this.LV.scale(1.0f / (float)Math.sqrt(this.LV.dot(this.LV)));
                this.LV.normalize();
                f = Math.max(0.0f, this.LV.dot(this.N));
                f3 += (float)Math.pow(f, 1.0f / materialProperties.roughness) * materialProperties.specular;
            }
            ++n;
        }
        float f4 = Math.min(materialProperties.red * f2 + f3, 1.0f) * 255.0f;
        f = Math.min(materialProperties.green * f2 + f3, 1.0f) * 255.0f;
        float f5 = Math.min(materialProperties.blue * f2 + f3, 1.0f) * 255.0f;
        int n2 = 0xFF000000 | (int)f4 << 16 | (int)f << 8 | (int)f5;
        return n2;
    }

    private final /* synthetic */ void this() {
        this.v3View = new Vector3f(0.0f, 0.0f, 1.0f);
        this.m3View = new Matrix3f();
        this.bBackfaceNormalFlip = false;
        this.N = new Vector3f();
        this.LV = new Vector3f();
    }

    public Lighting() {
        this.this();
    }
}

