/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import jpatch.boundary.About;
import jpatch.boundary.BoneToolBar;
import jpatch.boundary.JPatchKeyAdapter;
import jpatch.boundary.JPatchScreen;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.JPatchTreeCellRenderer;
import jpatch.boundary.JPatchTreeNode;
import jpatch.boundary.JPatchWindowAdapter;
import jpatch.boundary.MainMenu;
import jpatch.boundary.MainToolBar;
import jpatch.boundary.MeshToolBar;
import jpatch.boundary.MorphToolBar;
import jpatch.boundary.SideBar;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.Selection;
import jpatch.boundary.tools.RotateTool;
import jpatch.control.XYZLockConstraints;
import jpatch.control.edit.JPatchUndoManager;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchException;
import jpatch.entity.Model;
import jpatch.entity.Morph;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MainFrame
extends JFrame {
    public static final int MESH = 1;
    public static final int MORPH = 2;
    public static final int BONE = 3;
    private static MainFrame INSTANCE;
    private int iMode;
    private Model model;
    private JPatchScreen jpatchScreen;
    private MainToolBar mainToolBar;
    private MeshToolBar meshToolBar;
    private BoneToolBar boneToolBar;
    private MorphToolBar morphToolBar;
    private JPanel helpPanel;
    private JLabel helpLabel;
    private JMenuBar mainMenu;
    private ButtonGroup bgAction;
    private Selection selection;
    private JPatchUndoManager undoManager;
    private JPatchKeyAdapter keyAdapter;
    private JDialog dialog;
    private Point pointDialogLocation;
    private XYZLockConstraints constraints;
    private ViewDefinition[] aViewDef;
    private JTree tree;
    private SideBar sideBar;
    private JPatchTreeNode treenodeRoot;
    private Morph editedMorph;

    public final void clearDialog() {
        if (this.dialog != null) {
            this.pointDialogLocation = this.dialog.getLocation();
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public final void setEditedMorph(Morph morph) {
        this.editedMorph = morph;
    }

    public final Morph getEditedMorph() {
        return this.editedMorph;
    }

    public final XYZLockConstraints getConstraints() {
        return this.constraints;
    }

    public final void editMorph(Morph morph) {
        this.setEditedMorph(morph);
        if (morph != null) {
            this.switchMode(2);
        } else {
            this.switchMode(1);
        }
    }

    public final void setDialog(JDialog jDialog) {
        this.clearDialog();
        this.dialog = jDialog;
        jDialog.setLocation(this.pointDialogLocation);
        jDialog.show();
    }

    public final JPatchScreen getJPatchScreen() {
        return this.jpatchScreen;
    }

    public final JPatchKeyAdapter getKeyAdapter() {
        return this.keyAdapter;
    }

    public final Model getModel() {
        return this.model;
    }

    public final void NEW() {
        this.model = new Model();
        this.selection = null;
        this.undoManager = new JPatchUndoManager(30);
        this.initTree();
        this.sideBar.setTree(this.tree);
        this.meshToolBar.reset();
        JPatchSettings.getInstance().strJPatchFile = "";
        this.validate();
    }

    public static final MainFrame getInstance() {
        return INSTANCE;
    }

    public final void initScreen() {
        int n = JPatchSettings.getInstance().iScreenMode;
        if (this.jpatchScreen != null) {
            this.getContentPane().remove(this.jpatchScreen);
            n = this.jpatchScreen.getMode();
        }
        this.jpatchScreen = new JPatchScreen(this.model, n, this.aViewDef);
    }

    public final void setTangentDisplay(ControlPoint controlPoint) {
        int n = 0;
        while (n < 4) {
            this.aViewDef[n].setTangentHandles(controlPoint);
            ++n;
        }
    }

    public final MeshToolBar getMeshToolBar() {
        return this.meshToolBar;
    }

    public final ButtonGroup getActionButtonGroup() {
        return this.bgAction;
    }

    public final JPatchUndoManager getUndoManager() {
        return this.undoManager;
    }

    public final Selection getSelection() {
        return this.selection;
    }

    public final void setSelection(Selection selection) {
        this.selection = selection;
        PointSelection pointSelection = this.getPointSelection();
        if (pointSelection != null) {
            ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
            int n = 0;
            while (n < controlPointArray.length) {
                ControlPoint[] controlPointArray2 = controlPointArray[n].getStack();
                int n2 = 0;
                while (n2 < controlPointArray2.length) {
                    controlPointArray2[n2++].setHidden(false);
                }
                ++n;
            }
            if (this.jpatchScreen.getTool() != null) {
                try {
                    RotateTool rotateTool = (RotateTool)this.jpatchScreen.getTool();
                    rotateTool.reInit(pointSelection);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    public final void setHelpText(String string) {
        this.helpLabel.setText(string);
    }

    public final void clearHelpText() {
        this.helpLabel.setText(" ");
    }

    public final void switchMode(int n) {
        if (n != this.iMode) {
            switch (this.iMode) {
                case 1: {
                    this.meshToolBar.removeKeyBindings();
                    this.getContentPane().remove(this.meshToolBar);
                    break;
                }
                case 3: {
                    this.getContentPane().remove(this.boneToolBar);
                    break;
                }
                case 2: {
                    this.morphToolBar.removeKeyBindings();
                    this.getContentPane().remove(this.morphToolBar);
                    break;
                }
            }
            this.iMode = n;
            switch (this.iMode) {
                case 1: {
                    this.getContentPane().add((Component)this.meshToolBar, "West");
                    this.meshToolBar.addKeyBindings();
                    break;
                }
                case 3: {
                    this.getContentPane().add((Component)this.boneToolBar, "West");
                    break;
                }
                case 2: {
                    this.getContentPane().add((Component)this.morphToolBar, "West");
                    this.morphToolBar.addKeyBindings();
                    break;
                }
            }
            this.validate();
            this.repaint();
        }
    }

    public final int getMode() {
        return this.iMode;
    }

    public final PointSelection getPointSelection() {
        Class clazz = PointSelection.getPointSelectionClass();
        PointSelection pointSelection = null;
        if (this.selection != null && clazz.isAssignableFrom(this.selection.getClass())) {
            pointSelection = (PointSelection)this.selection;
        }
        return pointSelection;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public final SideBar getSideBar() {
        return this.sideBar;
    }

    public final JPatchTreeNode getRootTreenode() {
        return this.treenodeRoot;
    }

    private final void initTree() {
        this.treenodeRoot = new JPatchTreeNode(0, null, "ROOT");
        this.treenodeRoot.add(this.model);
        this.tree = new JTree(this.treenodeRoot);
        this.tree.setCellRenderer(new JPatchTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    private final /* synthetic */ void this() {
        this.iMode = 1;
        this.undoManager = new JPatchUndoManager(50);
        this.keyAdapter = new JPatchKeyAdapter();
        this.pointDialogLocation = new Point(800, 600);
        this.constraints = new XYZLockConstraints();
        this.aViewDef = new ViewDefinition[4];
    }

    public MainFrame(Model model) {
        this.this();
        this.setTitle("JPatch Modeler 0.4 PREVIEW 1");
        this.model = model;
        if (INSTANCE == null) {
            INSTANCE = this;
            try {
                UIManager.setLookAndFeel(JPatchSettings.getInstance().strPlafClassName);
            }
            catch (Exception exception) {}
            this.helpPanel = new JPanel();
            this.helpLabel = new JLabel("press right mousebutton (RMB) for popup-menu, click and drag with middle mousebutton (MMB) to move view, use mousewheel to zoom");
            this.helpLabel.setFont(new Font("SansSerif", 0, 10));
            this.bgAction = new ButtonGroup();
            this.aViewDef[0] = new ViewDefinition(1);
            this.aViewDef[1] = new ViewDefinition(5);
            this.aViewDef[2] = new ViewDefinition(3);
            this.aViewDef[3] = new ViewDefinition(7);
            this.initScreen();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.jpatchScreen, "Center");
            JPatchSettings jPatchSettings = JPatchSettings.getInstance();
            this.setLocation(jPatchSettings.iScreenX, jPatchSettings.iScreenY);
            this.setSize(jPatchSettings.iScreenWidth, jPatchSettings.iScreenHeight);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new JPatchWindowAdapter());
            this.mainMenu = new MainMenu();
            this.setJMenuBar(this.mainMenu);
            this.mainToolBar = new MainToolBar(this.bgAction);
            this.getContentPane().add((Component)this.mainToolBar, "North");
            this.boneToolBar = new BoneToolBar(this.bgAction);
            this.meshToolBar = new MeshToolBar(this.bgAction);
            this.meshToolBar.addKeyBindings();
            this.morphToolBar = new MorphToolBar(this.bgAction);
            this.getContentPane().add((Component)this.meshToolBar, "West");
            this.initTree();
            this.sideBar = new SideBar(this.tree);
            this.getContentPane().add((Component)this.sideBar, "East");
            this.getContentPane().add((Component)this.helpPanel, "South");
            this.helpPanel.setLayout(new FlowLayout(0));
            this.helpPanel.add(this.helpLabel);
            this.jpatchScreen.enablePopupMenu(true);
            this.jpatchScreen.addMMBListener();
            this.addKeyListener(this.keyAdapter);
            this.setFocusable(true);
            this.getRootPane().setFocusable(false);
            this.setFocusTraversalKeysEnabled(false);
            this.mainToolBar.setScreenMode(this.jpatchScreen);
            if (JPatchSettings.getInstance().bFirstStart) {
                About about = new About(this);
                JPatchSettings.getInstance().bFirstStart = false;
            }
        } else {
            throw new JPatchException("There can be only one instance of MainFrame");
        }
        this.meshToolBar.reset();
        this.requestFocus();
        this.show();
    }
}

