/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.KeyMapping;
import jpatch.boundary.MainFrame;
import jpatch.boundary.action.AboutAction;
import jpatch.boundary.action.AlignAction;
import jpatch.boundary.action.AutoMirrorAction;
import jpatch.boundary.action.BackfaceCullingAction;
import jpatch.boundary.action.BackfaceNormalFlipAction;
import jpatch.boundary.action.CheckModelAction;
import jpatch.boundary.action.ColorPreferencesAction;
import jpatch.boundary.action.DumpAction;
import jpatch.boundary.action.DumpUndoStackAction;
import jpatch.boundary.action.EditPhonemesAction;
import jpatch.boundary.action.ExportPovrayAction;
import jpatch.boundary.action.ExportRibAction;
import jpatch.boundary.action.ExportWavefrontAction;
import jpatch.boundary.action.ImportAnimationMasterAction;
import jpatch.boundary.action.ImportJPatchAction;
import jpatch.boundary.action.ImportSPatchAction;
import jpatch.boundary.action.LightingHeadAction;
import jpatch.boundary.action.LightingOffAction;
import jpatch.boundary.action.LightingSimpleAction;
import jpatch.boundary.action.LightingStickyAction;
import jpatch.boundary.action.LightingThreePointAction;
import jpatch.boundary.action.NewAction;
import jpatch.boundary.action.QuitAction;
import jpatch.boundary.action.SaveAsAction;
import jpatch.boundary.action.SetGridSpacingAction;
import jpatch.boundary.action.SwitchLookAndFeelAction;
import jpatch.boundary.action.SyncScreensAction;
import jpatch.boundary.action.ViewKeyAction;
import jpatch.boundary.action.ZBufferQualityAction;

public final class MainMenu
extends JMenuBar {
    private JMenu menuFile = new JMenu("File");
    private JMenu menuImport = new JMenu("Import");
    private JMenu menuExport = new JMenu("Export");
    private JMenu menuTest = new JMenu("Test");
    private JMenu menuHelp = new JMenu("Help");
    private JMenu menuOptions = new JMenu("Options");
    private JMenu menuLight = new JMenu("Light");
    private JMenu menuPlaf;
    private JMenu menuTools = new JMenu("Tools");
    private JRadioButtonMenuItem miLightOff = new JRadioButtonMenuItem(new LightingOffAction(MainFrame.getInstance().getJPatchScreen()));
    private JRadioButtonMenuItem miLightSimple = new JRadioButtonMenuItem(new LightingSimpleAction(MainFrame.getInstance().getJPatchScreen()));
    private JRadioButtonMenuItem miLightHead = new JRadioButtonMenuItem(new LightingHeadAction(MainFrame.getInstance().getJPatchScreen()));
    private JRadioButtonMenuItem miLightThreePoint = new JRadioButtonMenuItem(new LightingThreePointAction(MainFrame.getInstance().getJPatchScreen()));
    private JCheckBoxMenuItem miLightSticky = new JCheckBoxMenuItem(new LightingStickyAction(MainFrame.getInstance().getJPatchScreen()));
    private JCheckBoxMenuItem miSync = new JCheckBoxMenuItem(new SyncScreensAction());
    private JCheckBoxMenuItem miFlip = new JCheckBoxMenuItem(new BackfaceNormalFlipAction());
    private JCheckBoxMenuItem miCull = new JCheckBoxMenuItem(new BackfaceCullingAction());

    public MainMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.miLightOff);
        buttonGroup.add(this.miLightSimple);
        buttonGroup.add(this.miLightHead);
        buttonGroup.add(this.miLightThreePoint);
        boolean bl = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 0) {
            bl = true;
        }
        this.miLightOff.setSelected(bl);
        boolean bl2 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 1) {
            bl2 = true;
        }
        this.miLightSimple.setSelected(bl2);
        boolean bl3 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 2) {
            bl3 = true;
        }
        this.miLightHead.setSelected(bl3);
        boolean bl4 = false;
        if (MainFrame.getInstance().getJPatchScreen().getLightingMode() == 3) {
            bl4 = true;
        }
        this.miLightThreePoint.setSelected(bl4);
        this.miLightSticky.setState(MainFrame.getInstance().getJPatchScreen().isStickyLight());
        this.miSync.setState(MainFrame.getInstance().getJPatchScreen().isSynchronized());
        this.miFlip.setState(MainFrame.getInstance().getJPatchScreen().flipBackfacingNormals());
        this.menuLight.add(this.miLightOff);
        this.menuLight.add(this.miLightSimple);
        this.menuLight.add(this.miLightHead);
        this.menuLight.add(this.miLightThreePoint);
        this.menuLight.addSeparator();
        this.menuLight.add(this.miLightSticky);
        this.menuImport.add(new ImportSPatchAction());
        this.menuImport.add(new ImportAnimationMasterAction());
        JMenuItem jMenuItem = new JMenuItem(new NewAction());
        jMenuItem.setIcon(null);
        jMenuItem.setText("New");
        this.menuFile.add(jMenuItem);
        jMenuItem = new JMenuItem(new ImportJPatchAction(true));
        jMenuItem.setIcon(null);
        jMenuItem.setText("Open (new)");
        this.menuFile.add(jMenuItem);
        jMenuItem = new JMenuItem(new ImportJPatchAction(false));
        jMenuItem.setIcon(null);
        jMenuItem.setText("Open (append)");
        this.menuFile.add(jMenuItem);
        jMenuItem = new JMenuItem(new SaveAsAction(false));
        jMenuItem.setIcon(null);
        jMenuItem.setText("Save");
        this.menuFile.add(jMenuItem);
        jMenuItem = new JMenuItem(new SaveAsAction(true));
        jMenuItem.setIcon(null);
        jMenuItem.setText("Save As...");
        this.menuFile.add(jMenuItem);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuImport);
        this.menuTest.add(new DumpAction());
        this.menuTest.add(new DumpUndoStackAction());
        this.menuTest.add(new CheckModelAction());
        this.menuTest.add(new EditPhonemesAction());
        this.menuExport.add(new ExportWavefrontAction());
        this.menuExport.add(new ExportPovrayAction());
        this.menuExport.add(new ExportRibAction());
        this.menuFile.add(this.menuExport);
        this.menuFile.addSeparator();
        this.menuFile.add(new QuitAction());
        this.menuHelp.add(new AboutAction());
        this.menuOptions.add(this.miSync);
        this.menuOptions.add(new ColorPreferencesAction());
        this.menuOptions.add(new SetGridSpacingAction());
        this.menuOptions.add(new ZBufferQualityAction());
        this.menuOptions.add(this.menuLight);
        this.menuPlaf = new JMenu("Look And Feel");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            String string = lookAndFeelInfoArray[n].getName();
            String string2 = lookAndFeelInfoArray[n].getClassName();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SwitchLookAndFeelAction(string, string2));
            if (string2.equals(JPatchSettings.getInstance().strPlafClassName)) {
                jRadioButtonMenuItem.setSelected(true);
            } else {
                jRadioButtonMenuItem.setSelected(false);
            }
            buttonGroup2.add(jRadioButtonMenuItem);
            this.menuPlaf.add(jRadioButtonMenuItem);
            ++n;
        }
        this.menuOptions.add(this.menuPlaf);
        this.menuTools.add(new AlignAction());
        this.menuTools.add(new AutoMirrorAction());
        this.add(this.menuFile);
        this.add(this.menuOptions);
        this.add(this.menuTest);
        this.add(this.menuHelp);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("bottom view"), new ViewKeyAction(4));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("front view"), new ViewKeyAction(1));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("right view"), new ViewKeyAction(6));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("top view"), new ViewKeyAction(3));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("left view"), new ViewKeyAction(5));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("bird's eye view"), new ViewKeyAction(7));
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("rear view"), new ViewKeyAction(2));
    }
}

