/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpatch.boundary.JPatchButton;
import jpatch.boundary.JPatchScreen;
import jpatch.boundary.JPatchSeparator;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.JPatchToggleButton;
import jpatch.boundary.KeyMapping;
import jpatch.boundary.MainFrame;
import jpatch.boundary.action.GridSnapAction;
import jpatch.boundary.action.HideAction;
import jpatch.boundary.action.ImportJPatchAction;
import jpatch.boundary.action.NewAction;
import jpatch.boundary.action.RedoAction;
import jpatch.boundary.action.SaveAsAction;
import jpatch.boundary.action.UndoAction;
import jpatch.boundary.action.ViewMoveAction;
import jpatch.boundary.action.ViewQuadAction;
import jpatch.boundary.action.ViewRotateAction;
import jpatch.boundary.action.ViewSingleAction;
import jpatch.boundary.action.ViewSplitHorizontalAction;
import jpatch.boundary.action.ViewSplitVerticalAction;
import jpatch.boundary.action.ViewZoomAction;
import jpatch.boundary.action.XLockAction;
import jpatch.boundary.action.YLockAction;
import jpatch.boundary.action.ZLockAction;
import jpatch.boundary.action.ZoomToFitAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MainToolBar
extends JPanel {
    private ButtonGroup bgAction;
    private ButtonGroup bgView;
    private ButtonGroup bgMode;
    private AbstractAction viewSingleAction;
    private AbstractAction viewSplitHorizontalAction;
    private AbstractAction viewSplitVerticalAction;
    private AbstractAction viewQuadAction;
    private AbstractAction undoAction;
    private AbstractAction redoAction;
    private AbstractAction viewRotateAction;
    private AbstractAction viewMoveAction;
    private AbstractAction viewZoomAction;
    private AbstractAction xLockAction;
    private AbstractAction yLockAction;
    private AbstractAction zLockAction;
    private AbstractAction gridSnapAction;
    private AbstractAction hideAction;
    private AbstractButton buttonSingle;
    private AbstractButton buttonHorizontal;
    private AbstractButton buttonVertical;
    private AbstractButton buttonQuad;
    private AbstractButton buttonUndo;
    private AbstractButton buttonRedo;
    private AbstractButton buttonRotate;
    private AbstractButton buttonMove;
    private AbstractButton buttonZoom;
    private AbstractButton buttonXLock;
    private AbstractButton buttonYLock;
    private AbstractButton buttonZLock;
    private AbstractButton buttonGridSnap;
    private AbstractButton buttonHide;

    public final void setScreenMode(JPatchScreen jPatchScreen) {
        this.buttonSingle.setSelected(false);
        this.buttonHorizontal.setSelected(false);
        this.buttonVertical.setSelected(false);
        this.buttonQuad.setSelected(false);
        switch (jPatchScreen.getMode()) {
            case 1: {
                this.buttonSingle.setSelected(true);
                break;
            }
            case 2: {
                this.buttonHorizontal.setSelected(true);
                break;
            }
            case 3: {
                this.buttonVertical.setSelected(true);
                break;
            }
            case 4: {
                this.buttonQuad.setSelected(true);
                break;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.viewSingleAction = new ViewSingleAction();
        this.viewSplitHorizontalAction = new ViewSplitHorizontalAction();
        this.viewSplitVerticalAction = new ViewSplitVerticalAction();
        this.viewQuadAction = new ViewQuadAction();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.viewRotateAction = new ViewRotateAction();
        this.viewMoveAction = new ViewMoveAction();
        this.viewZoomAction = new ViewZoomAction();
        this.xLockAction = new XLockAction();
        this.yLockAction = new YLockAction();
        this.zLockAction = new ZLockAction();
        this.gridSnapAction = new GridSnapAction();
        this.hideAction = new HideAction();
        this.buttonSingle = new JPatchToggleButton(this.viewSingleAction);
        this.buttonHorizontal = new JPatchToggleButton(this.viewSplitHorizontalAction);
        this.buttonVertical = new JPatchToggleButton(this.viewSplitVerticalAction);
        this.buttonQuad = new JPatchToggleButton(this.viewQuadAction);
        this.buttonUndo = new JPatchButton(this.undoAction);
        this.buttonRedo = new JPatchButton(this.redoAction);
        this.buttonRotate = new JPatchToggleButton(this.viewRotateAction);
        this.buttonMove = new JPatchToggleButton(this.viewMoveAction);
        this.buttonZoom = new JPatchToggleButton(this.viewZoomAction);
        this.buttonXLock = new JPatchToggleButton(this.xLockAction);
        this.buttonYLock = new JPatchToggleButton(this.yLockAction);
        this.buttonZLock = new JPatchToggleButton(this.zLockAction);
        this.buttonGridSnap = new JPatchToggleButton(this.gridSnapAction);
        this.buttonHide = new JPatchToggleButton(this.hideAction);
    }

    public MainToolBar(ButtonGroup buttonGroup) {
        this.this();
        this.setLayout(new BoxLayout(this, 0));
        this.buttonXLock.setSelectedIcon(new ImageIcon(this.getClass().getClassLoader().getResource("jpatch/images/xlocked.png")));
        this.buttonYLock.setSelectedIcon(new ImageIcon(this.getClass().getClassLoader().getResource("jpatch/images/ylocked.png")));
        this.buttonZLock.setSelectedIcon(new ImageIcon(this.getClass().getClassLoader().getResource("jpatch/images/zlocked.png")));
        this.buttonGridSnap.setSelectedIcon(new ImageIcon(this.getClass().getClassLoader().getResource("jpatch/images/grid_snap.png")));
        this.buttonHide.setSelectedIcon(new ImageIcon(this.getClass().getClassLoader().getResource("jpatch/images/hide2.png")));
        this.bgAction = buttonGroup;
        this.bgView = new ButtonGroup();
        this.bgMode = new ButtonGroup();
        this.bgAction.add(this.buttonRotate);
        this.bgAction.add(this.buttonMove);
        this.bgAction.add(this.buttonZoom);
        this.bgView.add(this.buttonSingle);
        this.bgView.add(this.buttonHorizontal);
        this.bgView.add(this.buttonVertical);
        this.bgView.add(this.buttonQuad);
        this.buttonGridSnap.setSelected(JPatchSettings.getInstance().bGridSnap);
        this.add(new JPatchButton(new NewAction()));
        this.add(new JPatchButton(new ImportJPatchAction()));
        this.add(new JPatchButton(new SaveAsAction(false)));
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(this.buttonSingle);
        this.add(this.buttonHorizontal);
        this.add(this.buttonVertical);
        this.add(this.buttonQuad);
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(this.buttonRotate);
        this.add(this.buttonMove);
        this.add(this.buttonZoom);
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(new JPatchButton(new ZoomToFitAction()));
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(this.buttonUndo);
        this.add(this.buttonRedo);
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(this.buttonXLock);
        this.add(this.buttonYLock);
        this.add(this.buttonZLock);
        this.add(JPatchSeparator.createHorizontalSeparator());
        this.add(this.buttonGridSnap);
        this.add(this.buttonHide);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("single view"), this.buttonSingle);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("horizontal split view"), this.buttonHorizontal);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("vertical split view"), this.buttonVertical);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("quad view"), this.buttonQuad);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("rotate view"), this.buttonRotate);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("move view"), this.buttonMove);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("zoom view"), this.buttonZoom);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("undo"), this.undoAction);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("redo"), this.redoAction);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("lock x"), this.buttonXLock);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("lock y"), this.buttonYLock);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("lock z"), this.buttonZLock);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("grid"), this.buttonGridSnap);
        MainFrame.getInstance().getKeyAdapter().addKey(KeyMapping.getKey("hide"), this.buttonHide);
        this.setFocusable(false);
    }
}

