/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.control.edit.ChangeControlPointTangentModeEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.entity.ControlPoint;

public final class ChangeTangentModeAction
extends AbstractAction {
    public static final int PEAK = 0;
    public static final int JPATCH = 1;
    public static final int SPATCH = 2;
    private static final String[] astrNames = new String[]{"peak", "round (JPatch)", "round (sPatch)"};
    private static final int[] aiMapping;
    private int iMode;

    public final void actionPerformed(ActionEvent actionEvent) {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        if (pointSelection != null && pointSelection.isCurve()) {
            MainFrame.getInstance().getUndoManager().addEdit(new ChangeControlPointTangentModeEdit(pointSelection.getControlPoint(), this.iMode));
            MainFrame.getInstance().getJPatchScreen().update_all();
        } else if (pointSelection != null) {
            JPatchCompoundEdit jPatchCompoundEdit = new JPatchCompoundEdit();
            ControlPoint[] controlPointArray = pointSelection.getControlPointArray();
            int n = 0;
            while (n < controlPointArray.length) {
                ControlPoint[] controlPointArray2 = controlPointArray[n].getStack();
                int n2 = 0;
                while (n2 < controlPointArray2.length) {
                    jPatchCompoundEdit.addEdit(new ChangeControlPointTangentModeEdit(controlPointArray2[n2], this.iMode));
                    ++n2;
                }
                ++n;
            }
            MainFrame.getInstance().getUndoManager().addEdit(jPatchCompoundEdit);
            MainFrame.getInstance().getJPatchScreen().update_all();
        }
    }

    public ChangeTangentModeAction(int n) {
        super(astrNames[n]);
        this.iMode = aiMapping[n];
    }

    static {
        int[] nArray = new int[3];
        nArray[1] = 4;
        nArray[2] = 1;
        aiMapping = nArray;
    }
}

