/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.action;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jpatch.auxilary.JPatchUtils;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.filefilters.JPatchFilter;

public final class SaveAsAction
extends AbstractAction {
    private boolean bSaveAs;

    public final void actionPerformed(ActionEvent actionEvent) {
        if (this.bSaveAs) {
            this.saveAs();
        } else {
            this.save();
        }
    }

    public final boolean saveAs() {
        JFileChooser jFileChooser = new JFileChooser(JPatchSettings.getInstance().strJPatchPath);
        jFileChooser.addChoosableFileFilter(new JPatchFilter());
        if (jFileChooser.showSaveDialog(MainFrame.getInstance()) == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getPath();
            if (JPatchUtils.getFileExtension(file.getName()).equals("")) {
                string = string + ".jpt";
            }
            if (this.write(string)) {
                JPatchSettings.getInstance().strJPatchFile = string;
                return true;
            }
        }
        return false;
    }

    public final boolean save() {
        String string = JPatchSettings.getInstance().strJPatchFile;
        if (string.equals("")) {
            return this.saveAs();
        }
        return this.write(string);
    }

    private final boolean write(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bufferedWriter.write(MainFrame.getInstance().getModel().xml(0).toString());
            bufferedWriter.close();
            MainFrame.getInstance().getUndoManager().setChange(false);
            return true;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Unable to save file \"" + string + "\"\n" + iOException, "Error", 0);
            return false;
        }
    }

    public SaveAsAction(boolean bl) {
        super("", new ImageIcon(ClassLoader.getSystemResource("jpatch/images/save.png")));
        this.bSaveAs = bl;
        if (bl) {
            this.putValue("ShortDescription", "Save As...");
        } else {
            this.putValue("ShortDescription", "Save");
        }
    }
}

