/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.mouse;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import jpatch.boundary.MainFrame;
import jpatch.boundary.mouse.MoveViewMotionListener;
import jpatch.boundary.mouse.RotateViewMotionListener;
import jpatch.boundary.mouse.ZoomViewMotionListener;

public class ChangeViewMouseListener
extends MouseAdapter {
    public static final int MOVE = 1;
    public static final int ZOOM = 2;
    public static final int ROTATE = 3;
    protected int iButton;
    protected int iMode;
    protected MouseMotionAdapter mouseMotionListener;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.iButton) {
            switch (this.iMode) {
                case 1: {
                    this.mouseMotionListener = new MoveViewMotionListener(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 2: {
                    this.mouseMotionListener = new ZoomViewMotionListener(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 3: {
                    this.mouseMotionListener = new RotateViewMotionListener(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
            }
            ((Component)mouseEvent.getSource()).addMouseMotionListener(this.mouseMotionListener);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.iButton) {
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    public ChangeViewMouseListener(int n, int n2) {
        this.iButton = n;
        this.iMode = n2;
        switch (this.iMode) {
            case 1: {
                MainFrame.getInstance().setHelpText("drag to move view");
                break;
            }
            case 2: {
                MainFrame.getInstance().setHelpText("drag to zoom view");
                break;
            }
            case 3: {
                MainFrame.getInstance().setHelpText("drag to rotate view");
                break;
            }
        }
    }
}

