/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.mouse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.ViewDefinition;
import jpatch.boundary.Viewport;
import jpatch.boundary.mouse.JPatchMouseAdapter;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.PointWeightSelection;
import jpatch.boundary.selection.Selection;
import jpatch.boundary.selection.SelectionFactory;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.NewMoveControlPointsEdit;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MagnetMouseAdapter
extends JPatchMouseAdapter {
    private static int IDLE = 0;
    private static int ACTIVE = 1;
    private static int SETRADIUS = 2;
    private BufferedImage image;
    private int iMouseX;
    private int iMouseY;
    private int iDeltaX;
    private int iDeltaY;
    private int iRadius;
    private float fRadius;
    private JPatchCompoundEdit compoundEdit;
    private ControlPoint cpHot;
    private int iState;
    private boolean bNewCircle;
    private Component compSource;
    private JPatchSettings settings;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.compSource = (Component)mouseEvent.getSource();
            Viewport viewport = (Viewport)mouseEvent.getSource();
            this.iMouseX = mouseEvent.getX();
            this.iMouseY = mouseEvent.getY();
            ControlPoint controlPoint = viewport.getViewDefinition().getClosestControlPoint(new Point2D.Float(this.iMouseX, this.iMouseY), null);
            if (controlPoint != null) {
                controlPoint = controlPoint.getHead();
                PointWeightSelection pointWeightSelection = SelectionFactory.createMagnetSelection(controlPoint, MainFrame.getInstance().getModel());
                MainFrame.getInstance().setSelection(pointWeightSelection);
                Graphics graphics = ((Component)mouseEvent.getSource()).getGraphics();
                graphics.setXORMode(new Color(this.settings.cBackground.getRGB() ^ this.settings.cSelection.getRGB()));
                this.drawSelectionCircle(graphics, this.iMouseX, this.iMouseY, this.iRadius);
                this.setActiveState();
                this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointWeightSelection.getControlPointArray()));
            } else {
                MainFrame.getInstance().setSelection(null);
                this.compSource = (Component)mouseEvent.getSource();
                this.iMouseX = mouseEvent.getX();
                this.iMouseY = mouseEvent.getY();
                this.setRadiusState();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.iState == ACTIVE && mouseEvent.getButton() == 1) {
            this.compSource = (Component)mouseEvent.getSource();
            Selection selection = MainFrame.getInstance().getSelection();
            Class clazz = PointSelection.getPointSelectionClass();
            this.setIdleState();
        } else if (this.iState == SETRADIUS && mouseEvent.getButton() == 1) {
            Graphics graphics = ((Component)mouseEvent.getSource()).getGraphics();
            graphics.setXORMode(new Color(this.settings.cBackground.getRGB() ^ this.settings.cSelection.getRGB()));
            this.drawSelectionCircle(graphics, this.iMouseX, this.iMouseY, this.iRadius);
            this.setIdleState();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.iState == ACTIVE) {
            this.iDeltaX = mouseEvent.getX() - this.iMouseX;
            this.iDeltaY = mouseEvent.getY() - this.iMouseY;
            this.iMouseX = mouseEvent.getX();
            this.iMouseY = mouseEvent.getY();
            ViewDefinition viewDefinition = ((Viewport)mouseEvent.getSource()).getViewDefinition();
            Vector3f vector3f = new Vector3f(this.iDeltaX, this.iDeltaY, 0.0f);
            Matrix4f matrix4f = new Matrix4f(viewDefinition.getScreenMatrix());
            Vector3f vector3f2 = new Vector3f();
            matrix4f.invert();
            matrix4f.transform(vector3f);
            Selection selection = MainFrame.getInstance().getSelection();
            Class clazz = PointSelection.getPointSelectionClass();
            if (clazz.isAssignableFrom(selection.getClass())) {
                ControlPoint[] controlPointArray = ((PointWeightSelection)selection).getControlPointArray();
                int n = 0;
                while (n < controlPointArray.length) {
                    ControlPoint controlPoint = controlPointArray[n];
                    vector3f2.set(vector3f);
                    float f = ((PointWeightSelection)selection).getWeight(controlPoint);
                    vector3f2.scale(f);
                    controlPoint.getPosition().add(vector3f2);
                    controlPoint.invalidateTangents();
                    ++n;
                }
                MainFrame.getInstance().getJPatchScreen().single_update(this.compSource);
                Graphics graphics = ((Component)mouseEvent.getSource()).getGraphics();
                graphics.setXORMode(new Color(this.settings.cBackground.getRGB() ^ this.settings.cSelection.getRGB()));
                this.drawSelectionCircle(graphics, this.iMouseX, this.iMouseY, this.iRadius);
            }
        } else if (this.iState == SETRADIUS) {
            Graphics graphics = ((Component)mouseEvent.getSource()).getGraphics();
            ViewDefinition viewDefinition = ((Viewport)mouseEvent.getSource()).getViewDefinition();
            graphics.setXORMode(new Color(this.settings.cBackground.getRGB() ^ this.settings.cSelection.getRGB()));
            if (!this.bNewCircle) {
                this.drawSelectionCircle(graphics, this.iMouseX, this.iMouseY, this.iRadius);
            }
            this.bNewCircle = false;
            this.iRadius = (int)Point2D.distance(this.iMouseX, this.iMouseY, mouseEvent.getX(), mouseEvent.getY());
            this.fRadius = (float)this.iRadius / viewDefinition.getScreenMatrix().getScale();
            this.drawSelectionCircle(graphics, this.iMouseX, this.iMouseY, this.iRadius);
        }
    }

    private final void drawSelectionCircle(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < 256) {
            int n5 = n + (int)((double)n3 * Math.cos((double)n4 * Math.PI / 128.0));
            int n6 = n2 + (int)((double)n3 * Math.sin((double)n4 * Math.PI / 128.0));
            int n7 = n + (int)((double)n3 * Math.cos((double)(n4 + 1) * Math.PI / 128.0));
            int n8 = n2 + (int)((double)n3 * Math.sin((double)(n4 + 1) * Math.PI / 128.0));
            graphics.drawLine(n5, n6, n7, n8);
            n4 += 4;
        }
    }

    private final void setActiveState() {
        if (this.iState != IDLE) {
            throw new JPatchException("setActiveState() called in non-idle state");
        }
        this.compSource.addMouseMotionListener(this);
        this.compoundEdit = new JPatchCompoundEdit();
        MainFrame.getInstance().getJPatchScreen().enablePopupMenu(false);
        this.iState = ACTIVE;
    }

    private final void setIdleState() {
        if (this.iState == ACTIVE) {
            this.compSource.removeMouseMotionListener(this);
            MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
            MainFrame.getInstance().getJPatchScreen().update_all();
            MainFrame.getInstance().getJPatchScreen().enablePopupMenu(true);
            this.iState = IDLE;
        } else if (this.iState == SETRADIUS) {
            this.compSource.removeMouseMotionListener(this);
            SelectionFactory.setRadius(this.fRadius);
            MainFrame.getInstance().getJPatchScreen().update_all();
            MainFrame.getInstance().getJPatchScreen().enablePopupMenu(true);
            this.iState = IDLE;
        } else {
            throw new JPatchException("setIdleState() called in idle state");
        }
    }

    private final void setRadiusState() {
        if (this.iState != IDLE) {
            throw new JPatchException("setRadiusState() called in non-idle state");
        }
        this.compSource.addMouseMotionListener(this);
        MainFrame.getInstance().getJPatchScreen().enablePopupMenu(false);
        this.bNewCircle = true;
        this.iState = SETRADIUS;
    }

    private final /* synthetic */ void this() {
        this.iState = IDLE;
        this.bNewCircle = true;
        this.settings = JPatchSettings.getInstance();
    }

    public MagnetMouseAdapter() {
        this.this();
        MainFrame.getInstance().setHelpText("Click and drag empty space to set magnet influence. Click and drag on point to move.");
    }
}

