/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.selection;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.PointWeightSelection;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.Model;

public class SelectionFactory {
    static float fRadius = 5;

    public static void setRadius(float f) {
        fRadius = f;
    }

    public static PointSelection createRectangularPointSelection(int n, int n2, int n3, int n4, Matrix4f matrix4f, Model model) {
        PointSelection pointSelection = new PointSelection();
        Point3f point3f = new Point3f();
        Curve curve = model.getFirstCurve();
        while (curve != null) {
            ControlPoint controlPoint = curve.getStart();
            while (controlPoint != null) {
                if (controlPoint.isHead() && !controlPoint.isHidden()) {
                    point3f.set(controlPoint.getPosition());
                    matrix4f.transform(point3f);
                    if (point3f.x >= (float)n && point3f.x <= (float)n3 && point3f.y >= (float)n2 && point3f.y <= (float)n4) {
                        pointSelection.addControlPoint(controlPoint);
                    }
                }
                controlPoint = controlPoint.getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        return pointSelection.getSize() != 0 ? pointSelection : null;
    }

    public static PointWeightSelection createMagnetSelection(ControlPoint controlPoint, Model model) {
        PointWeightSelection pointWeightSelection = new PointWeightSelection();
        Point3f point3f = controlPoint.getPosition();
        Curve curve = model.getFirstCurve();
        while (curve != null) {
            ControlPoint controlPoint2 = curve.getStart();
            while (controlPoint2 != null) {
                float f;
                if (controlPoint2.isHead() && !controlPoint2.isHidden() && (f = point3f.distance(controlPoint2.getPosition())) < fRadius) {
                    float f2 = 0.5f + (float)Math.cos(Math.PI * (double)f / (double)fRadius) / 2.0f;
                    pointWeightSelection.addControlPoint(controlPoint2, f2);
                }
                controlPoint2 = controlPoint2.getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        return pointWeightSelection.getSize() != 0 ? pointWeightSelection : null;
    }
}

