/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.sidebar;

import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import jpatch.boundary.JPatchButton;
import jpatch.boundary.JPatchInput;
import jpatch.boundary.MainFrame;
import jpatch.boundary.action.ApplyMaterialAction;
import jpatch.boundary.action.DeleteMaterialAction;
import jpatch.boundary.action.EditMaterialAction;
import jpatch.boundary.action.SelectMaterialAction;
import jpatch.boundary.sidebar.SidePanel;
import jpatch.entity.JPatchMaterial;

public class MaterialPanel
extends SidePanel
implements ChangeListener {
    JPatchInput inputName;
    JPatchMaterial material;

    public void stateChanged(ChangeEvent changeEvent) {
        this.material.setName(this.inputName.getStringValue());
        ((DefaultTreeModel)MainFrame.getInstance().getTree().getModel()).nodeChanged(this.material);
        MainFrame.getInstance().requestFocus();
    }

    public MaterialPanel(JPatchMaterial jPatchMaterial) {
        this.material = jPatchMaterial;
        this.add(new JPatchButton(new EditMaterialAction(jPatchMaterial)));
        this.add(new JPatchButton(new DeleteMaterialAction(jPatchMaterial)));
        this.add(new JPatchButton(new ApplyMaterialAction(jPatchMaterial)));
        this.add(new JPatchButton(new SelectMaterialAction(jPatchMaterial)));
        JPatchInput.setDimensions(50, 150, 20);
        this.inputName = new JPatchInput("Name:", jPatchMaterial.getName());
        JPanel jPanel = MainFrame.getInstance().getSideBar().getDetailPanel();
        jPanel.removeAll();
        if (jPatchMaterial != MainFrame.getInstance().getModel().getMaterialList().get(0)) {
            jPanel.add(this.inputName);
            this.inputName.addChangeListener(this);
        }
        jPanel.repaint();
    }
}

