/*
 * Decompiled with CFR 0.152.
 */
package jpatch.boundary.tools;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.JPatchCanvas;
import jpatch.boundary.JPatchDrawable;
import jpatch.boundary.JPatchSettings;
import jpatch.boundary.MainFrame;
import jpatch.boundary.Viewport;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.tools.Handle;
import jpatch.boundary.tools.HandleZOrderComparator;
import jpatch.boundary.tools.JPatchTool;
import jpatch.boundary.tools.PivotHandle;
import jpatch.boundary.tools.RotateHandle;
import jpatch.boundary.tools.RotateHandleS;
import jpatch.control.edit.ChangeSelectionPivotEdit;
import jpatch.control.edit.ChangeSelectionRotationEdit;
import jpatch.control.edit.JPatchCompoundEdit;
import jpatch.control.edit.NewMoveControlPointsEdit;
import jpatch.entity.ControlPoint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RotateTool
extends JPatchTool {
    private static final int GHOST_FACTOR = JPatchSettings.getInstance().iGhost;
    private static final int SUBDIV = 64;
    private static final float S = 1.0f / (float)Math.sqrt(2);
    private static final float[] COS = new float[64];
    private static final float[] SIN = new float[64];
    private static final int IDLE = 0;
    private static final int ROTATE = 1;
    private static final int ROTATE_FREE = 2;
    private static final int PIVOT = 3;
    private boolean bAutoReset;
    private float fAlpha;
    private float fBeta;
    private float fRadius;
    private Point3f p3Pivot;
    private Matrix3f m3Rot;
    private Matrix3f m3RotA;
    private Vector3f v3AxisX;
    private Vector3f v3AxisY;
    private Vector3f v3AxisZ;
    private Handle[] aHandle;
    private HandleZOrderComparator comparator;
    private Handle activeHandle;
    private Handle pivotHandle;
    private Point3f[] ap3;
    private ControlPoint[] acp;
    private Point3f p3OldPivot;
    private int iState;
    private int iMouseX;
    private int iMouseY;
    private float fRotX;
    private float fRotY;
    private boolean bChange;
    private JPatchCompoundEdit compoundEdit;

    public int getButton() {
        return 3;
    }

    public void setRadius() {
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        float f = 0.0f;
        float f2 = 0.0f;
        this.ap3 = pointSelection.getPointArray();
        this.acp = pointSelection.getControlPointArray();
        int n = 0;
        while (n < this.ap3.length) {
            f2 = this.p3Pivot.distanceSquared(this.ap3[n]);
            if (f2 > f) {
                f = f2;
            }
            ++n;
        }
        this.fRadius = (float)Math.sqrt(f);
    }

    public float getRadius(float f) {
        return this.fRadius * f < 24.0f ? 24.0f / f : this.fRadius;
    }

    public float getAlpha() {
        return this.fAlpha;
    }

    public float getBeta() {
        return this.fBeta;
    }

    public void setAlpha(float f) {
        this.fAlpha = f;
    }

    public Matrix3f getRot() {
        return this.m3Rot;
    }

    public Matrix3f getRotA() {
        return this.m3RotA;
    }

    public Point3f getPivot() {
        return this.p3Pivot;
    }

    public void paint(Viewport viewport, JPatchDrawable jPatchDrawable) {
        float f;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Color3f color3f = new Color3f();
        Color3f color3f2 = new Color3f(this.settings.cBackground);
        Color3f color3f3 = new Color3f();
        Color3f color3f4 = new Color3f();
        Color3f color3f5 = new Color3f();
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        Matrix4f matrix4f = viewport.getViewDefinition().getMatrix();
        float f2 = matrix4f.getScale();
        float f3 = this.getRadius(f2);
        Point3f point3f5 = new Point3f(this.p3Pivot);
        matrix4f.transform(point3f5);
        float f4 = 1.0f / (f3 * viewport.getViewDefinition().getScale() * viewport.getViewDefinition().getWidth());
        point3f.set(0.0f, f3 * COS[63], f3 * SIN[63]);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        matrix4f.transform(point3f);
        color3f.set(this.settings.cX);
        int n = 0;
        while (n < 64) {
            point3f2.set(0.0f, f3 * COS[n], f3 * SIN[n]);
            this.m3RotA.transform(point3f2);
            point3f2.add(this.p3Pivot);
            matrix4f.transform(point3f2);
            f = (point3f.z - point3f5.z) * f4 + 0.3f;
            color3f3.interpolate(color3f, color3f2, f);
            color3f3.clamp(0.1f, 1.0f);
            jPatchDrawable.setColor(color3f3.get());
            jPatchDrawable.drawGhostLine3D(point3f, point3f2, GHOST_FACTOR);
            point3f.set(point3f2);
            ++n;
        }
        point3f.set(-f3, 0.0f, 0.0f);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        point3f2.set(f3, 0.0f, 0.0f);
        this.m3RotA.transform(point3f2);
        point3f2.add(this.p3Pivot);
        matrix4f.transform(point3f);
        matrix4f.transform(point3f2);
        color3f.set(this.settings.cX);
        f = (point3f.z - point3f5.z) * f4 + 0.3f;
        color3f4.interpolate(color3f, color3f2, f);
        color3f4.clamp(0.1f, 1.0f);
        f = (point3f2.z - point3f5.z) * f4 + 0.3f;
        color3f5.interpolate(color3f, color3f2, f);
        color3f5.clamp(0.1f, 1.0f);
        point3f3 = new Point3f(point3f);
        point3f4 = new Point3f();
        float f5 = 0.1f;
        while (f5 < 1.1f) {
            color3f3.interpolate(color3f4, color3f5, f5);
            jPatchDrawable.setColor(color3f3.get());
            point3f4.interpolate(point3f, point3f2, f5);
            jPatchDrawable.drawGhostLine3D(point3f3, point3f4, GHOST_FACTOR);
            point3f3.set(point3f4);
            f5 += 0.1f;
        }
        point3f.set(f3 * COS[63], 0.0f, f3 * SIN[63]);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        matrix4f.transform(point3f);
        color3f.set(this.settings.cY);
        int n2 = 0;
        while (n2 < 64) {
            point3f2.set(f3 * COS[n2], 0.0f, f3 * SIN[n2]);
            this.m3RotA.transform(point3f2);
            point3f2.add(this.p3Pivot);
            matrix4f.transform(point3f2);
            f = (point3f.z - point3f5.z) * f4 + 0.3f;
            color3f3.interpolate(color3f, color3f2, f);
            color3f3.clamp(0.1f, 1.0f);
            jPatchDrawable.setColor(color3f3.get());
            jPatchDrawable.drawGhostLine3D(point3f, point3f2, GHOST_FACTOR);
            point3f.set(point3f2);
            ++n2;
        }
        point3f.set(0.0f, -f3, 0.0f);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        point3f2.set(0.0f, f3, 0.0f);
        this.m3RotA.transform(point3f2);
        point3f2.add(this.p3Pivot);
        matrix4f.transform(point3f);
        matrix4f.transform(point3f2);
        color3f.set(this.settings.cY);
        f = (point3f.z - point3f5.z) * f4 + 0.3f;
        color3f4.interpolate(color3f, color3f2, f);
        color3f4.clamp(0.1f, 1.0f);
        f = (point3f2.z - point3f5.z) * f4 + 0.3f;
        color3f5.interpolate(color3f, color3f2, f);
        color3f5.clamp(0.1f, 1.0f);
        point3f3 = new Point3f(point3f);
        point3f4 = new Point3f();
        float f6 = 0.1f;
        while (f6 < 1.1f) {
            color3f3.interpolate(color3f4, color3f5, f6);
            jPatchDrawable.setColor(color3f3.get());
            point3f4.interpolate(point3f, point3f2, f6);
            jPatchDrawable.drawGhostLine3D(point3f3, point3f4, GHOST_FACTOR);
            point3f3.set(point3f4);
            f6 += 0.1f;
        }
        point3f.set(f3 * COS[63], f3 * SIN[63], 0.0f);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        matrix4f.transform(point3f);
        color3f.set(this.settings.cZ);
        int n3 = 0;
        while (n3 < 64) {
            point3f2.set(f3 * COS[n3], f3 * SIN[n3], 0.0f);
            this.m3RotA.transform(point3f2);
            point3f2.add(this.p3Pivot);
            matrix4f.transform(point3f2);
            f = (point3f.z - point3f5.z) * f4 + 0.3f;
            color3f3.interpolate(color3f, color3f2, f);
            color3f3.clamp(0.1f, 1.0f);
            jPatchDrawable.setColor(color3f3.get());
            jPatchDrawable.drawGhostLine3D(point3f, point3f2, GHOST_FACTOR);
            point3f.set(point3f2);
            ++n3;
        }
        point3f.set(0.0f, 0.0f, -f3);
        this.m3RotA.transform(point3f);
        point3f.add(this.p3Pivot);
        point3f2.set(0.0f, 0.0f, f3);
        this.m3RotA.transform(point3f2);
        point3f2.add(this.p3Pivot);
        matrix4f.transform(point3f);
        matrix4f.transform(point3f2);
        color3f.set(this.settings.cZ);
        f = (point3f.z - point3f5.z) * f4 + 0.3f;
        color3f4.interpolate(color3f, color3f2, f);
        color3f4.clamp(0.1f, 1.0f);
        f = (point3f2.z - point3f5.z) * f4 + 0.3f;
        color3f5.interpolate(color3f, color3f2, f);
        color3f5.clamp(0.1f, 1.0f);
        point3f3 = new Point3f(point3f);
        point3f4 = new Point3f();
        float f7 = 0.1f;
        while (f7 < 1.1f) {
            color3f3.interpolate(color3f4, color3f5, f7);
            jPatchDrawable.setColor(color3f3.get());
            point3f4.interpolate(point3f, point3f2, f7);
            jPatchDrawable.drawGhostLine3D(point3f3, point3f4, GHOST_FACTOR);
            point3f3.set(point3f4);
            f7 += 0.1f;
        }
        jPatchDrawable.setColor(this.settings.cSelection);
        point3f.set(f3 * COS[63], f3 * SIN[63], 0.0f);
        Matrix3f matrix3f = new Matrix3f();
        matrix4f.get(matrix3f);
        matrix3f.invert();
        matrix3f.transform(point3f);
        point3f.add(this.p3Pivot);
        matrix4f.transform(point3f);
        int n4 = 0;
        while (n4 < 64) {
            point3f2.set(f3 * COS[n4], f3 * SIN[n4], 0.0f);
            matrix3f.transform(point3f2);
            point3f2.add(this.p3Pivot);
            matrix4f.transform(point3f2);
            jPatchDrawable.drawGhostLine3D(point3f, point3f2, GHOST_FACTOR);
            point3f.set(point3f2);
            ++n4;
        }
        this.comparator.setMatrix(matrix4f);
        Arrays.sort(this.aHandle, this.comparator);
        n4 = this.aHandle.length - 1;
        while (n4 >= 0) {
            this.aHandle[n4].paint(viewport, jPatchDrawable);
            --n4;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.fBeta = this.fAlpha;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
            this.ap3 = pointSelection.getPointArray();
            this.acp = pointSelection.getControlPointArray();
            boolean bl = false;
            Viewport viewport = (Viewport)mouseEvent.getSource();
            this.paint(viewport, ((JPatchCanvas)mouseEvent.getSource()).getDrawable());
            float f = Float.MAX_VALUE;
            Point3f point3f = new Point3f();
            if (this.activeHandle != null) {
                ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.activeHandle);
                this.activeHandle = null;
                bl = true;
            }
            int n3 = 0;
            while (n3 < this.aHandle.length) {
                if (this.aHandle[n3].isHit(viewport, n, n2, point3f) && (this.activeHandle == null || point3f.z < f)) {
                    f = point3f.z;
                    this.activeHandle = this.aHandle[n3];
                }
                ++n3;
            }
            if (this.activeHandle != null && mouseEvent.getClickCount() == 2 && !this.bChange) {
                if (this.activeHandle == this.pivotHandle) {
                    this.p3OldPivot.set(this.p3Pivot);
                    pointSelection.resetPivotToCenter();
                    this.setRadius();
                    MainFrame.getInstance().getUndoManager().addEdit(new ChangeSelectionPivotEdit(pointSelection, this.p3OldPivot, this));
                } else {
                    this.m3RotA.setIdentity();
                    MainFrame.getInstance().getUndoManager().addEdit(new ChangeSelectionRotationEdit(pointSelection, this.m3RotA, 0.0f, this));
                }
            }
            this.setPassive();
            this.iState = 0;
            this.bChange = false;
            if (this.activeHandle != null) {
                this.activeHandle.setActive(true);
                this.activeHandle.setMouse(n, n2);
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this.activeHandle);
                ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                bl = true;
                if (this.activeHandle == this.pivotHandle) {
                    this.iState = 3;
                    this.p3OldPivot.set(this.p3Pivot);
                } else {
                    this.iState = 1;
                    this.compoundEdit = new JPatchCompoundEdit("rotate");
                    this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointSelection.getControlPointArray()));
                }
            } else {
                Point3f point3f2 = new Point3f(this.p3Pivot);
                Matrix4f matrix4f = viewport.getViewDefinition().getMatrix();
                matrix4f.transform(point3f2);
                float f2 = matrix4f.getScale() * this.getRadius(matrix4f.getScale());
                float f3 = f2 * f2;
                float f4 = (float)n - point3f2.x;
                float f5 = (float)n2 - point3f2.y;
                if (f4 * f4 + f5 * f5 < f3) {
                    this.iMouseX = mouseEvent.getX();
                    this.iMouseY = mouseEvent.getY();
                    ((Component)mouseEvent.getSource()).addMouseMotionListener(this);
                    this.iState = 2;
                    this.compoundEdit = new JPatchCompoundEdit("rotate");
                    this.compoundEdit.addEdit(new NewMoveControlPointsEdit(pointSelection.getControlPointArray()));
                }
            }
            if (bl) {
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            }
            MainFrame.getInstance().setHelpText("Hold SHIFT to disable 5\u00ef\u00bf\u00bd steps.");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.bChange && this.iState != 0) {
                PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
                if (pointSelection != null) {
                    if (this.iState == 1 || this.iState == 2) {
                        this.compoundEdit.addEdit(new ChangeSelectionRotationEdit(pointSelection, this.m3RotA, this.fBeta, this));
                    } else if (this.iState == 3) {
                        this.compoundEdit = new JPatchCompoundEdit("pivot");
                        this.compoundEdit.addEdit(new ChangeSelectionPivotEdit(pointSelection, this.p3OldPivot, this));
                    } else {
                        System.err.println("error in RotateTool");
                    }
                    MainFrame.getInstance().getUndoManager().addEdit(this.compoundEdit);
                    MainFrame.getInstance().getJPatchScreen().full_update();
                }
                this.iState = 0;
                this.bChange = false;
            }
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this.activeHandle);
            ((Component)mouseEvent.getSource()).removeMouseMotionListener(this);
            MainFrame.getInstance().setHelpText("Click and drag handles to rotate or move pivot. Click and drag inside sphere to rotate freely. Doubleclick to reset coordinate system or pivot.");
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.bChange = true;
        if (this.iState == 2) {
            Matrix3f matrix3f = new Matrix3f();
            AxisAngle4f axisAngle4f = new AxisAngle4f();
            Vector3f vector3f = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
            float f = 0.0f;
            Matrix4f matrix4f = ((Viewport)mouseEvent.getSource()).getViewDefinition().getMatrix();
            float f2 = matrix4f.getScale();
            matrix4f.get(matrix3f);
            matrix3f.invert();
            matrix3f.transform(vector3f);
            matrix3f.transform(vector3f2);
            vector3f.normalize();
            vector3f2.normalize();
            int n = mouseEvent.getX() - this.iMouseX;
            int n2 = mouseEvent.getY() - this.iMouseY;
            float f3 = (float)(-n2) / matrix4f.getScale() / this.getRadius(f2) * 180.0f / (float)Math.PI;
            float f4 = (float)n / matrix4f.getScale() / this.getRadius(f2) * 180.0f / (float)Math.PI;
            if (!mouseEvent.isShiftDown()) {
                f3 = (float)Math.round(f3 / (float)5) * (float)5;
                f4 = (float)Math.round(f4 / (float)5) * (float)5;
            }
            if (f3 != this.fRotX || f4 != this.fRotY) {
                this.fRotX = f3;
                this.fRotY = f4;
                matrix3f.set(this.getRot());
                matrix3f.invert();
                matrix3f.transform(vector3f);
                vector3f.normalize();
                axisAngle4f.set(vector3f, f3 / 360.0f * 2.0f * (float)Math.PI);
                matrix3f.set(axisAngle4f);
                this.getRotA().set(this.getRot());
                this.getRotA().mul(matrix3f);
                matrix3f.set(this.getRot());
                matrix3f.invert();
                matrix3f.transform(vector3f2);
                vector3f2.normalize();
                axisAngle4f.set(vector3f2, f4 / 360.0f * 2.0f * (float)Math.PI);
                matrix3f.set(axisAngle4f);
                this.getRotA().mul(matrix3f);
                if (!mouseEvent.isControlDown()) {
                    this.rotate();
                }
                MainFrame.getInstance().getJPatchScreen().single_update((Component)mouseEvent.getSource());
            }
        }
    }

    public void reset() {
        this.m3Rot.setIdentity();
        this.m3RotA.setIdentity();
        this.setPassive();
    }

    public void reInit(PointSelection pointSelection) {
        this.m3Rot = pointSelection.getRotation();
        this.p3Pivot = pointSelection.getPivot();
        this.m3RotA.set(this.m3Rot);
    }

    private final void setPassive() {
        int n = 0;
        while (n < this.aHandle.length) {
            this.aHandle[n].setActive(false);
            ++n;
        }
    }

    public void rotate() {
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f(this.p3Pivot);
        int n = 0;
        while (n < this.acp.length) {
            ControlPoint controlPoint = this.acp[n];
            point3f.set(this.ap3[n]);
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.setIdentity();
            Matrix4f matrix4f2 = new Matrix4f();
            matrix4f.set(vector3f);
            matrix4f2.setIdentity();
            matrix4f2.set(this.m3RotA);
            matrix4f.mul(matrix4f2);
            matrix4f2.setIdentity();
            matrix4f2.set(this.m3Rot);
            matrix4f2.invert();
            matrix4f.mul(matrix4f2);
            vector3f.scale(-1.0f);
            matrix4f2.set(vector3f);
            vector3f.scale(-1.0f);
            matrix4f.mul(matrix4f2);
            matrix4f.transform(point3f);
            MainFrame.getInstance().getConstraints().setControlPointPosition(controlPoint, point3f);
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.bAutoReset = false;
        this.fBeta = 0.0f;
        this.fRadius = 0.0f;
        this.m3RotA = new Matrix3f();
        this.v3AxisX = new Vector3f(1.0f, 0.0f, 0.0f);
        this.v3AxisY = new Vector3f(0.0f, 1.0f, 0.0f);
        this.v3AxisZ = new Vector3f(0.0f, 0.0f, 1.0f);
        this.comparator = new HandleZOrderComparator();
        this.p3OldPivot = new Point3f();
        this.iState = 0;
        this.fRotX = 0.0f;
        this.fRotY = 0.0f;
    }

    public RotateTool() {
        this.this();
        PointSelection pointSelection = MainFrame.getInstance().getPointSelection();
        this.p3Pivot = pointSelection.getPivot();
        this.m3Rot = pointSelection.getRotation();
        this.m3RotA.set(this.m3Rot);
        this.setRadius();
        this.pivotHandle = new PivotHandle(this, this.settings.cSelection);
        Matrix3f matrix3f = new Matrix3f();
        Matrix3f matrix3f2 = new Matrix3f();
        Matrix3f matrix3f3 = new Matrix3f();
        matrix3f.rotX(0.7853982f);
        matrix3f2.rotY(0.7853982f);
        matrix3f3.rotZ(0.7853982f);
        this.aHandle = new Handle[]{new RotateHandle(new Point3f(0.0f, S, S), this, this.settings.cX, this.v3AxisX, matrix3f), new RotateHandle(new Point3f(0.0f, -S, S), this, this.settings.cX, this.v3AxisX, matrix3f), new RotateHandle(new Point3f(0.0f, -S, -S), this, this.settings.cX, this.v3AxisX, matrix3f), new RotateHandle(new Point3f(0.0f, S, -S), this, this.settings.cX, this.v3AxisX, matrix3f), new RotateHandle(new Point3f(S, 0.0f, S), this, this.settings.cY, this.v3AxisY, matrix3f2), new RotateHandle(new Point3f(-S, 0.0f, S), this, this.settings.cY, this.v3AxisY, matrix3f2), new RotateHandle(new Point3f(-S, 0.0f, -S), this, this.settings.cY, this.v3AxisY, matrix3f2), new RotateHandle(new Point3f(S, 0.0f, -S), this, this.settings.cY, this.v3AxisY, matrix3f2), new RotateHandle(new Point3f(S, S, 0.0f), this, this.settings.cZ, this.v3AxisZ, matrix3f3), new RotateHandle(new Point3f(-S, S, 0.0f), this, this.settings.cZ, this.v3AxisZ, matrix3f3), new RotateHandle(new Point3f(-S, -S, 0.0f), this, this.settings.cZ, this.v3AxisZ, matrix3f3), new RotateHandle(new Point3f(S, -S, 0.0f), this, this.settings.cZ, this.v3AxisZ, matrix3f3), new RotateHandleS(new Point3f(0.0f, 1.0f, 0.0f), this, this.settings.cSelection), new RotateHandleS(new Point3f(1.0f, 0.0f, 0.0f), this, this.settings.cSelection), new RotateHandleS(new Point3f(0.0f, -1.0f, 0.0f), this, this.settings.cSelection), new RotateHandleS(new Point3f(-1.0f, 0.0f, 0.0f), this, this.settings.cSelection), this.pivotHandle};
        MainFrame.getInstance().setHelpText("Click and drag handles to rotate or move pivot. Click and drag inside sphere to rotate freely. Doubleclick to reset coordinate system or pivot.");
    }

    static {
        int n = 0;
        while (n < 64) {
            RotateTool.COS[n] = (float)Math.cos((double)((float)n / 64.0f * 2.0f) * Math.PI);
            RotateTool.SIN[n] = (float)Math.sin((double)((float)n / 64.0f * 2.0f) * Math.PI);
            ++n;
        }
    }
}

