/*
 * Decompiled with CFR 0.152.
 */
package jpatch.control.importer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.boundary.Rotoscope;
import jpatch.boundary.selection.PointSelection;
import jpatch.boundary.selection.Selection;
import jpatch.control.ModelImporter;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.MaterialProperties;
import jpatch.entity.Model;
import jpatch.entity.Morph;
import jpatch.entity.Patch;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPatchImport
extends DefaultHandler
implements ModelImporter {
    private static final int NULL = 0;
    private static final int MODEL = 1;
    private static final int MATERIAL = 2;
    private static final int MESH = 3;
    private static final int PATCH = 4;
    private static final int SELECTION = 5;
    private static final int ROTOSCOPE = 6;
    private static final int MORPH = 7;
    private static final int TARGET = 8;
    private static final int LIPSYNC = 9;
    private Model model;
    private int iState;
    private ArrayList listCp;
    private ArrayList listAttach;
    private ArrayList listHook;
    private boolean bCurveClosed;
    private Curve curve;
    private ControlPoint cpFirst;
    private ControlPoint cp;
    private ControlPoint cpPrev;
    private Rotoscope rotoscope;
    private int iRotoscopeView;
    private JPatchMaterial material;
    private Selection selection;
    private Morph morph;
    private List listMaterials;
    private ArrayList listCandidateFivePointPatch;
    private CharReader charReader;

    public final String importModel(Model model, String string) {
        this.model = model;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(new InputSource(string));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        model.addCandidateFivePointPatchList(this.listCandidateFivePointPatch);
        model.computePatches();
        return "";
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch (this.iState) {
            case 0: {
                if (!string2.equals("model")) break;
                this.iState = 1;
                break;
            }
            case 1: {
                if (string2.equals("name")) {
                    this.charReader = new ModelNameCharReader(this.model);
                    break;
                }
                if (string2.equals("material")) {
                    this.iState = 2;
                    this.material = this.createMaterial(attributes);
                    break;
                }
                if (string2.equals("mesh")) {
                    this.iState = 3;
                    break;
                }
                if (string2.equals("selection")) {
                    this.iState = 5;
                    this.charReader = new ArrayCharReader();
                    this.selection = this.createSelection(attributes);
                    break;
                }
                if (!string2.equals("rotoscope")) break;
                this.iState = 6;
                this.rotoscope = this.createRotoscope(attributes);
                break;
            }
            case 3: {
                if (string2.equals("curve")) {
                    this.parseCurve(attributes);
                    this.cpFirst = null;
                    break;
                }
                if (string2.equals("cp")) {
                    this.cp = this.createCp(attributes);
                    this.listCp.add(this.cp);
                    if (this.cpFirst != null) break;
                    this.cpFirst = this.cp;
                    break;
                }
                if (string2.equals("patch")) {
                    this.iState = 4;
                    this.material = this.getPatchMaterial(attributes);
                    break;
                }
                if (string2.equals("morph")) {
                    this.iState = 7;
                    this.morph = this.createMorph(attributes);
                    break;
                }
                if (!string2.equals("lipsync")) break;
                this.iState = 9;
                break;
            }
            case 4: {
                if (!string2.equals("points")) break;
                this.charReader = new ArrayCharReader();
                break;
            }
            case 2: {
                if (string2.equals("name")) {
                    this.charReader = new MaterialNameCharReader(this.material);
                    break;
                }
                if (string2.equals("color")) {
                    this.parseMaterialColor(attributes, this.material.getMaterialProperties());
                    break;
                }
                if (string2.equals("finish")) {
                    this.parseMaterialFinish(attributes, this.material.getMaterialProperties());
                    break;
                }
                if (string2.equals("reflection")) {
                    this.parseMaterialReflection(attributes, this.material.getMaterialProperties());
                    break;
                }
                if (string2.equals("refraction")) {
                    this.parseMaterialRefraction(attributes, this.material.getMaterialProperties());
                    break;
                }
                if (!string2.equals("renderer")) break;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                this.parseMaterialRenderer(attributes, stringBuffer, stringBuffer2);
                this.charReader = new RenderStringCharReader(stringBuffer.toString(), stringBuffer2.toString());
                break;
            }
            case 6: {
                if (string2.equals("image")) {
                    this.charReader = new RotoscopeImageCharReader(this.rotoscope);
                    break;
                }
                if (!string2.equals("display")) break;
                this.parseRotoscopeDisplay(attributes, this.rotoscope);
                break;
            }
            case 7: {
                if (!string2.equals("target")) break;
                this.iState = 8;
                break;
            }
            case 8: {
                if (!string2.equals("point")) break;
                this.parseMorphVector(attributes, this.morph);
                break;
            }
            case 9: {
                if (!string2.equals("map")) break;
                this.parseLipsyncMap(attributes);
                break;
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        switch (this.iState) {
            case 1: {
                if (string2.equals("model")) {
                    this.iState = 0;
                    break;
                }
                if (!string2.equals("name")) break;
                this.charReader = new CharReader();
                break;
            }
            case 2: {
                if (string2.equals("material")) {
                    if (this.material.getName().equals("Default Material")) {
                        List list = this.model.getMaterialList();
                        JPatchMaterial jPatchMaterial = null;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            jPatchMaterial = (JPatchMaterial)iterator.next();
                            if (jPatchMaterial.getName().equals("Default Material")) break;
                        }
                        jPatchMaterial.getMaterialProperties().set(this.material.getMaterialProperties());
                        jPatchMaterial.setRenderStrings(this.material.getRenderStrings());
                        this.material = jPatchMaterial;
                    } else {
                        this.model.addMaterial(this.material);
                    }
                    this.listMaterials.add(this.material);
                    this.iState = 1;
                    break;
                }
                if (string2.equals("name")) {
                    this.charReader = new CharReader();
                    break;
                }
                if (!string2.equals("renderer")) break;
                String string4 = ((RenderStringCharReader)this.charReader).getFormat();
                String string5 = ((RenderStringCharReader)this.charReader).getVersion();
                String string6 = ((RenderStringCharReader)this.charReader).getRenderString();
                this.material.setRenderString(string4, string5, string6);
                this.charReader = new CharReader();
                break;
            }
            case 3: {
                if (string2.equals("mesh")) {
                    this.attach();
                    this.hook();
                    this.iState = 1;
                    break;
                }
                if (string2.equals("curve")) {
                    if (this.bCurveClosed) {
                        this.cpPrev.setNext(this.cpFirst);
                        this.cpFirst.setPrev(this.cpPrev);
                        this.cpFirst.setLoop(true);
                    }
                    this.model.addCurve(this.cpFirst);
                    this.curve = null;
                    this.cpPrev = null;
                    break;
                }
                if (!string2.equals("cp")) break;
                if (this.cpPrev != null) {
                    this.cpPrev.setNext(this.cp);
                }
                this.cp.setPrev(this.cpPrev);
                this.cpPrev = this.cp;
                this.cp = null;
                break;
            }
            case 4: {
                if (string2.equals("points")) {
                    int[] nArray = ((ArrayCharReader)this.charReader).getIntArray();
                    ControlPoint[] controlPointArray = new ControlPoint[nArray.length];
                    int n = 0;
                    while (n < controlPointArray.length) {
                        controlPointArray[n] = (ControlPoint)this.listCp.get(nArray[n]);
                        ++n;
                    }
                    Patch patch = new Patch(controlPointArray);
                    patch.setMaterial(this.material);
                    this.model.addPatch(patch, null);
                    if (controlPointArray.length == 10) {
                        ControlPoint[] controlPointArray2 = new ControlPoint[]{this.trueHead(controlPointArray[0]), this.trueHead(controlPointArray[2]), this.trueHead(controlPointArray[4]), this.trueHead(controlPointArray[6]), this.trueHead(controlPointArray[8])};
                        this.listCandidateFivePointPatch.add(controlPointArray2);
                    }
                    this.charReader = new CharReader();
                    break;
                }
                if (!string2.equals("patch")) break;
                this.iState = 3;
                break;
            }
            case 5: {
                if (!string2.equals("selection")) break;
                this.iState = 1;
                int[] nArray = ((ArrayCharReader)this.charReader).getIntArray();
                int n = 0;
                while (n < nArray.length) {
                    ((PointSelection)this.selection).addControlPoint((ControlPoint)this.listCp.get(nArray[n]));
                    ++n;
                }
                this.model.addSelection(this.selection);
                break;
            }
            case 6: {
                if (string2.equals("rotoscope")) {
                    this.iState = 1;
                    if (!this.rotoscope.isValid()) break;
                    this.model.setRotoscope(this.iRotoscopeView, this.rotoscope);
                    break;
                }
                if (!string2.equals("image")) break;
                this.charReader = new CharReader();
                break;
            }
            case 7: {
                if (!string2.equals("morph")) break;
                this.model.addExpression(this.morph);
                this.iState = 3;
                break;
            }
            case 8: {
                if (!string2.equals("target")) break;
                this.iState = 7;
                break;
            }
            case 9: {
                if (!string2.equals("lipsync")) break;
                this.iState = 3;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        this.charReader.string(string);
    }

    private final Rotoscope createRotoscope(Attributes attributes) {
        Rotoscope rotoscope = new Rotoscope();
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            this.iRotoscopeView = -1;
            if (string.equals("view")) {
                if (string2.equals("front")) {
                    this.iRotoscopeView = 1;
                }
                if (string2.equals("rear")) {
                    this.iRotoscopeView = 2;
                }
                if (string2.equals("top")) {
                    this.iRotoscopeView = 3;
                }
                if (string2.equals("bottom")) {
                    this.iRotoscopeView = 4;
                }
                if (string2.equals("left")) {
                    this.iRotoscopeView = 5;
                }
                if (string2.equals("right")) {
                    this.iRotoscopeView = 6;
                }
            }
            ++n;
        }
        return rotoscope;
    }

    private final Morph createMorph(Attributes attributes) {
        Morph morph = new Morph(11, "");
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("name")) {
                morph.setName(string2);
            } else if (string.equals("min")) {
                morph.setMin(new Float(string2).floatValue());
            } else if (string.equals("max")) {
                morph.setMax(new Float(string2).floatValue());
            } else if (string.equals("value")) {
                morph.setValue(new Float(string2).floatValue());
            }
            ++n;
        }
        return morph;
    }

    private final void parseLipsyncMap(Attributes attributes) {
        String string = "";
        int n = -1;
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            String string2 = attributes.getLocalName(n2);
            String string3 = attributes.getValue(n2);
            if (string2.equals("phoneme")) {
                string = string3;
            } else if (string2.equals("morph")) {
                n = Integer.parseInt(string3);
            }
            ++n2;
        }
        this.model.setMorphFor(string, (Morph)this.model.getMorphList().get(n));
    }

    private final void parseMorphVector(Attributes attributes, Morph morph) {
        ControlPoint controlPoint = null;
        Vector3f vector3f = new Vector3f();
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("nr")) {
                controlPoint = (ControlPoint)this.listCp.get(new Integer(string2));
            } else if (string.equals("x")) {
                vector3f.x = new Float(string2).floatValue();
            } else if (string.equals("y")) {
                vector3f.y = new Float(string2).floatValue();
            } else if (string.equals("z")) {
                vector3f.z = new Float(string2).floatValue();
            }
            ++n;
        }
        morph.add(controlPoint, vector3f);
    }

    private final Selection createSelection(Attributes attributes) {
        PointSelection pointSelection = new PointSelection();
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("name")) {
                pointSelection.setName(string2);
            }
            ++n;
        }
        return pointSelection;
    }

    private final JPatchMaterial getPatchMaterial(Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("material")) {
                int n2 = Integer.parseInt(string2);
                if (n2 == -1) {
                    return null;
                }
                return (JPatchMaterial)this.listMaterials.get(n2);
            }
            ++n;
        }
        return null;
    }

    private final JPatchMaterial createMaterial(Attributes attributes) {
        JPatchMaterial jPatchMaterial = new JPatchMaterial();
        return jPatchMaterial;
    }

    private final ControlPoint createCp(Attributes attributes) {
        ControlPoint controlPoint = new ControlPoint();
        controlPoint.setMode(4);
        Point3f point3f = controlPoint.getPosition();
        float f = -1.0f;
        int n = -1;
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2);
            if (string.equals("x")) {
                point3f.x = new Float(string2).floatValue();
            } else if (string.equals("y")) {
                point3f.y = new Float(string2).floatValue();
            } else if (string.equals("z")) {
                point3f.z = new Float(string2).floatValue();
            } else if (string.equals("attach")) {
                this.listAttach.add(controlPoint);
                this.listAttach.add(new Integer(string2));
            } else if (string.equals("hook")) {
                this.listHook.add(controlPoint);
                this.listHook.add(new Integer(string2));
            } else if (string.equals("hookpos")) {
                controlPoint.setHookPos(new Float(string2).floatValue());
            } else if (string.equals("magnitude")) {
                controlPoint.setMagnitude(new Float(string2).floatValue());
            } else if (string.equals("in_magnitude")) {
                controlPoint.setInMagnitude(new Float(string2).floatValue());
            } else if (string.equals("out_magnitude")) {
                controlPoint.setOutMagnitude(new Float(string2).floatValue());
            } else if (string.equals("mode")) {
                if (string2.equals("peak")) {
                    controlPoint.setMode(0);
                } else if (string2.equals("spatch")) {
                    controlPoint.setMode(1);
                }
            }
            ++n2;
        }
        controlPoint.setPosition(point3f);
        return controlPoint;
    }

    private final void parseRotoscopeDisplay(Attributes attributes, Rotoscope rotoscope) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("x")) {
                f2 = new Float(string2).floatValue();
            } else if (string.equals("y")) {
                f = new Float(string2).floatValue();
            } else if (string.equals("scale")) {
                rotoscope.setScale(new Float(string2).floatValue());
            } else if (string.equals("opacity")) {
                rotoscope.setOpacity(new Integer(string2));
            }
            ++n;
        }
        rotoscope.setPosition(f2, f);
    }

    private final void parseMaterialColor(Attributes attributes, MaterialProperties materialProperties) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("r")) {
                materialProperties.red = new Float(string2).floatValue();
            } else if (string.equals("g")) {
                materialProperties.green = new Float(string2).floatValue();
            } else if (string.equals("b")) {
                materialProperties.blue = new Float(string2).floatValue();
            } else if (string.equals("filter")) {
                materialProperties.filter = new Float(string2).floatValue();
            } else if (string.equals("transmit")) {
                materialProperties.transmit = new Float(string2).floatValue();
            }
            ++n;
        }
    }

    private final void parseMaterialFinish(Attributes attributes, MaterialProperties materialProperties) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("ambient")) {
                materialProperties.ambient = new Float(string2).floatValue();
            } else if (string.equals("diffuse")) {
                materialProperties.diffuse = new Float(string2).floatValue();
            } else if (string.equals("brilliance")) {
                materialProperties.brilliance = new Float(string2).floatValue();
            } else if (string.equals("specular")) {
                materialProperties.specular = new Float(string2).floatValue();
            } else if (string.equals("roughness")) {
                materialProperties.roughness = new Float(string2).floatValue();
            } else if (string.equals("metallic")) {
                materialProperties.metallic = new Float(string2).floatValue();
            }
            ++n;
        }
    }

    private final void parseMaterialReflection(Attributes attributes, MaterialProperties materialProperties) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("amount")) {
                materialProperties.reflectionMax = materialProperties.reflectionMin = new Float(string2).floatValue();
                materialProperties.reflectionFalloff = 1.0f;
            } else if (string.equals("min")) {
                materialProperties.reflectionMin = new Float(string2).floatValue();
            } else if (string.equals("max")) {
                materialProperties.reflectionMax = new Float(string2).floatValue();
            } else if (string.equals("falloff")) {
                materialProperties.reflectionFalloff = new Float(string2).floatValue();
            } else if (string.equals("conserve_energy")) {
                materialProperties.conserveEnergy = new Boolean(string2);
            }
            ++n;
        }
    }

    private final void parseMaterialRefraction(Attributes attributes, MaterialProperties materialProperties) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("index")) {
                materialProperties.refraction = new Float(string2).floatValue();
            }
            ++n;
        }
    }

    private final void parseMaterialRenderer(Attributes attributes, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("format")) {
                stringBuffer.append(string2);
            } else if (string.equals("version")) {
                stringBuffer2.append(string2);
            }
            ++n;
        }
    }

    private final void parseCurve(Attributes attributes) {
        this.bCurveClosed = false;
        int n = 0;
        while (n < attributes.getLength()) {
            String string = attributes.getLocalName(n);
            String string2 = attributes.getValue(n);
            if (string.equals("closed")) {
                this.bCurveClosed = new Boolean(string2);
            }
            ++n;
        }
    }

    private final void hook() {
        int n = 0;
        while (n < this.listHook.size()) {
            ControlPoint controlPoint = (ControlPoint)this.listHook.get(n++);
            ControlPoint controlPoint2 = (ControlPoint)this.listCp.get((Integer)this.listHook.get(n++));
            controlPoint.setParentHook(controlPoint2);
            if (controlPoint.getHookPos() != 0.0f) continue;
            controlPoint2.setChildHook(controlPoint);
        }
    }

    private final void attach() {
        int n = 0;
        while (n < this.listAttach.size()) {
            ((ControlPoint)this.listAttach.get(n++)).attachTo((ControlPoint)this.listCp.get((Integer)this.listAttach.get(n)));
            ++n;
        }
    }

    private final ControlPoint trueHead(ControlPoint controlPoint) {
        return controlPoint.getParentHook() == null ? controlPoint.getHead() : controlPoint.getParentHook().getHead();
    }

    private final /* synthetic */ void this() {
        this.iState = 0;
        this.listCp = new ArrayList();
        this.listAttach = new ArrayList();
        this.listHook = new ArrayList();
        this.listMaterials = new ArrayList();
        this.listCandidateFivePointPatch = new ArrayList();
        this.charReader = new CharReader();
    }

    public JPatchImport() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ModelNameCharReader
    extends CharReader {
        private Model model;

        protected void string(String string) {
            this.model.setName(string);
        }

        private ModelNameCharReader(Model model) {
            this.model = model;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ArrayCharReader
    extends CharReader {
        private String str;

        protected void string(String string) {
            this.str = this.str + string;
        }

        protected String[] getStringArray() {
            return this.str.split(",");
        }

        protected int[] getIntArray() {
            String[] stringArray = this.str.split(",");
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                nArray[n] = new Integer(stringArray[n]);
                ++n;
            }
            return nArray;
        }

        private final /* synthetic */ void this() {
            this.str = "";
        }

        ArrayCharReader() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MaterialNameCharReader
    extends CharReader {
        private JPatchMaterial material;

        protected void string(String string) {
            this.material.setName(string);
        }

        private MaterialNameCharReader(JPatchMaterial jPatchMaterial) {
            this.material = jPatchMaterial;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RenderStringCharReader
    extends CharReader {
        private StringBuffer stringBuffer;
        private String format;
        private String version;

        protected void string(String string) {
            this.stringBuffer.append(string);
        }

        protected String getRenderString() {
            return this.stringBuffer.toString();
        }

        protected String getFormat() {
            return this.format;
        }

        protected String getVersion() {
            return this.version;
        }

        private final /* synthetic */ void this() {
            this.stringBuffer = new StringBuffer();
        }

        private RenderStringCharReader(String string, String string2) {
            this.this();
            this.format = string;
            this.version = string2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RotoscopeImageCharReader
    extends CharReader {
        private Rotoscope rotoscope;

        protected void string(String string) {
            this.rotoscope.loadImageFromFile(string);
        }

        private RotoscopeImageCharReader(Rotoscope rotoscope) {
            this.rotoscope = rotoscope;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CharReader {
        protected void string(String string) {
        }

        private CharReader() {
        }
    }
}

