/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.Bezier;
import jpatch.auxilary.XMLutils;
import jpatch.entity.Curve;
import jpatch.entity.JPatchException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ControlPoint
implements Comparable {
    public static final int PEAK = 0;
    public static final int SPATCH_ROUND = 1;
    public static final int AM_SMOOTH = 2;
    public static final int JPATCH_C0 = 3;
    public static final int JPATCH_C1 = 5;
    public static final int JPATCH_G1 = 4;
    public static final float[] HOOKPOS = new float[]{0.25f, 0.5f, 0.75f};
    private static final float[] HOOK_B0 = new float[]{0.421875f, 0.125f, 0.015625f};
    private static final float[] HOOK_B1 = new float[]{0.421875f, 0.375f, 0.140625f};
    private static final float[] HOOK_B2 = new float[]{0.140625f, 0.375f, 0.421875f};
    private static final float[] HOOK_B3 = new float[]{0.015625f, 0.125f, 0.421875f};
    private static HashMap mapCp;
    private static int iDefaultMode;
    private static float fDefaultMagnitude;
    private static final float DEG2RAD = (float)Math.PI / 180;
    private static int iSequence;
    private int iNumber;
    private Point3f p3Position;
    private boolean bLoop;
    private boolean bTangentsValid;
    private int iMode;
    private ControlPoint cpNext;
    private ControlPoint cpPrev;
    private ControlPoint cpNextAttached;
    private ControlPoint cpPrevAttached;
    private ControlPoint cpChildHook;
    private ControlPoint cpParentHook;
    private float fHookPos;
    private Curve curve;
    private float fInMagnitude;
    private float fOutMagnitude;
    private Point3f p3InTangent;
    private Point3f p3OutTangent;
    private Point3f p3RefPosition;
    private Point3f p3RefInTangent;
    private Point3f p3RefOutTangent;
    private boolean bHidden;

    public int compareTo(Object object) {
        return this.hashCode() - object.hashCode();
    }

    public static void setDefaultMode(int n) {
        iDefaultMode = n;
    }

    public static void setMap(HashMap hashMap) {
        mapCp = hashMap;
    }

    public static void setDefaultMagnitude(float f) {
        fDefaultMagnitude = f;
    }

    public int number() {
        return this.iNumber;
    }

    public void setReference() {
        this.p3RefPosition.set(this.getPosition());
        if (this.cpPrev != null) {
            this.p3RefInTangent.set(this.getInTangent());
        }
        if (this.cpNext != null) {
            this.p3RefOutTangent.set(this.getOutTangent());
        }
    }

    public Point3f getRefPosition() {
        return this.p3RefPosition;
    }

    public Point3f getRefInTangent() {
        return this.p3RefInTangent;
    }

    public Point3f getRefOutTangent() {
        return this.p3RefOutTangent;
    }

    public ControlPoint createClone() {
        ControlPoint controlPoint = new ControlPoint();
        controlPoint.cpNext = this.cpNext;
        controlPoint.cpPrev = this.cpPrev;
        controlPoint.cpNextAttached = this.cpNextAttached;
        controlPoint.cpPrevAttached = this.cpPrevAttached;
        controlPoint.cpParentHook = this.cpParentHook;
        controlPoint.cpChildHook = this.cpChildHook;
        controlPoint.curve = this.curve;
        return controlPoint;
    }

    public void cloneFrom(ControlPoint controlPoint) {
        this.cpNext = controlPoint.cpNext;
        this.cpPrev = controlPoint.cpPrev;
        this.cpNextAttached = controlPoint.cpNextAttached;
        this.cpPrevAttached = controlPoint.cpPrevAttached;
        this.cpParentHook = controlPoint.cpParentHook;
        this.cpChildHook = controlPoint.cpChildHook;
        this.curve = controlPoint.curve;
    }

    public void free() {
        this.cpNext = null;
        this.cpPrev = null;
        this.cpNextAttached = null;
        this.cpPrevAttached = null;
        this.cpParentHook = null;
        this.cpChildHook = null;
        this.curve = null;
    }

    public Point3f getHookPosition(int n) {
        if (this.cpNext != null) {
            Point3f point3f = this.getPosition();
            Point3f point3f2 = this.getOutTangent();
            Point3f point3f3 = this.cpNext.getInTangent();
            Point3f point3f4 = this.cpNext.getPosition();
            float f = point3f.x * HOOK_B0[n] + point3f2.x * HOOK_B1[n] + point3f3.x * HOOK_B2[n] + point3f4.x * HOOK_B3[n];
            float f2 = point3f.y * HOOK_B0[n] + point3f2.y * HOOK_B1[n] + point3f3.y * HOOK_B2[n] + point3f4.y * HOOK_B3[n];
            float f3 = point3f.z * HOOK_B0[n] + point3f2.z * HOOK_B1[n] + point3f3.z * HOOK_B2[n] + point3f4.z * HOOK_B3[n];
            return new Point3f(f, f2, f3);
        }
        return null;
    }

    public ControlPoint[] getStack() {
        int n = 0;
        ControlPoint[] controlPointArray = this.getHead();
        while (controlPointArray != null) {
            ++n;
            controlPointArray = controlPointArray.getPrevAttached();
        }
        controlPointArray = new ControlPoint[n];
        n = 0;
        ControlPoint controlPoint = this.getHead();
        while (controlPoint != null) {
            controlPointArray[n++] = controlPoint;
            controlPoint = controlPoint.getPrevAttached();
        }
        return controlPointArray;
    }

    public ControlPoint addHook(float f) {
        if (this.cpChildHook == null) {
            this.curve.getModel().addCurve(this.createEmptyHookCurve());
        }
        ControlPoint controlPoint = this.cpChildHook;
        while (controlPoint.cpNext != null && controlPoint.cpNext.fHookPos < f) {
            controlPoint = controlPoint.cpNext;
        }
        if (controlPoint.isEndHook()) {
            throw new JPatchException("can't add hook to " + this + " at position " + f);
        }
        ControlPoint controlPoint2 = new ControlPoint();
        controlPoint2.fHookPos = f;
        controlPoint2.appendTo(controlPoint);
        return controlPoint2;
    }

    public void hookTo(ControlPoint controlPoint, float f) {
        this.attachTo(controlPoint.addHook(f));
    }

    public boolean hasHookAt(float f) {
        ControlPoint controlPoint = this.cpChildHook;
        while (controlPoint != null) {
            if (controlPoint.fHookPos == f) {
                return true;
            }
            controlPoint = controlPoint.getNext();
        }
        return false;
    }

    public void appendTo(ControlPoint controlPoint) {
        ControlPoint controlPoint2 = controlPoint.getNext();
        if (controlPoint2 != null) {
            controlPoint2.setPrev(this);
        }
        controlPoint.setNext(this);
        this.setPrev(controlPoint);
        this.setNext(controlPoint2);
        this.curve = controlPoint.curve;
    }

    public void attachTo(ControlPoint controlPoint) {
        ControlPoint controlPoint2 = controlPoint.getTail();
        controlPoint2.cpPrevAttached = this;
        this.cpNextAttached = controlPoint2;
    }

    public ArrayList allNeighbors() {
        ArrayList arrayList = new ArrayList();
        ControlPoint controlPoint = this;
        while (controlPoint != null) {
            this.addNeighborsToList(arrayList, controlPoint);
            if (controlPoint.cpChildHook != null) {
                this.addNeighborsToList(arrayList, controlPoint.cpChildHook);
            }
            if (controlPoint.cpPrev != null && controlPoint.cpPrev.cpChildHook != null) {
                this.addNeighborsToList(arrayList, controlPoint.cpPrev.cpChildHook.getEnd());
            }
            controlPoint = controlPoint.cpPrevAttached;
        }
        if (this.cpParentHook != null) {
            this.addNeighborsToList(arrayList, this.cpParentHook.getHead());
        }
        return arrayList;
    }

    private final void addNeighborsToList(ArrayList arrayList, ControlPoint controlPoint) {
        ControlPoint[] controlPointArray;
        if (controlPoint.cpNext != null) {
            controlPointArray = new ControlPoint[]{controlPoint.cpNext.getHookHead(), controlPoint, controlPoint.cpNext};
            arrayList.add(controlPointArray);
        }
        if (controlPoint.cpPrev != null) {
            controlPointArray = new ControlPoint[]{controlPoint.cpPrev.getHookHead(), controlPoint, controlPoint.cpPrev};
            arrayList.add(controlPointArray);
        }
    }

    private final ControlPoint getHookHead() {
        if (this.cpNextAttached != null) {
            return this.cpNextAttached.getHookHead();
        }
        if (this.cpParentHook != null) {
            return this.cpParentHook.getHookHead();
        }
        return this;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public ControlPoint getChildHook() {
        return this.cpChildHook;
    }

    public ControlPoint getParentHook() {
        return this.cpParentHook;
    }

    public void setChildHook(ControlPoint controlPoint) {
        this.cpChildHook = controlPoint;
    }

    public void setParentHook(ControlPoint controlPoint) {
        this.cpParentHook = controlPoint;
    }

    public float getHookPos() {
        return this.fHookPos;
    }

    public void setHookPos(float f) {
        this.fHookPos = f;
    }

    public boolean isHidden() {
        return this.bHidden;
    }

    public void setHidden(boolean bl) {
        this.bHidden = bl;
    }

    public Curve getHookCurve() {
        return this.getStart().cpParentHook != null ? this.getStart().cpParentHook.curve : this.curve;
    }

    public ControlPoint getNextAttached() {
        return this.cpNextAttached;
    }

    public ControlPoint getPrevAttached() {
        return this.cpPrevAttached;
    }

    public int getCurveLength() {
        int n = 0;
        ControlPoint controlPoint = this.getEnd();
        while (controlPoint != null) {
            ++n;
            controlPoint = controlPoint.getPrevCheckLoop();
        }
        return n;
    }

    public ControlPoint getEnd() {
        return this.getNextCheckLoop() != null ? this.cpNext.getEnd() : this;
    }

    public ControlPoint getHead() {
        return this.cpNextAttached != null ? this.cpNextAttached.getHead() : this;
    }

    public Point3f getInTangent() {
        if (this.cpPrev == null) {
            return null;
        }
        if (this.isTargetHook()) {
            Vector3f vector3f = new Vector3f(this.cpPrev.getPosition());
            vector3f.sub(this.getPosition());
            Vector3f vector3f2 = this.getTargetHookTangent(vector3f);
            vector3f2.normalize();
            vector3f2.scale(vector3f.length() * this.fInMagnitude / (float)3);
            Point3f point3f = new Point3f(this.getPosition());
            point3f.add(vector3f2);
            return point3f;
        }
        if (this.isHook()) {
            Point3f[] point3fArray = Bezier.deCasteljau(this.getStart().cpParentHook.getPosition(), this.getStart().cpParentHook.getOutTangent(), this.getEnd().cpParentHook.getInTangent(), this.getEnd().cpParentHook.getPosition(), this.fHookPos);
            Point3f[] point3fArray2 = Bezier.deCasteljau(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], this.cpPrev.fHookPos);
            return point3fArray2[5];
        }
        if (!this.bTangentsValid) {
            this.computeTangents();
        }
        return this.p3InTangent;
    }

    public Point3f getOutTangent() {
        if (this.cpNext == null) {
            return null;
        }
        if (this.isTargetHook()) {
            Vector3f vector3f = new Vector3f(this.cpNext.getPosition());
            vector3f.sub(this.getPosition());
            Vector3f vector3f2 = this.getTargetHookTangent(vector3f);
            vector3f2.normalize();
            vector3f2.scale(vector3f.length() * this.fOutMagnitude / (float)3);
            Point3f point3f = new Point3f(this.getPosition());
            point3f.add(vector3f2);
            return point3f;
        }
        if (this.isHook()) {
            Point3f[] point3fArray = Bezier.deCasteljau(this.getStart().cpParentHook.getPosition(), this.getStart().cpParentHook.getOutTangent(), this.getEnd().cpParentHook.getInTangent(), this.getEnd().cpParentHook.getPosition(), this.fHookPos);
            float f = (this.cpNext.fHookPos - this.fHookPos) / this.cpNext.fHookPos;
            Point3f[] point3fArray2 = Bezier.deCasteljau(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], this.cpNext.fHookPos);
            return point3fArray2[1];
        }
        if (!this.bTangentsValid) {
            this.computeTangents();
        }
        return this.p3OutTangent;
    }

    public ControlPoint getLooseEnd() {
        ControlPoint controlPoint = this.getHead();
        while (controlPoint != null && !controlPoint.isStart() && !controlPoint.isEnd()) {
            controlPoint = controlPoint.cpPrevAttached;
        }
        return controlPoint;
    }

    public boolean getLoop() {
        return this.bLoop;
    }

    public ControlPoint getNext() {
        return this.cpNext;
    }

    public ControlPoint getNextCheckLoop() {
        return this.bLoop ? null : this.cpNext;
    }

    public ControlPoint getNextCheckNextLoop() {
        return this.cpNext != null && this.cpNext.bLoop ? null : this.cpNext;
    }

    public Point3f getPosition() {
        if (this.isTargetHook()) {
            return this.cpNextAttached.getPosition();
        }
        if (this.isHook()) {
            return Bezier.evaluate(this.getStart().cpParentHook.getPosition(), this.getStart().cpParentHook.getOutTangent(), this.getEnd().cpParentHook.getInTangent(), this.getEnd().cpParentHook.getPosition(), this.fHookPos);
        }
        if (this.cpParentHook != null) {
            return this.cpParentHook.getPosition();
        }
        if (this.isHead()) {
            return this.p3Position;
        }
        return this.getHead().getPosition();
    }

    public ControlPoint getPrev() {
        return this.cpPrev;
    }

    public ControlPoint getPrevCheckLoop() {
        return this.bLoop ? null : this.cpPrev;
    }

    public ControlPoint getStart() {
        return this.getPrevCheckLoop() != null ? this.cpPrev.getStart() : this;
    }

    public ControlPoint getTail() {
        return this.cpPrevAttached != null ? this.cpPrevAttached.getTail() : this;
    }

    public boolean hasAttached() {
        boolean bl = false;
        if (this.cpPrevAttached != null) {
            bl = true;
        }
        return bl;
    }

    public String info() {
        return this.p3Position + "\tthis:" + this + "\tnext:" + this.cpNext + "\tprev:" + this.cpPrev + "\tup  :" + this.cpNextAttached + "\tdown:" + this.cpPrevAttached + "\tpar :" + this.cpParentHook + "\tchld:" + this.cpChildHook + "\thp:" + this.fHookPos;
    }

    public boolean isEnd() {
        boolean bl = false;
        if (this.getNext() == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isCenter() {
        boolean bl = false;
        if (this.cpNext != null && this.cpPrev != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isEndHook() {
        boolean bl = false;
        if (this.isHook() && this.fHookPos == 1.0f) {
            bl = true;
        }
        return bl;
    }

    public boolean isChildHook() {
        boolean bl = false;
        if (this.cpParentHook != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isHead() {
        boolean bl = false;
        if (this.cpNextAttached == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isHook() {
        boolean bl = false;
        if (this.fHookPos > -1.0f) {
            bl = true;
        }
        return bl;
    }

    public boolean isStart() {
        boolean bl = false;
        if (this.getPrev() == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isSingle() {
        boolean bl = false;
        if (this.cpNextAttached == null && this.cpPrevAttached == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isMulti() {
        boolean bl = false;
        if (this.cpPrevAttached != null && this.cpPrevAttached.cpPrevAttached != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isStartHook() {
        boolean bl = false;
        if (this.isHook() && this.fHookPos == 0.0f) {
            bl = true;
        }
        return bl;
    }

    public boolean isTargetHook() {
        boolean bl = false;
        if (this.cpNextAttached != null && this.cpNextAttached.isHook()) {
            bl = true;
        }
        return bl;
    }

    public void setMagnitude(float f) {
        this.fInMagnitude = f;
        this.fOutMagnitude = f;
    }

    public void setCurve(Curve curve) {
        this.curve = curve;
    }

    public void setLoop(boolean bl) {
        this.bLoop = bl;
    }

    public void setMode(int n) {
        this.iMode = n;
    }

    public int getMode() {
        return this.iMode;
    }

    public void setNext(ControlPoint controlPoint) {
        this.cpNext = controlPoint;
        this.setTangentsValid(false);
    }

    public void setNextAttached(ControlPoint controlPoint) {
        this.cpNextAttached = controlPoint;
        this.invalidateTangents();
    }

    public void setPosition(Point3f point3f) {
        if (!this.isHead()) {
            throw new IllegalStateException("attempted to set potsition on attached point");
        }
        this.p3Position.set(point3f);
        this.invalidateTangents();
    }

    public void setPosition(float f, float f2, float f3) {
        if (!this.isHead()) {
            throw new IllegalStateException("attempted to set potsition on attached point");
        }
        this.p3Position.set(f, f2, f3);
        this.invalidateTangents();
    }

    public void setPrev(ControlPoint controlPoint) {
        this.cpPrev = controlPoint;
        this.setTangentsValid(false);
    }

    public void setPrevAttached(ControlPoint controlPoint) {
        this.cpPrevAttached = controlPoint;
    }

    public void setTangentsValid(boolean bl) {
        this.bTangentsValid = bl;
    }

    public String toString() {
        return String.valueOf(this.iNumber);
    }

    private final void computePeakTangents() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.cpPrev != null) {
            this.p3InTangent.interpolate(this.getPosition(), this.cpPrev.getPosition(), this.fInMagnitude / (float)3);
        }
        if (this.cpNext != null) {
            this.p3OutTangent.interpolate(this.getPosition(), this.cpNext.getPosition(), this.fOutMagnitude / (float)3);
        }
    }

    private final void computeSPatchRoundTangents() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.cpPrev != null) {
            f = this.cpPrev.getPosition().distance(this.getPosition());
        }
        if (this.cpNext != null) {
            f2 = this.cpNext.getPosition().distance(this.getPosition());
        }
        Vector3f vector3f = this.getNormalizedTangent();
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f.scale(this.fInMagnitude * f / (float)3);
        vector3f2.scale(this.fOutMagnitude * f2 / (float)3);
        this.p3InTangent.set(this.getPosition());
        this.p3OutTangent.set(this.getPosition());
        this.p3InTangent.sub(vector3f);
        this.p3OutTangent.add(vector3f2);
    }

    private final void computeG1Tangents() {
        Vector3f vector3f = new Vector3f();
        if (this.cpPrev != null && this.cpNext != null) {
            Point3f point3f = new Point3f(this.cpPrev.getPosition());
            Point3f point3f2 = new Point3f(this.cpNext.getPosition());
            Point3f point3f3 = new Point3f(this.getPosition());
            float f = point3f3.distance(point3f);
            float f2 = point3f3.distance(point3f2);
            Point3f point3f4 = new Point3f(point3f3);
            point3f4.sub(point3f);
            float f3 = f == 0.0f ? 0.0f : f2 / f / (float)3;
            point3f4.scaleAdd(f3, point3f3);
            Point3f point3f5 = new Point3f(point3f3);
            point3f5.sub(point3f2);
            f3 = f2 == 0.0f ? 0.0f : f / f2 / (float)3;
            point3f5.scaleAdd(f3, point3f3);
            float f4 = (float)Math.sqrt(f);
            float f5 = (float)Math.sqrt(f2);
            float f6 = f4 != 0.0f ? f4 / (f4 + f5) : 0.0f;
            float f7 = 1.0f - f6;
            float f8 = f7 * f7;
            float f9 = 2.0f * f7 * f6;
            float f10 = f6 * f6;
            float f11 = point3f.x * f8 + point3f5.x * f9 + point3f4.x * f10;
            float f12 = point3f.y * f8 + point3f5.y * f9 + point3f4.y * f10;
            float f13 = point3f.z * f8 + point3f5.z * f9 + point3f4.z * f10;
            vector3f.set(f11, f12, f13);
            vector3f.sub(point3f3);
            vector3f.scale(this.fInMagnitude);
            this.p3InTangent.add(point3f3, vector3f);
            f11 = point3f5.x * f8 + point3f4.x * f9 + point3f2.x * f10;
            f12 = point3f5.y * f8 + point3f4.y * f9 + point3f2.y * f10;
            f13 = point3f5.z * f8 + point3f4.z * f9 + point3f2.z * f10;
            vector3f.set(f11, f12, f13);
            vector3f.sub(point3f3);
            vector3f.scale(this.fOutMagnitude);
            this.p3OutTangent.add(point3f3, vector3f);
        } else if (this.cpPrev == null) {
            if (this.cpNext != null && this.cpNext.cpNext != null) {
                Point3f point3f = new Point3f(this.getPosition());
                Point3f point3f6 = new Point3f(this.cpNext.cpNext.getPosition());
                Point3f point3f7 = new Point3f(this.cpNext.getPosition());
                float f = point3f7.distance(point3f);
                float f14 = point3f7.distance(point3f6);
                Point3f point3f8 = new Point3f(point3f7);
                point3f8.sub(point3f);
                float f15 = f == 0.0f ? 0.0f : f14 / f / (float)3;
                point3f8.scaleAdd(f15, point3f7);
                Point3f point3f9 = new Point3f(point3f7);
                point3f9.sub(point3f6);
                f15 = f14 == 0.0f ? 0.0f : f / f14 / (float)3;
                point3f9.scaleAdd(f15, point3f7);
                float f16 = (float)Math.sqrt(f);
                float f17 = (float)Math.sqrt(f14);
                float f18 = f16 / (f16 + f17);
                float f19 = 1.0f - f18;
                float f20 = f19 * f19;
                float f21 = 2.0f * f19 * f18;
                float f22 = f18 * f18;
                this.p3OutTangent.interpolate(point3f, point3f9, f18 * this.fOutMagnitude);
            } else {
                this.p3OutTangent.interpolate(this.getPosition(), this.cpNext.getPosition(), this.fOutMagnitude / (float)3);
            }
        } else if (this.cpPrev != null && this.cpPrev.cpPrev != null) {
            Point3f point3f = new Point3f(this.getPosition());
            Point3f point3f10 = new Point3f(this.cpPrev.cpPrev.getPosition());
            Point3f point3f11 = new Point3f(this.cpPrev.getPosition());
            float f = point3f11.distance(point3f);
            float f23 = point3f11.distance(point3f10);
            Point3f point3f12 = new Point3f(point3f11);
            point3f12.sub(point3f);
            float f24 = f == 0.0f ? 0.0f : f23 / f / (float)3;
            point3f12.scaleAdd(f24, point3f11);
            Point3f point3f13 = new Point3f(point3f11);
            point3f13.sub(point3f10);
            f24 = f23 == 0.0f ? 0.0f : f / f23 / (float)3;
            point3f13.scaleAdd(f24, point3f11);
            float f25 = (float)Math.sqrt(f);
            float f26 = (float)Math.sqrt(f23);
            float f27 = f25 / (f25 + f26);
            float f28 = 1.0f - f27;
            float f29 = f28 * f28;
            float f30 = 2.0f * f28 * f27;
            float f31 = f27 * f27;
            this.p3InTangent.interpolate(point3f, point3f13, f27 * this.fInMagnitude);
        } else {
            this.p3InTangent.interpolate(this.getPosition(), this.cpPrev.getPosition(), this.fInMagnitude / (float)3);
        }
    }

    public void setInMagnitude(float f) {
        this.fInMagnitude = f;
    }

    public float getInMagnitude() {
        return this.fInMagnitude;
    }

    public void setOutMagnitude(float f) {
        this.fOutMagnitude = f;
    }

    public float getOutMagnitude() {
        return this.fOutMagnitude;
    }

    private final void computeTangents() {
        switch (this.iMode) {
            case 0: {
                this.computePeakTangents();
                break;
            }
            case 1: {
                this.computeSPatchRoundTangents();
                break;
            }
            default: {
                this.computeG1Tangents();
            }
        }
        this.bTangentsValid = true;
    }

    public Curve createEmptyHookCurve() {
        if (this.cpNext == null) {
            throw new JPatchException("Can't add hook to end of curve  on " + this);
        }
        ControlPoint controlPoint = new ControlPoint();
        ControlPoint controlPoint2 = new ControlPoint();
        controlPoint.cpParentHook = this;
        controlPoint2.cpParentHook = this.cpNext;
        controlPoint.fHookPos = 0.0f;
        controlPoint2.fHookPos = 1.0f;
        this.cpChildHook = controlPoint;
        controlPoint2.appendTo(controlPoint);
        Curve curve = new Curve(controlPoint);
        curve.validate();
        return curve;
    }

    private final Vector3f getNormalizedTangent() {
        Vector3f vector3f = this.getTangent();
        if (vector3f.lengthSquared() > 0.0f) {
            vector3f.normalize();
        }
        return vector3f;
    }

    private final Vector3f getTangent() {
        Point3f point3f = this.cpNext != null ? this.cpNext.getPosition() : this.getPosition();
        Point3f point3f2 = this.cpPrev != null ? this.cpPrev.getPosition() : this.getPosition();
        Vector3f vector3f = new Vector3f(point3f);
        vector3f.sub(point3f2);
        return vector3f;
    }

    private final Vector3f getTargetHookTangent(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(vector3f);
        Vector3f vector3f3 = new Vector3f();
        this.computeTargetHookBorderTangents(vector3f, vector3f2, vector3f3);
        vector3f2.interpolate(vector3f3, this.getHead().fHookPos);
        return vector3f2;
    }

    public void computeTargetHookBorderTangents(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = new Vector3f(vector3f);
        float f = 0.0f;
        ControlPoint controlPoint = this.getHead().getStart().cpParentHook.getHead();
        ControlPoint controlPoint2 = this.getHead().getEnd().cpParentHook.getHead();
        Point3f point3f = controlPoint.getPosition();
        Point3f point3f2 = controlPoint2.getPosition();
        float f2 = (float)Math.PI;
        Curve curve = this.getHead().getStart().cpParentHook.curve;
        while (controlPoint != null) {
            if (controlPoint.curve != curve) {
                if (controlPoint.cpNext != null) {
                    vector3f4.set(controlPoint.getOutTangent());
                    vector3f4.sub(point3f);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f2.set(vector3f4);
                    }
                }
                if (controlPoint.cpPrev != null) {
                    vector3f4.set(controlPoint.getInTangent());
                    vector3f4.sub(point3f);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f2.set(vector3f4);
                    }
                }
            }
            controlPoint = controlPoint.cpPrevAttached;
        }
        f2 = (float)Math.PI;
        while (controlPoint2 != null) {
            if (controlPoint2.curve != curve) {
                if (controlPoint2.cpNext != null) {
                    vector3f4.set(controlPoint2.getOutTangent());
                    vector3f4.sub(point3f2);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f3.set(vector3f4);
                    }
                }
                if (controlPoint2.cpPrev != null) {
                    vector3f4.set(controlPoint2.getInTangent());
                    vector3f4.sub(point3f2);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f3.set(vector3f4);
                    }
                }
            }
            controlPoint2 = controlPoint2.cpPrevAttached;
        }
    }

    public void computeTargetHookReferenceBorderTangents(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = new Vector3f(vector3f);
        float f = 0.0f;
        ControlPoint controlPoint = this.getHead().getStart().cpParentHook.getHead();
        ControlPoint controlPoint2 = this.getHead().getEnd().cpParentHook.getHead();
        Point3f point3f = controlPoint.getRefPosition();
        Point3f point3f2 = controlPoint2.getRefPosition();
        float f2 = (float)Math.PI;
        Curve curve = this.getHead().getStart().cpParentHook.curve;
        while (controlPoint != null) {
            if (controlPoint.curve != curve) {
                if (controlPoint.cpNext != null) {
                    vector3f4.set(controlPoint.getRefOutTangent());
                    vector3f4.sub(point3f);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f2.set(vector3f4);
                    }
                }
                if (controlPoint.cpPrev != null) {
                    vector3f4.set(controlPoint.getRefInTangent());
                    vector3f4.sub(point3f);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f2.set(vector3f4);
                    }
                }
            }
            controlPoint = controlPoint.cpPrevAttached;
        }
        f2 = (float)Math.PI;
        while (controlPoint2 != null) {
            if (controlPoint2.curve != curve) {
                if (controlPoint2.cpNext != null) {
                    vector3f4.set(controlPoint2.getRefOutTangent());
                    vector3f4.sub(point3f2);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f3.set(vector3f4);
                    }
                }
                if (controlPoint2.cpPrev != null) {
                    vector3f4.set(controlPoint2.getRefInTangent());
                    vector3f4.sub(point3f2);
                    f = vector3f4.angle(vector3f);
                    if (f < f2) {
                        f2 = f;
                        vector3f3.set(vector3f4);
                    }
                }
            }
            controlPoint2 = controlPoint2.cpPrevAttached;
        }
    }

    public void invalidateTangents() {
        this.bTangentsValid = false;
        if (this.cpNext != null) {
            this.cpNext.bTangentsValid = false;
            if (this.cpNext.cpNext != null) {
                this.cpNext.cpNext.bTangentsValid = false;
            }
        }
        if (this.cpPrev != null) {
            this.cpPrev.bTangentsValid = false;
            if (this.cpPrev.cpPrev != null) {
                this.cpPrev.cpPrev.bTangentsValid = false;
            }
        }
        if (this.cpPrevAttached != null) {
            this.cpPrevAttached.invalidateTangents();
        }
    }

    public int getXmlNumber() {
        Integer n = (Integer)mapCp.get(this);
        return n == null ? -1 : n;
    }

    public StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.lineBreak();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(stringBuffer).append("<cp");
        if (this.cpNextAttached != null) {
            int n2 = (Integer)mapCp.get(this.cpNextAttached);
            stringBuffer3.append(" attach=").append(XMLutils.quote(n2));
        } else if (this.cpParentHook != null) {
            int n3 = (Integer)mapCp.get(this.cpParentHook);
            stringBuffer3.append(" hook=").append(XMLutils.quote(n3));
            stringBuffer3.append(" hookpos=").append(XMLutils.quote(this.fHookPos));
        } else if (this.fHookPos > 0.0f && this.fHookPos < 1.0f) {
            stringBuffer3.append(" hookpos=").append(XMLutils.quote(this.fHookPos));
        } else {
            stringBuffer3.append(" x=").append(XMLutils.quote(this.p3Position.x));
            stringBuffer3.append(" y=").append(XMLutils.quote(this.p3Position.y));
            stringBuffer3.append(" z=").append(XMLutils.quote(this.p3Position.z));
        }
        if (this.iMode == 0) {
            stringBuffer3.append(" mode=\"peak\"");
        } else if (this.iMode == 1) {
            stringBuffer3.append(" mode=\"spatch\"");
        }
        if (this.fInMagnitude != fDefaultMagnitude) {
            stringBuffer3.append(" magnitude=").append(XMLutils.quote(this.fInMagnitude));
        }
        stringBuffer3.append("/>").append(stringBuffer2);
        return stringBuffer3;
    }

    public ControlPoint trueHead() {
        return this.getParentHook() == null ? this.getHead() : this.getParentHook().getHead();
    }

    public ControlPoint trueCp() {
        return this.cpParentHook != null ? this.cpParentHook : this;
    }

    private final /* synthetic */ void this() {
        this.p3Position = new Point3f();
        this.bLoop = false;
        this.bTangentsValid = false;
        this.iMode = iDefaultMode;
        this.fHookPos = -1.0f;
        this.fInMagnitude = fDefaultMagnitude;
        this.fOutMagnitude = fDefaultMagnitude;
        this.p3InTangent = new Point3f();
        this.p3OutTangent = new Point3f();
        this.p3RefPosition = new Point3f();
        this.p3RefInTangent = new Point3f();
        this.p3RefOutTangent = new Point3f();
        this.bHidden = false;
    }

    public ControlPoint() {
        this.this();
        this.iNumber = iSequence++;
    }

    public ControlPoint(ControlPoint controlPoint) {
        this(controlPoint.getHead().p3Position);
        this.iMode = controlPoint.iMode;
        this.fInMagnitude = controlPoint.fInMagnitude;
        this.fOutMagnitude = controlPoint.fOutMagnitude;
    }

    public ControlPoint(Point3f point3f) {
        this();
        this.p3Position.set(point3f);
    }

    public ControlPoint(float f, float f2, float f3) {
        this();
        this.p3Position.set(f, f2, f3);
    }

    static {
        iDefaultMode = 4;
        fDefaultMagnitude = 1.0f;
        iSequence = 0;
    }
}

