/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import java.awt.Color;
import jpatch.auxilary.XMLutils;

public class MaterialProperties {
    private static final float RED = 1.0f;
    private static final float GREEN = 0.0f;
    private static final float BLUE = 0.0f;
    private static final float TRANSMIT = 0.0f;
    private static final float FILTER = 0.0f;
    private static final float AMBIENT = 0.1f;
    private static final float DIFFUSE = 0.9f;
    private static final float BRILLIANCE = 1.0f;
    private static final float SPECULAR = 1.0f;
    private static final float ROUGHNESS = 0.01f;
    private static final float METALLIC = 0.0f;
    private static final float REFLECTION_MIN = 0.0f;
    private static final float REFLECTION_MAX = 0.0f;
    private static final float REFLECTION_FALLOFF = 1.0f;
    private static final float REFRACTION = 1.0f;
    private static final boolean CONSERVE_ENERGY = true;
    public float red;
    public float green;
    public float blue;
    public float transmit;
    public float filter;
    public float ambient;
    public float diffuse;
    public float brilliance;
    public float specular;
    public float roughness;
    public float metallic;
    public float reflectionMin;
    public float reflectionMax;
    public float reflectionFalloff;
    public float refraction;
    public boolean conserveEnergy;

    public int getRGB() {
        return 0xFF000000 | (int)(this.red * 192.0f) << 16 | (int)(this.green * 192.0f) << 8 | (int)(this.blue * 192.0f);
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void reset() {
        this.red = 1.0f;
        this.green = 0.0f;
        this.blue = 0.0f;
        this.transmit = 0.0f;
        this.filter = 0.0f;
        this.ambient = 0.1f;
        this.diffuse = 0.9f;
        this.brilliance = 1.0f;
        this.specular = 1.0f;
        this.roughness = 0.01f;
        this.metallic = 0.0f;
        this.reflectionMin = 0.0f;
        this.reflectionMax = 0.0f;
        this.reflectionFalloff = 1.0f;
        this.refraction = 1.0f;
        this.conserveEnergy = true;
    }

    public void set(MaterialProperties materialProperties) {
        this.red = materialProperties.red;
        this.green = materialProperties.green;
        this.blue = materialProperties.blue;
        this.transmit = materialProperties.transmit;
        this.filter = materialProperties.filter;
        this.ambient = materialProperties.ambient;
        this.diffuse = materialProperties.diffuse;
        this.brilliance = materialProperties.brilliance;
        this.specular = materialProperties.specular;
        this.roughness = materialProperties.roughness;
        this.metallic = materialProperties.metallic;
        this.reflectionMin = materialProperties.reflectionMin;
        this.reflectionMax = materialProperties.reflectionMax;
        this.reflectionFalloff = materialProperties.reflectionFalloff;
        this.refraction = materialProperties.refraction;
        this.conserveEnergy = materialProperties.conserveEnergy;
    }

    public boolean isOpaque() {
        boolean bl = false;
        if (this.transmit == 0.0f && this.filter == 0.0f) {
            bl = true;
        }
        return bl;
    }

    public float opacityRed() {
        return 1.0f - this.transmit - this.red * this.filter;
    }

    public float opacityGreen() {
        return 1.0f - this.transmit - this.green * this.filter;
    }

    public float opacityBlue() {
        return 1.0f - this.transmit - this.blue * this.filter;
    }

    public String opacity() {
        return "" + this.opacityRed() + ' ' + this.opacityGreen() + ' ' + this.opacityBlue();
    }

    public float reflection() {
        return 0.5f * this.reflectionMin + 0.5f * this.reflectionMax;
    }

    public StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.lineBreak();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = this.colorString();
        StringBuffer stringBuffer5 = this.finishString();
        StringBuffer stringBuffer6 = this.reflectionString();
        StringBuffer stringBuffer7 = this.refractionString();
        stringBuffer3.append(stringBuffer).append(stringBuffer4).append(stringBuffer2);
        if (stringBuffer5 != null) {
            stringBuffer3.append(stringBuffer).append(stringBuffer5).append(stringBuffer2);
        }
        if (stringBuffer6 != null) {
            stringBuffer3.append(stringBuffer).append(stringBuffer6).append(stringBuffer2);
        }
        if (stringBuffer7 != null) {
            stringBuffer3.append(stringBuffer).append(stringBuffer7).append(stringBuffer2);
        }
        return stringBuffer3;
    }

    private final StringBuffer colorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<color r=").append(XMLutils.quote(this.red)).append(" g=").append(XMLutils.quote(this.green)).append(" b=").append(XMLutils.quote(this.blue));
        if (this.transmit != 0.0f) {
            stringBuffer.append(" transmit=").append(XMLutils.quote(this.transmit));
        }
        if (this.filter != 0.0f) {
            stringBuffer.append(" filter=").append(XMLutils.quote(this.filter));
        }
        stringBuffer.append("/>");
        return stringBuffer;
    }

    private final StringBuffer finishString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("<finish");
        if (this.ambient != 0.1f) {
            stringBuffer.append(" ambient=").append(XMLutils.quote(this.ambient));
            bl = false;
        }
        if (this.diffuse != 0.9f) {
            stringBuffer.append(" diffuse=").append(XMLutils.quote(this.diffuse));
            bl = false;
        }
        if (this.brilliance != 1.0f) {
            stringBuffer.append(" brilliance=").append(XMLutils.quote(this.brilliance));
            bl = false;
        }
        if (this.specular != 1.0f) {
            stringBuffer.append(" specular=").append(XMLutils.quote(this.specular));
            bl = false;
        }
        if (this.roughness != 0.01f) {
            stringBuffer.append(" roughness=").append(XMLutils.quote(this.roughness));
            bl = false;
        }
        if (this.metallic != 0.0f) {
            stringBuffer.append(" metallic=").append(XMLutils.quote(this.metallic));
            bl = false;
        }
        stringBuffer.append("/>");
        return bl ? null : stringBuffer;
    }

    private final StringBuffer reflectionString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("<reflection");
        if (this.reflectionMin == this.reflectionMax && this.reflectionMin != 0.0f) {
            stringBuffer.append(" amount=").append(XMLutils.quote(this.reflectionMin));
            bl = false;
        } else {
            if (this.reflectionMin != 0.0f) {
                stringBuffer.append(" min=").append(XMLutils.quote(this.reflectionMin));
                bl = false;
            }
            if (this.reflectionMax != 0.0f) {
                stringBuffer.append(" max=").append(XMLutils.quote(this.reflectionMax));
                bl = false;
            }
            if (this.reflectionFalloff != 1.0f) {
                stringBuffer.append(" falloff=").append(XMLutils.quote(this.reflectionFalloff));
                bl = false;
            }
        }
        stringBuffer.append("/>");
        return bl ? null : stringBuffer;
    }

    private final StringBuffer refractionString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        stringBuffer.append("<refraction");
        if (this.refraction != 1.0f) {
            stringBuffer.append(" index=").append(XMLutils.quote(this.refraction));
            bl = false;
        }
        stringBuffer.append("/>");
        return bl ? null : stringBuffer;
    }

    public MaterialProperties() {
        this.reset();
    }

    public MaterialProperties(float f, float f2, float f3) {
        this.reset();
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    public MaterialProperties(MaterialProperties materialProperties) {
        this.set(materialProperties);
    }
}

