/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jpatch.auxilary.XMLutils;
import jpatch.entity.Morph;
import jpatch.entity.MotionKey2;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class MotionCurve2 {
    public static final InterpolationMethod LINEAR = new InterpolationMethod("linear");
    public static final InterpolationMethod CUBIC = new InterpolationMethod("cubic");
    InterpolationMethod interpolationMethod;
    String name;
    ArrayList list;

    public static Float createMorphCurve(Morph morph) {
        Float float_ = new Float();
        float_.name = morph.getName();
        float_.fMin = morph.getMin();
        float_.fMax = morph.getMax();
        return float_;
    }

    public static Float createMorphCurve(Morph morph, MotionKey2.Float float_) {
        Float float_2 = MotionCurve2.createMorphCurve(morph);
        float_2.addKey(float_);
        return float_2;
    }

    public static Float createScaleCurve() {
        Float float_ = new Float();
        float_.name = "Scale";
        float_.fMin = -10.0f;
        float_.fMax = 10.0f;
        return float_;
    }

    public static Float createScaleCurve(MotionKey2.Float float_) {
        Float float_2 = MotionCurve2.createScaleCurve();
        float_2.addKey(float_);
        return float_2;
    }

    public static Float createSizeCurve() {
        Float float_ = new Float();
        float_.name = "Size";
        float_.fMin = 0.0f;
        float_.fMax = 100.0f;
        return float_;
    }

    public static Float createSizeCurve(MotionKey2.Float float_) {
        Float float_2 = MotionCurve2.createSizeCurve();
        float_2.addKey(float_);
        return float_2;
    }

    public static Float createIntensityCurve() {
        Float float_ = new Float();
        float_.name = "Intensity";
        float_.fMin = 0.0f;
        float_.fMax = 100.0f;
        return float_;
    }

    public static Float createIntensityCurve(MotionKey2.Float float_) {
        Float float_2 = MotionCurve2.createIntensityCurve();
        float_2.addKey(float_);
        return float_2;
    }

    public static Float createFocalLengthCurve() {
        Float float_ = new Float();
        float_.name = "Focal length";
        float_.fMin = 20.0f;
        float_.fMax = 500.0f;
        return float_;
    }

    public static Float createFocalLengthCurve(MotionKey2.Float float_) {
        Float float_2 = MotionCurve2.createFocalLengthCurve();
        float_2.addKey(float_);
        return float_2;
    }

    public static Point3d createPositionCurve() {
        Point3d point3d = new Point3d();
        point3d.name = "Position";
        return point3d;
    }

    public static Point3d createPositionCurve(MotionKey2.Point3d point3d) {
        Point3d point3d2 = MotionCurve2.createPositionCurve();
        point3d2.addKey(point3d);
        return point3d2;
    }

    public static Color3f createColorCurve() {
        Color3f color3f = new Color3f();
        color3f.name = "Color";
        return color3f;
    }

    public static Color3f createColorCurve(MotionKey2.Color3f color3f) {
        Color3f color3f2 = MotionCurve2.createColorCurve();
        color3f2.addKey(color3f);
        return color3f2;
    }

    public static Quat4f createOrientationCurve() {
        Quat4f quat4f = new Quat4f();
        quat4f.name = "Orientation";
        return quat4f;
    }

    public static Quat4f createOrientationCurve(MotionKey2.Quat4f quat4f) {
        Quat4f quat4f2 = MotionCurve2.createOrientationCurve();
        quat4f2.addKey(quat4f);
        return quat4f2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addKey(MotionKey2 motionKey2) {
        this.list.add(this.binarySearch(motionKey2.getPosition()), motionKey2);
    }

    public abstract MotionKey2 insertKeyAt(float var1);

    public void removeKey(MotionKey2 motionKey2) {
        if (this.list.size() > 1) {
            this.list.remove(motionKey2);
        }
    }

    public void moveKey(MotionKey2 motionKey2, float f) {
        this.list.remove(motionKey2);
        this.list.add(this.binarySearch(motionKey2.getPosition()), motionKey2);
    }

    public int getKeyCount() {
        return this.list.size();
    }

    public MotionKey2 getKey(int n) {
        return (MotionKey2)this.list.get(n);
    }

    public float getStart() {
        return ((MotionKey2)this.list.get(0)).getPosition();
    }

    public float getEnd() {
        return ((MotionKey2)this.list.get(this.list.size() - 1)).getPosition();
    }

    public MotionKey2 getKeyAt(float f) {
        if (f == ((MotionKey2)this.list.get(this.list.size() - 1)).getPosition()) {
            return (MotionKey2)this.list.get(this.list.size() - 1);
        }
        int n = this.binarySearch(f) - 1;
        if (n >= 0) {
            MotionKey2 motionKey2 = (MotionKey2)this.list.get(n);
            if (motionKey2 != null && motionKey2.getPosition() == f) {
                return motionKey2;
            }
            return null;
        }
        return null;
    }

    public void xml(StringBuffer stringBuffer, int n, String string) {
        StringBuffer stringBuffer2 = XMLutils.indent(n);
        StringBuffer stringBuffer3 = XMLutils.indent(n + 1);
        stringBuffer.append(stringBuffer2).append("<motioncurve " + string + " interpolation=\"" + this.interpolationMethod.toString() + "\">\n");
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(stringBuffer3).append(iterator.next().toString()).append(XMLutils.lineBreak());
        }
        stringBuffer.append(stringBuffer2).append("</motioncurve>").append(XMLutils.lineBreak());
    }

    public MotionKey2 getPrevKey(float f) {
        int n = this.binarySearch(f) - 1;
        if (n >= 0) {
            MotionKey2 motionKey2 = (MotionKey2)this.list.get(n);
            if (motionKey2.getPosition() < f) {
                return motionKey2;
            }
            if (n == 0) {
                return motionKey2;
            }
            return (MotionKey2)this.list.get(n - 1);
        }
        return (MotionKey2)this.list.get(0);
    }

    public MotionKey2 getNextKey(float f) {
        int n = this.binarySearch(f) - 1;
        if (n < this.list.size() && n >= 0) {
            MotionKey2 motionKey2 = (MotionKey2)this.list.get(n);
            if (motionKey2.getPosition() > f) {
                return motionKey2;
            }
            if (n == this.list.size() - 1) {
                return motionKey2;
            }
            return (MotionKey2)this.list.get(n + 1);
        }
        return (MotionKey2)this.list.get(this.list.size() - 1);
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
    }

    int binarySearch(float f) {
        if (this.list.size() == 0) {
            return 0;
        }
        if (f < ((MotionKey2)this.list.get(0)).getPosition()) {
            return 0;
        }
        if (f > ((MotionKey2)this.list.get(this.list.size() - 1)).getPosition()) {
            return this.list.size();
        }
        int n = 0;
        int n2 = this.list.size() - 1;
        int n3 = n2 >> 1;
        while (n2 > n + 1) {
            if (((MotionKey2)this.list.get(n3)).getPosition() > f) {
                n2 = n3;
                n3 -= n3 - n >> 1;
                continue;
            }
            n = n3;
            n3 += n2 - n3 >> 1;
        }
        return n2;
    }

    Object[] getInterpolationKeysFor(float f) {
        int n = this.binarySearch(f) - 1;
        return new Object[]{n > 0 ? this.list.get(n - 1) : null, this.list.get(n), this.list.get(n + 1), n < this.list.size() - 2 ? this.list.get(n + 2) : null};
    }

    float cubicInterpolate(float f, float f2, float f3, float f4, float f5) {
        float f6 = f5 * f5;
        float f7 = f5 * f6;
        float f8 = 2.0f * f7 - (float)3 * f6 + 1.0f;
        float f9 = f7 - 2.0f * f6 + f5;
        float f10 = -2.0f * f7 + (float)3 * f6;
        float f11 = f7 - f6;
        return f8 * f + f9 * f2 + f10 * f3 + f11 * f4;
    }

    double cubicInterpolate(double d, double d2, double d3, double d4, float f) {
        float f2 = f * f;
        float f3 = f * f2;
        float f4 = 2.0f * f3 - (float)3 * f2 + 1.0f;
        float f5 = f3 - 2.0f * f2 + f;
        float f6 = -2.0f * f3 + (float)3 * f2;
        float f7 = f3 - f2;
        return (double)f4 * d + (double)f5 * d2 + (double)f6 * d3 + (double)f7 * d4;
    }

    private final /* synthetic */ void this() {
        this.interpolationMethod = CUBIC;
        this.name = "*";
        this.list = new ArrayList();
    }

    public MotionCurve2() {
        this.this();
    }

    public static class Float
    extends MotionCurve2 {
        float fMin;
        float fMax;

        public float getFloatAt(float f) {
            float f2;
            boolean bl = true;
            if (f <= this.getStart()) {
                return ((MotionKey2.Float)this.list.get(0)).getFloat();
            }
            if (f >= this.getEnd()) {
                return ((MotionKey2.Float)this.list.get(this.list.size() - 1)).getFloat();
            }
            Object[] objectArray = this.getInterpolationKeysFor(f);
            MotionKey2.Float float_ = (MotionKey2.Float)objectArray[0];
            MotionKey2.Float float_2 = (MotionKey2.Float)objectArray[1];
            MotionKey2.Float float_3 = (MotionKey2.Float)objectArray[2];
            MotionKey2.Float float_4 = (MotionKey2.Float)objectArray[3];
            float f3 = float_3.getPosition() - float_2.getPosition();
            float f4 = (f - float_2.getPosition()) / f3;
            float f5 = float_2.getFloat();
            float f6 = float_3.getFloat();
            if (this.interpolationMethod == LINEAR) {
                return f5 * (1.0f - f4) + f6 * f4;
            }
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (float_ != null) {
                f2 = float_.getFloat();
                f7 = bl && (f5 == f2 || f5 == f6 || f5 > f2 && f5 > f6 || f5 < f2 && f5 < f6) ? 0.0f : (f6 - f2) / (float_3.getPosition() - float_.getPosition()) * f3;
            }
            if (float_4 != null) {
                f2 = float_4.getFloat();
                f8 = bl && (f6 == f5 || f6 == f2 || f6 > f2 && f6 > f5 || f6 < f2 && f6 < f5) ? 0.0f : (f2 - f5) / (float_4.getPosition() - float_2.getPosition()) * f3;
            }
            return this.cubicInterpolate(f5, f7, f6, f8, f4);
        }

        public MotionKey2.Float setFloatAt(float f, float f2) {
            MotionKey2.Float float_ = (MotionKey2.Float)this.getKeyAt(f);
            if (float_ == null) {
                float_ = new MotionKey2.Float(f, f2);
                this.addKey(float_);
            } else {
                float_.setFloat(f2);
            }
            return float_;
        }

        public MotionKey2 insertKeyAt(float f) {
            if (this.getKeyAt(f) == null) {
                this.setFloatAt(f, this.getFloatAt(f));
            }
            return this.getKeyAt(f);
        }

        public float getMin() {
            return this.fMin;
        }

        public float getMax() {
            return this.fMax;
        }

        public void setRange(float f, float f2) {
            this.fMin = f;
            this.fMax = f2;
        }

        private Float() {
        }
    }

    public static class Point3d
    extends MotionCurve2 {
        public javax.vecmath.Point3d getPoint3dAt(float f) {
            if (f <= this.getStart()) {
                return ((MotionKey2.Point3d)this.list.get(0)).getPoint3d();
            }
            if (f >= this.getEnd()) {
                return ((MotionKey2.Point3d)this.list.get(this.list.size() - 1)).getPoint3d();
            }
            Object[] objectArray = this.getInterpolationKeysFor(f);
            MotionKey2.Point3d point3d = (MotionKey2.Point3d)objectArray[0];
            MotionKey2.Point3d point3d2 = (MotionKey2.Point3d)objectArray[1];
            MotionKey2.Point3d point3d3 = (MotionKey2.Point3d)objectArray[2];
            MotionKey2.Point3d point3d4 = (MotionKey2.Point3d)objectArray[3];
            float f2 = point3d3.getPosition() - point3d2.getPosition();
            float f3 = (f - point3d2.getPosition()) / f2;
            javax.vecmath.Point3d point3d5 = point3d2.getPoint3d();
            javax.vecmath.Point3d point3d6 = point3d3.getPoint3d();
            if (this.interpolationMethod == LINEAR) {
                javax.vecmath.Point3d point3d7 = new javax.vecmath.Point3d();
                point3d7.interpolate((Tuple3d)point3d5, (Tuple3d)point3d6, f3);
                return point3d7;
            }
            Vector3d vector3d = new Vector3d();
            if (point3d != null && !point3d.getPoint3d().equals(point3d2.getPoint3d()) && !point3d2.getPoint3d().equals(point3d3.getPoint3d())) {
                vector3d.sub(point3d6, point3d.getPoint3d());
                vector3d.scale(f2 / (point3d3.getPosition() - point3d.getPosition()));
            }
            Vector3d vector3d2 = new Vector3d();
            if (point3d4 != null && !point3d4.getPoint3d().equals(point3d3.getPoint3d()) && !point3d3.getPoint3d().equals(point3d2.getPoint3d())) {
                vector3d2.sub(point3d4.getPoint3d(), point3d5);
                vector3d2.scale(f2 / (point3d4.getPosition() - point3d2.getPosition()));
            }
            return new javax.vecmath.Point3d(this.cubicInterpolate(point3d5.x, vector3d.x, point3d6.x, vector3d2.x, f3), this.cubicInterpolate(point3d5.y, vector3d.y, point3d6.y, vector3d2.y, f3), this.cubicInterpolate(point3d5.z, vector3d.z, point3d6.z, vector3d2.z, f3));
        }

        public MotionKey2.Point3d setPoint3dAt(float f, javax.vecmath.Point3d point3d) {
            MotionKey2.Point3d point3d2 = (MotionKey2.Point3d)this.getKeyAt(f);
            if (point3d2 == null) {
                point3d2 = new MotionKey2.Point3d(f, point3d);
                this.addKey(point3d2);
            } else {
                point3d2.setPoint3d(point3d);
            }
            return point3d2;
        }

        public MotionKey2 insertKeyAt(float f) {
            if (this.getKeyAt(f) == null) {
                this.setPoint3dAt(f, this.getPoint3dAt(f));
            }
            return this.getKeyAt(f);
        }

        private Point3d() {
        }
    }

    public static class Color3f
    extends MotionCurve2 {
        public javax.vecmath.Color3f getColor3fAt(float f) {
            if (f <= this.getStart()) {
                return ((MotionKey2.Color3f)this.list.get(0)).getColor3f();
            }
            if (f >= this.getEnd()) {
                return ((MotionKey2.Color3f)this.list.get(this.list.size() - 1)).getColor3f();
            }
            Object[] objectArray = this.getInterpolationKeysFor(f);
            MotionKey2.Color3f color3f = (MotionKey2.Color3f)objectArray[0];
            MotionKey2.Color3f color3f2 = (MotionKey2.Color3f)objectArray[1];
            MotionKey2.Color3f color3f3 = (MotionKey2.Color3f)objectArray[2];
            MotionKey2.Color3f color3f4 = (MotionKey2.Color3f)objectArray[3];
            float f2 = color3f3.getPosition() - color3f2.getPosition();
            float f3 = (f - color3f2.getPosition()) / f2;
            javax.vecmath.Color3f color3f5 = color3f2.getColor3f();
            javax.vecmath.Color3f color3f6 = color3f3.getColor3f();
            if (this.interpolationMethod == LINEAR) {
                javax.vecmath.Color3f color3f7 = new javax.vecmath.Color3f();
                color3f7.interpolate(color3f5, color3f6, f3);
                return color3f7;
            }
            Vector3f vector3f = new Vector3f();
            if (color3f != null) {
                vector3f.sub(color3f6, color3f.getColor3f());
                vector3f.scale(f2 / (color3f3.getPosition() - color3f.getPosition()));
            }
            Vector3f vector3f2 = new Vector3f();
            if (color3f4 != null) {
                vector3f2.sub(color3f4.getColor3f(), color3f5);
                vector3f2.scale(f2 / (color3f4.getPosition() - color3f2.getPosition()));
            }
            return new javax.vecmath.Color3f(this.cubicInterpolate(color3f5.x, vector3f.x, color3f6.x, vector3f2.x, f3), this.cubicInterpolate(color3f5.y, vector3f.y, color3f6.y, vector3f2.y, f3), this.cubicInterpolate(color3f5.z, vector3f.z, color3f6.z, vector3f2.z, f3));
        }

        public MotionKey2.Color3f setColor3fAt(float f, javax.vecmath.Color3f color3f) {
            MotionKey2.Color3f color3f2 = (MotionKey2.Color3f)this.getKeyAt(f);
            if (color3f2 == null) {
                color3f2 = new MotionKey2.Color3f(f, color3f);
                this.addKey(color3f2);
            } else {
                color3f2.setColor3f(color3f);
            }
            return color3f2;
        }

        public MotionKey2 insertKeyAt(float f) {
            if (this.getKeyAt(f) == null) {
                this.setColor3fAt(f, this.getColor3fAt(f));
            }
            return this.getKeyAt(f);
        }

        private Color3f() {
        }
    }

    public static class Quat4f
    extends MotionCurve2 {
        public javax.vecmath.Quat4f getQuat4fAt(float f) {
            javax.vecmath.Quat4f quat4f;
            javax.vecmath.Quat4f quat4f2;
            javax.vecmath.Quat4f quat4f3;
            javax.vecmath.Quat4f quat4f4;
            javax.vecmath.Quat4f quat4f5;
            if (f <= this.getStart()) {
                return ((MotionKey2.Quat4f)this.list.get(0)).getQuat4f();
            }
            if (f >= this.getEnd()) {
                return ((MotionKey2.Quat4f)this.list.get(this.list.size() - 1)).getQuat4f();
            }
            Object[] objectArray = this.getInterpolationKeysFor(f);
            MotionKey2.Quat4f quat4f6 = (MotionKey2.Quat4f)objectArray[0];
            MotionKey2.Quat4f quat4f7 = (MotionKey2.Quat4f)objectArray[1];
            MotionKey2.Quat4f quat4f8 = (MotionKey2.Quat4f)objectArray[2];
            MotionKey2.Quat4f quat4f9 = (MotionKey2.Quat4f)objectArray[3];
            if (quat4f6 != null) {
                Quat4f.shortenQuaternionPath(quat4f6.getQuat4f(), quat4f7.getQuat4f());
            }
            Quat4f.shortenQuaternionPath(quat4f7.getQuat4f(), quat4f8.getQuat4f());
            if (quat4f9 != null) {
                Quat4f.shortenQuaternionPath(quat4f8.getQuat4f(), quat4f9.getQuat4f());
            }
            float f2 = quat4f8.getPosition() - quat4f7.getPosition();
            float f3 = (f - quat4f7.getPosition()) / f2;
            javax.vecmath.Quat4f quat4f10 = quat4f7.getQuat4f();
            javax.vecmath.Quat4f quat4f11 = quat4f8.getQuat4f();
            if (this.interpolationMethod == LINEAR) {
                return Quat4f.slerp(quat4f10, quat4f11, f3);
            }
            if (quat4f6 != null) {
                javax.vecmath.Quat4f quat4f12 = quat4f6.getQuat4f();
                quat4f5 = Quat4f.slerp(quat4f12, quat4f10, 2.0f);
                quat4f4 = Quat4f.slerp(quat4f12, quat4f11, 2.0f);
                quat4f3 = Quat4f.slerp(quat4f5, quat4f4, 0.5f);
                quat4f2 = Quat4f.slerp(quat4f10, quat4f3, 0.333f * f2 / (quat4f8.getPosition() - quat4f6.getPosition()));
            } else {
                quat4f2 = new javax.vecmath.Quat4f(quat4f10);
            }
            if (quat4f9 != null) {
                javax.vecmath.Quat4f quat4f13 = quat4f9.getQuat4f();
                quat4f5 = Quat4f.slerp(quat4f13, quat4f11, 2.0f);
                quat4f4 = Quat4f.slerp(quat4f13, quat4f10, 2.0f);
                quat4f3 = Quat4f.slerp(quat4f4, quat4f5, 0.5f);
                quat4f = Quat4f.slerp(quat4f11, quat4f3, 0.333f * f2 / (quat4f9.getPosition() - quat4f7.getPosition()));
            } else {
                quat4f = new javax.vecmath.Quat4f(quat4f11);
            }
            quat4f5 = Quat4f.slerp(quat4f10, quat4f2, f3);
            quat4f4 = Quat4f.slerp(quat4f2, quat4f, f3);
            quat4f3 = Quat4f.slerp(quat4f, quat4f11, f3);
            javax.vecmath.Quat4f quat4f14 = Quat4f.slerp(quat4f5, quat4f4, f3);
            javax.vecmath.Quat4f quat4f15 = Quat4f.slerp(quat4f4, quat4f3, f3);
            return Quat4f.slerp(quat4f14, quat4f15, f3);
        }

        public MotionKey2.Quat4f setQuat4fAt(float f, javax.vecmath.Quat4f quat4f) {
            MotionKey2.Quat4f quat4f2 = (MotionKey2.Quat4f)this.getKeyAt(f);
            if (quat4f2 == null) {
                quat4f2 = new MotionKey2.Quat4f(f, quat4f);
                this.addKey(quat4f2);
            } else {
                quat4f2.setQuat4f(quat4f);
            }
            return quat4f2;
        }

        public MotionKey2 insertKeyAt(float f) {
            if (this.getKeyAt(f) == null) {
                this.setQuat4fAt(f, this.getQuat4fAt(f));
            }
            return this.getKeyAt(f);
        }

        static javax.vecmath.Quat4f slerp(Tuple4f tuple4f, Tuple4f tuple4f2, float f) {
            float f2;
            float f3;
            Quat4f quat4f = new Quat4f();
            float f4 = tuple4f.x * tuple4f2.x + tuple4f.y * tuple4f2.y + tuple4f.z * tuple4f2.z + tuple4f.w * tuple4f2.w;
            if ((double)Math.abs(f4) < 0.9999) {
                double d = Math.acos(f4);
                double d2 = Math.sin(d);
                f3 = (float)(Math.sin((1.0 - (double)f) * d) / d2);
                f2 = (float)(Math.sin((double)f * d) / d2);
            } else {
                f3 = 1.0f - f;
                f2 = f;
            }
            return new javax.vecmath.Quat4f(f3 * tuple4f.x + f2 * tuple4f2.x, f3 * tuple4f.y + f2 * tuple4f2.y, f3 * tuple4f.z + f2 * tuple4f2.z, f3 * tuple4f.w + f2 * tuple4f2.w);
        }

        static void shortenQuaternionPath(javax.vecmath.Quat4f quat4f, javax.vecmath.Quat4f quat4f2) {
            if (quat4f.x * quat4f2.x + quat4f.y * quat4f2.y + quat4f.z * quat4f2.z + quat4f.w * quat4f2.w < 0.0f) {
                quat4f2.set(-quat4f2.x, -quat4f2.y, -quat4f2.z, -quat4f2.w);
            }
        }

        private Quat4f() {
        }
    }

    public static final class InterpolationMethod {
        private String name;

        public final String toString() {
            return this.name;
        }

        private InterpolationMethod(String string) {
            this.name = string;
        }
    }
}

