/*
 * Decompiled with CFR 0.152.
 */
package jpatch.entity;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector3f;
import jpatch.auxilary.Bezier;
import jpatch.auxilary.BezierPatch;
import jpatch.auxilary.Functions;
import jpatch.auxilary.XMLutils;
import jpatch.boundary.MainFrame;
import jpatch.boundary.selection.PointSelection;
import jpatch.entity.ControlPoint;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Model;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Patch {
    private static final Point3f[] ap3CoonsPatch9 = new Point3f[9];
    private static final Point3f[] ap3CoonsPatch12 = new Point3f[12];
    private static final Point3f[] ap3CoonsPatch15 = new Point3f[15];
    private static final Point3f[][] aap3Patches1 = new Point3f[1][16];
    private static final Point3f[][] aap3Patches3 = new Point3f[3][16];
    private Patch ptNext;
    private Patch ptPrev;
    private ControlPoint[] acpPoint;
    private JPatchMaterial material;
    private boolean bDynamic;
    private boolean bValid;
    private Model model;

    public final void flip() {
        ControlPoint[] controlPointArray = this.acpPoint;
        this.acpPoint = new ControlPoint[controlPointArray.length];
        int n = 0;
        int n2 = controlPointArray.length - 1;
        while (n <= n2) {
            this.acpPoint[n] = controlPointArray[n2 - n++];
        }
    }

    public final boolean contains(ControlPoint controlPoint) {
        int n = 0;
        while (n < this.acpPoint.length) {
            if (controlPoint == this.acpPoint[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean isHidden() {
        int n = 0;
        while (n < this.acpPoint.length) {
            if (this.acpPoint[n].isHidden()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final ControlPoint[] getControlPoints() {
        return this.acpPoint;
    }

    public final String toString() {
        String string = "Patch@" + this.hashCode() + ' ';
        int n = 0;
        while (n < this.acpPoint.length) {
            string = string + this.acpPoint[n].toString() + ' ';
            ++n;
        }
        return string;
    }

    public final boolean isEqual(ControlPoint[] controlPointArray) {
        if (this.acpPoint.length == controlPointArray.length) {
            boolean bl = false;
            int n = this.acpPoint.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.acpPoint[0] == controlPointArray[n2]) {
                    if (this.acpPoint[1] == controlPointArray[(n2 + 1) % n]) {
                        int n3 = 2;
                        while (n3 < n) {
                            if (this.acpPoint[n3] != controlPointArray[(n2 + n3) % n]) {
                                return false;
                            }
                            ++n3;
                        }
                        return true;
                    }
                    if (this.acpPoint[1] == controlPointArray[(n2 + n - 1) % n]) {
                        int n4 = 2;
                        while (n4 < n) {
                            if (this.acpPoint[n4] != controlPointArray[(n2 + n - n4) % n]) {
                                return false;
                            }
                            ++n4;
                        }
                        return true;
                    }
                    return false;
                }
                ++n2;
            }
        }
        return false;
    }

    public final void check(PointSelection pointSelection) {
        this.bDynamic = false;
        int n = 0;
        while (n < this.acpPoint.length) {
            if (pointSelection.contains(this.acpPoint[n].getHead())) {
                this.bDynamic = true;
            }
            if (this.acpPoint[n].getPrev() != null && pointSelection.contains(this.acpPoint[n].getPrev().getHead())) {
                this.bDynamic = true;
            }
            if (this.acpPoint[n].getNext() != null && pointSelection.contains(this.acpPoint[n].getNext().getHead())) {
                this.bDynamic = true;
            }
            if (this.bDynamic) break;
            ++n;
        }
    }

    public final boolean isSelected(PointSelection pointSelection) {
        int n = 0;
        while (n < this.acpPoint.length) {
            if (!(pointSelection.contains(this.acpPoint[n].getHead()) || this.acpPoint[n].isTargetHook() || this.acpPoint[n].isChildHook())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isValid() {
        return this.bValid;
    }

    public final void setValid(boolean bl) {
        this.bValid = bl;
    }

    public final boolean isDynamic() {
        return this.bDynamic;
    }

    public final void setNext(Patch patch) {
        this.ptNext = patch;
    }

    public final void setPrev(Patch patch) {
        this.ptPrev = patch;
    }

    public final Patch getNext() {
        return this.ptNext;
    }

    public final Patch getPrev() {
        return this.ptPrev;
    }

    public final int getType() {
        int n = this.acpPoint.length;
        if (n == 6 || n == 8 || n == 10) {
            return n / 2;
        }
        return -1;
    }

    public final int getSize() {
        switch (this.getType()) {
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    public final void remove() {
        if (this.ptPrev != null) {
            this.ptPrev.ptNext = this.ptNext;
        }
        if (this.ptNext != null) {
            this.ptNext.ptPrev = this.ptPrev;
        }
        if (this.model != null && this.model.getLastPatch() == this) {
            this.model.setLastPatch(this.ptPrev);
        }
        if (this.model != null && this.model.getFirstPatch() == this) {
            this.model.setFirstPatch(this.ptNext);
        }
        this.model = null;
    }

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model model) {
        this.model = model;
    }

    public final StringBuffer xml(int n) {
        StringBuffer stringBuffer = XMLutils.indent(n);
        StringBuffer stringBuffer2 = XMLutils.indent(n + 1);
        StringBuffer stringBuffer3 = XMLutils.lineBreak();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n2 = this.material != null ? this.material.getXmlNumber() : -1;
        stringBuffer4.append(stringBuffer).append("<patch material=\"" + n2 + "\">").append(stringBuffer3);
        stringBuffer4.append(stringBuffer2).append("<points>");
        int n3 = 0;
        while (n3 < this.acpPoint.length) {
            stringBuffer4.append(this.acpPoint[n3].getXmlNumber());
            if (n3 < this.acpPoint.length - 1) {
                stringBuffer4.append(",");
            }
            ++n3;
        }
        stringBuffer4.append("</points>").append(stringBuffer3);
        stringBuffer4.append(stringBuffer).append("</patch>").append(stringBuffer3);
        return stringBuffer4;
    }

    private final Point3f parallelogram(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Point3f point3f4 = new Point3f(point3f2);
        point3f4.add(point3f3);
        point3f4.sub(point3f);
        return point3f4;
    }

    public final Point3f[] coonsPatch() {
        Point3f[] point3fArray = null;
        if (this.acpPoint.length == 6) {
            point3fArray = new Point3f[9];
        }
        if (this.acpPoint.length == 8) {
            point3fArray = new Point3f[12];
        }
        if (this.acpPoint.length == 10) {
            point3fArray = new Point3f[15];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.acpPoint.length) {
            point3fArray[n++] = new Point3f(this.acpPoint[n2].getPosition());
            if (this.acpPoint[n2].getNext() == this.acpPoint[n2 + 1]) {
                point3fArray[n++] = new Point3f(this.acpPoint[n2].getOutTangent());
                point3fArray[n++] = new Point3f(this.acpPoint[++n2].getInTangent());
            } else {
                point3fArray[n++] = new Point3f(this.acpPoint[n2].getInTangent());
                point3fArray[n++] = new Point3f(this.acpPoint[++n2].getOutTangent());
            }
            ++n2;
        }
        return point3fArray;
    }

    public final Point3f[] referenceCoonsPatch() {
        Point3f[] point3fArray = null;
        if (this.acpPoint.length == 6) {
            point3fArray = new Point3f[9];
        }
        if (this.acpPoint.length == 8) {
            point3fArray = new Point3f[12];
        }
        if (this.acpPoint.length == 10) {
            point3fArray = new Point3f[15];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.acpPoint.length) {
            point3fArray[n++] = new Point3f(this.acpPoint[n2].getRefPosition());
            if (this.acpPoint[n2].getNext() == this.acpPoint[n2 + 1]) {
                point3fArray[n++] = new Point3f(this.acpPoint[n2].getRefOutTangent());
                point3fArray[n++] = new Point3f(this.acpPoint[++n2].getRefInTangent());
            } else {
                point3fArray[n++] = new Point3f(this.acpPoint[n2].getRefInTangent());
                point3fArray[n++] = new Point3f(this.acpPoint[++n2].getRefOutTangent());
            }
            ++n2;
        }
        return point3fArray;
    }

    public static final void shift(Point3f[] point3fArray, int n) {
        int n2 = point3fArray.length;
        Point3f[] point3fArray2 = new Point3f[n2];
        int n3 = 0;
        while (n3 < n2) {
            point3fArray2[n3] = point3fArray[(n3 + n + n2) % n2];
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            point3fArray[n3] = point3fArray2[n3];
            ++n3;
        }
    }

    public final void setMaterial(JPatchMaterial jPatchMaterial) {
        this.material = jPatchMaterial;
    }

    public final JPatchMaterial getMaterial() {
        return this.material;
    }

    public final Point3f[][] bicubicPatches() {
        return this.bicubicPatches(this.coonsPatch());
    }

    public final Point3f[][] bicubicReferencePatches() {
        return this.bicubicPatches(this.referenceCoonsPatch());
    }

    private final Point3f[][] bicubicPatches(Point3f[] point3fArray) {
        Point3f[][] point3fArray2 = null;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        switch (this.acpPoint.length) {
            case 10: {
                Point3f point3f5 = Functions.parallelogram(point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f6 = Functions.parallelogram(point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f7 = Functions.parallelogram(point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f8 = Functions.parallelogram(point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f9 = Functions.parallelogram(point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f10 = Functions.average(point3f5, point3fArray[0], point3fArray[1], point3fArray[14]);
                Point3f point3f11 = Functions.average(point3f6, point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f12 = Functions.average(point3f7, point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f13 = Functions.average(point3f8, point3fArray[9], point3fArray[10], point3fArray[8]);
                Point3f point3f14 = Functions.average(point3f9, point3fArray[12], point3fArray[13], point3fArray[11]);
                Point3f point3f15 = Functions.average(point3f5, point3f6, point3fArray[1], point3fArray[2]);
                Point3f point3f16 = Functions.average(point3f6, point3f7, point3fArray[4], point3fArray[5]);
                Point3f point3f17 = Functions.average(point3f7, point3f8, point3fArray[7], point3fArray[8]);
                Point3f point3f18 = Functions.average(point3f8, point3f9, point3fArray[10], point3fArray[11]);
                Point3f point3f19 = Functions.average(point3f9, point3f5, point3fArray[13], point3fArray[14]);
                Point3f point3f20 = Functions.average(point3f5, point3f6, point3f7, point3f8, point3f9);
                Point3f point3f21 = Functions.average(point3f20, point3f19, point3f10, point3f15);
                Point3f point3f22 = Functions.average(point3f20, point3f15, point3f11, point3f16);
                Point3f point3f23 = Functions.average(point3f20, point3f16, point3f12, point3f17);
                Point3f point3f24 = Functions.average(point3f20, point3f17, point3f13, point3f18);
                Point3f point3f25 = Functions.average(point3f20, point3f18, point3f14, point3f19);
                Point3f point3f26 = Functions.average(point3f25, point3f21);
                Point3f point3f27 = Functions.average(point3f21, point3f22);
                Point3f point3f28 = Functions.average(point3f22, point3f23);
                Point3f point3f29 = Functions.average(point3f23, point3f24);
                Point3f point3f30 = Functions.average(point3f24, point3f25);
                Point3f point3f31 = Functions.average(point3f21, point3f22, point3f23, point3f24, point3f25);
                Point3f[][] point3fArray3 = new Point3f[5][7];
                point3fArray3[0] = Bezier.deCasteljau(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], 0.5f);
                point3fArray3[1] = Bezier.deCasteljau(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], 0.5f);
                point3fArray3[2] = Bezier.deCasteljau(point3fArray[6], point3fArray[7], point3fArray[8], point3fArray[9], 0.5f);
                point3fArray3[3] = Bezier.deCasteljau(point3fArray[9], point3fArray[10], point3fArray[11], point3fArray[12], 0.5f);
                point3fArray3[4] = Bezier.deCasteljau(point3fArray[12], point3fArray[13], point3fArray[14], point3fArray[0], 0.5f);
                point3fArray2 = new Point3f[5][16];
                point3fArray2[0][0] = new Point3f(point3fArray3[0][0]);
                point3fArray2[0][1] = new Point3f(point3fArray3[0][1]);
                point3fArray2[0][2] = new Point3f(point3fArray3[0][2]);
                point3fArray2[0][3] = new Point3f(point3fArray3[0][3]);
                point3fArray2[0][4] = new Point3f(point3fArray3[4][5]);
                point3fArray2[0][7] = new Point3f(point3fArray3[0][3]);
                point3fArray2[0][7].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray2[0][8] = new Point3f(point3fArray3[4][4]);
                point3fArray2[0][11] = new Point3f(point3f27);
                point3fArray2[0][12] = new Point3f(point3fArray3[4][3]);
                point3fArray2[0][13] = new Point3f(point3fArray3[4][3]);
                point3fArray2[0][13].add(Functions.average(Functions.vector(point3fArray[0], point3fArray[1]), Functions.vector(point3fArray[12], point3fArray[11])));
                point3fArray2[0][14] = new Point3f(point3f26);
                point3fArray2[0][15] = new Point3f(point3f31);
                BezierPatch.computeInnerControlPoints(point3fArray2[0]);
                point3fArray2[0][10].set(point3f21);
                point3fArray2[1][0] = new Point3f(point3fArray3[1][0]);
                point3fArray2[1][1] = new Point3f(point3fArray3[1][1]);
                point3fArray2[1][2] = new Point3f(point3fArray3[1][2]);
                point3fArray2[1][3] = new Point3f(point3fArray3[1][3]);
                point3fArray2[1][4] = new Point3f(point3fArray3[0][5]);
                point3fArray2[1][7] = new Point3f(point3fArray3[1][3]);
                point3fArray2[1][7].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray2[1][8] = new Point3f(point3fArray3[0][4]);
                point3fArray2[1][11] = new Point3f(point3f28);
                point3fArray2[1][12] = new Point3f(point3fArray3[0][3]);
                point3fArray2[1][13] = new Point3f(point3fArray3[0][3]);
                point3fArray2[1][13].add(Functions.average(Functions.vector(point3fArray[3], point3fArray[4]), Functions.vector(point3fArray[0], point3fArray[14])));
                point3fArray2[1][14] = new Point3f(point3f27);
                point3fArray2[1][15] = new Point3f(point3f31);
                BezierPatch.computeInnerControlPoints(point3fArray2[1]);
                point3fArray2[1][10].set(point3f22);
                point3fArray2[2][0] = new Point3f(point3fArray3[2][0]);
                point3fArray2[2][1] = new Point3f(point3fArray3[2][1]);
                point3fArray2[2][2] = new Point3f(point3fArray3[2][2]);
                point3fArray2[2][3] = new Point3f(point3fArray3[2][3]);
                point3fArray2[2][4] = new Point3f(point3fArray3[1][5]);
                point3fArray2[2][7] = new Point3f(point3fArray3[2][3]);
                point3fArray2[2][7].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray2[2][8] = new Point3f(point3fArray3[1][4]);
                point3fArray2[2][11] = new Point3f(point3f29);
                point3fArray2[2][12] = new Point3f(point3fArray3[1][3]);
                point3fArray2[2][13] = new Point3f(point3fArray3[1][3]);
                point3fArray2[2][13].add(Functions.average(Functions.vector(point3fArray[6], point3fArray[7]), Functions.vector(point3fArray[3], point3fArray[2])));
                point3fArray2[2][14] = new Point3f(point3f28);
                point3fArray2[2][15] = new Point3f(point3f31);
                BezierPatch.computeInnerControlPoints(point3fArray2[2]);
                point3fArray2[2][10].set(point3f23);
                point3fArray2[3][0] = new Point3f(point3fArray3[3][0]);
                point3fArray2[3][1] = new Point3f(point3fArray3[3][1]);
                point3fArray2[3][2] = new Point3f(point3fArray3[3][2]);
                point3fArray2[3][3] = new Point3f(point3fArray3[3][3]);
                point3fArray2[3][4] = new Point3f(point3fArray3[2][5]);
                point3fArray2[3][7] = new Point3f(point3fArray3[3][3]);
                point3fArray2[3][7].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray2[3][8] = new Point3f(point3fArray3[2][4]);
                point3fArray2[3][11] = new Point3f(point3f30);
                point3fArray2[3][12] = new Point3f(point3fArray3[2][3]);
                point3fArray2[3][13] = new Point3f(point3fArray3[2][3]);
                point3fArray2[3][13].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[10]), Functions.vector(point3fArray[6], point3fArray[5])));
                point3fArray2[3][14] = new Point3f(point3f29);
                point3fArray2[3][15] = new Point3f(point3f31);
                BezierPatch.computeInnerControlPoints(point3fArray2[3]);
                point3fArray2[3][10].set(point3f24);
                point3fArray2[4][0] = new Point3f(point3fArray3[4][0]);
                point3fArray2[4][1] = new Point3f(point3fArray3[4][1]);
                point3fArray2[4][2] = new Point3f(point3fArray3[4][2]);
                point3fArray2[4][3] = new Point3f(point3fArray3[4][3]);
                point3fArray2[4][4] = new Point3f(point3fArray3[3][5]);
                point3fArray2[4][7] = new Point3f(point3fArray3[4][3]);
                point3fArray2[4][7].add(Functions.average(Functions.vector(point3fArray[12], point3fArray[11]), Functions.vector(point3fArray[0], point3fArray[1])));
                point3fArray2[4][8] = new Point3f(point3fArray3[3][4]);
                point3fArray2[4][11] = new Point3f(point3f26);
                point3fArray2[4][12] = new Point3f(point3fArray3[3][3]);
                point3fArray2[4][13] = new Point3f(point3fArray3[3][3]);
                point3fArray2[4][13].add(Functions.average(Functions.vector(point3fArray[9], point3fArray[8]), Functions.vector(point3fArray[12], point3fArray[13])));
                point3fArray2[4][14] = new Point3f(point3f30);
                point3fArray2[4][15] = new Point3f(point3f31);
                BezierPatch.computeInnerControlPoints(point3fArray2[4]);
                point3fArray2[4][10].set(point3f25);
                break;
            }
            case 8: {
                point3fArray2 = new Point3f[1][16];
                point3fArray2[0][0] = point3fArray[0];
                point3fArray2[0][1] = point3fArray[1];
                point3fArray2[0][2] = point3fArray[2];
                point3fArray2[0][3] = point3fArray[3];
                point3fArray2[0][7] = point3fArray[4];
                point3fArray2[0][11] = point3fArray[5];
                point3fArray2[0][15] = point3fArray[6];
                point3fArray2[0][14] = point3fArray[7];
                point3fArray2[0][13] = point3fArray[8];
                point3fArray2[0][12] = point3fArray[9];
                point3fArray2[0][8] = point3fArray[10];
                point3fArray2[0][4] = point3fArray[11];
                BezierPatch.computeInnerControlPoints(point3fArray2[0]);
                break;
            }
            case 60: {
                Point3f point3f32;
                Point3f point3f33;
                Point3f point3f34;
                Point3f point3f35 = Functions.parallelogram(point3fArray[0], point3fArray[1], point3fArray[8]);
                Point3f point3f36 = Functions.parallelogram(point3fArray[3], point3fArray[4], point3fArray[2]);
                Point3f point3f37 = Functions.parallelogram(point3fArray[6], point3fArray[7], point3fArray[5]);
                Point3f point3f38 = Functions.average(point3fArray[0], point3fArray[1], point3f35, point3fArray[8]);
                Point3f point3f39 = Functions.average(point3fArray[1], point3fArray[2], point3f36, point3f35);
                Point3f point3f40 = Functions.average(point3fArray[3], point3fArray[4], point3f36, point3fArray[2]);
                Point3f point3f41 = Functions.average(point3fArray[4], point3fArray[5], point3f37, point3f36);
                Point3f point3f42 = Functions.average(point3fArray[6], point3fArray[7], point3f37, point3fArray[5]);
                Point3f point3f43 = Functions.average(point3fArray[7], point3fArray[8], point3f35, point3f37);
                Point3f point3f44 = Functions.average(point3f35, point3f36, point3f37);
                Point3f point3f45 = Functions.average(point3f38, point3f39, point3f44, point3f43);
                Point3f point3f46 = Functions.average(point3f40, point3f41, point3f44, point3f39);
                Point3f point3f47 = Functions.average(point3f42, point3f43, point3f44, point3f41);
                Point3f point3f48 = Functions.average(point3f45, point3f46, point3f47);
                Point3f point3f49 = Functions.average(point3f45, point3f47);
                Point3f point3f50 = Functions.average(point3f45, point3f46);
                Point3f point3f51 = Functions.average(point3f46, point3f47);
                point3fArray2 = new Point3f[3][16];
                Point3f[][] point3fArray4 = new Point3f[3][7];
                point3fArray4[0] = Bezier.deCasteljau(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], 0.5f);
                point3fArray4[1] = Bezier.deCasteljau(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], 0.5f);
                point3fArray4[2] = Bezier.deCasteljau(point3fArray[6], point3fArray[7], point3fArray[8], point3fArray[0], 0.5f);
                Point3f point3f52 = new Point3f(point3fArray4[0][4]);
                Point3f point3f53 = new Point3f(point3fArray4[0][3]);
                Point3f point3f54 = new Point3f(point3fArray4[0][2]);
                Point3f point3f55 = new Point3f(point3fArray4[1][4]);
                Point3f point3f56 = new Point3f(point3fArray4[1][3]);
                Point3f point3f57 = new Point3f(point3fArray4[1][2]);
                Point3f point3f58 = new Point3f(point3fArray4[2][4]);
                Point3f point3f59 = new Point3f(point3fArray4[2][3]);
                Point3f point3f60 = new Point3f(point3fArray4[2][2]);
                Point3f point3f61 = Functions.average(Bezier.evaluate(point3fArray[4], point3f37, point3f35, point3fArray[8], 0.5f), point3f53);
                Point3f point3f62 = Functions.average(Bezier.evaluate(point3fArray[7], point3f36, point3f37, point3fArray[2], 0.5f), point3f56);
                Point3f point3f63 = Functions.average(Bezier.evaluate(point3fArray[5], point3f36, point3f35, point3fArray[1], 0.5f), point3f59);
                Point3f point3f64 = point3f34 = point3f50;
                Point3f point3f65 = point3f34;
                Point3f point3f66 = point3f33 = point3f51;
                Point3f point3f67 = point3f33;
                Point3f point3f68 = point3f32 = point3f49;
                Point3f point3f69 = point3f32;
                Point3f point3f70 = point3f48;
                Point3f[] point3fArray5 = Bezier.elevateDegree(point3f53, point3f61, point3f65, point3f70);
                Point3f[] point3fArray6 = Bezier.elevateDegree(point3f56, point3f62, point3f67, point3f70);
                Point3f[] point3fArray7 = Bezier.elevateDegree(point3f59, point3f63, point3f69, point3f70);
                Tuple2f tuple2f = Functions.lineLineIntersection(point3fArray6[3], point3fArray7[3], point3fArray5[3], point3fArray5[4]);
                float f = tuple2f.x;
                float f2 = tuple2f.y;
                tuple2f = Functions.lineLineIntersection(point3fArray7[3], point3fArray5[3], point3fArray6[3], point3fArray6[4]);
                float f3 = tuple2f.x;
                float f4 = tuple2f.y;
                tuple2f = Functions.lineLineIntersection(point3fArray5[3], point3fArray6[3], point3fArray7[3], point3fArray7[4]);
                float f5 = tuple2f.x;
                float f6 = tuple2f.y;
                float f7 = 1.0f - f;
                float f8 = 1.0f - f2;
                float f9 = 1.0f - f3;
                float f10 = 1.0f - f4;
                float f11 = 1.0f - f5;
                float f12 = 1.0f - f6;
                f11 = 0.5f;
                f5 = 0.5f;
                f9 = 0.5f;
                f3 = 0.5f;
                f7 = 0.5f;
                f = 0.5f;
                f6 = 1.5f;
                f4 = 1.5f;
                f2 = 1.5f;
                f12 = -0.5f;
                f10 = -0.5f;
                f8 = -0.5f;
                System.out.println("  l,u");
                System.out.println("a:" + f + ',' + f2);
                System.out.println("b:" + f3 + ',' + f4);
                System.out.println("c:" + f5 + ',' + f6);
                float f13 = -0.33333334f * (point3f52.x + point3f54.x + 0.75f * point3fArray5[0].x - 8.75f * point3fArray5[1].x);
                float f14 = -0.75f * point3fArray5[1].x + 4.75f * point3fArray5[2].x;
                float f15 = -0.75f * point3fArray5[2].x + 3.4166667f * point3fArray5[3].x - 0.33333334f * (point3f66.x + point3f32.x);
                float f16 = -0.33333334f * (point3f52.y + point3f54.y + 0.75f * point3fArray5[0].y - 8.75f * point3fArray5[1].y);
                float f17 = -0.75f * point3fArray5[1].y + 4.75f * point3fArray5[2].y;
                float f18 = -0.75f * point3fArray5[2].y + 3.4166667f * point3fArray5[3].y - 0.33333334f * (point3f66.y + point3f32.y);
                float f19 = -0.33333334f * (point3f52.z + point3f54.z + 0.75f * point3fArray5[0].z - 8.75f * point3fArray5[1].z);
                float f20 = -0.75f * point3fArray5[1].z + 4.75f * point3fArray5[2].z;
                float f21 = -0.75f * point3fArray5[2].z + 3.4166667f * point3fArray5[3].z - 0.33333334f * (point3f66.z + point3f32.z);
                float f22 = -0.33333334f * (point3f55.x + point3f57.x + 0.75f * point3fArray6[0].x - 8.75f * point3fArray6[1].x);
                float f23 = -0.75f * point3fArray6[1].x + 4.75f * point3fArray6[2].x;
                float f24 = -0.75f * point3fArray6[2].x + 3.4166667f * point3fArray6[3].x - 0.33333334f * (point3f68.x + point3f34.x);
                float f25 = -0.33333334f * (point3f55.y + point3f57.y + 0.75f * point3fArray6[0].y - 8.75f * point3fArray6[1].y);
                float f26 = -0.75f * point3fArray6[1].y + 4.75f * point3fArray6[2].y;
                float f27 = -0.75f * point3fArray6[2].y + 3.4166667f * point3fArray6[3].y - 0.33333334f * (point3f68.y + point3f34.y);
                float f28 = -0.33333334f * (point3f55.z + point3f57.z + 0.75f * point3fArray6[0].z - 8.75f * point3fArray6[1].z);
                float f29 = -0.75f * point3fArray6[1].z + 4.75f * point3fArray6[2].z;
                float f30 = -0.75f * point3fArray6[2].z + 3.4166667f * point3fArray6[3].z - 0.33333334f * (point3f68.z + point3f34.z);
                float f31 = -0.33333334f * (point3f58.x + point3f60.x + 0.75f * point3fArray7[0].x - 8.75f * point3fArray7[1].x);
                float f32 = -0.75f * point3fArray7[1].x + 4.75f * point3fArray7[2].x;
                float f33 = -0.75f * point3fArray7[2].x + 3.4166667f * point3fArray7[3].x - 0.33333334f * (point3f64.x + point3f33.x);
                float f34 = -0.33333334f * (point3f58.y + point3f60.y + 0.75f * point3fArray7[0].y - 8.75f * point3fArray7[1].y);
                float f35 = -0.75f * point3fArray7[1].y + 4.75f * point3fArray7[2].y;
                float f36 = -0.75f * point3fArray7[2].y + 3.4166667f * point3fArray7[3].y - 0.33333334f * (point3f64.y + point3f33.y);
                float f37 = -0.33333334f * (point3f58.z + point3f60.z + 0.75f * point3fArray7[0].z - 8.75f * point3fArray7[1].z);
                float f38 = -0.75f * point3fArray7[1].z + 4.75f * point3fArray7[2].z;
                float f39 = -0.75f * point3fArray7[2].z + 3.4166667f * point3fArray7[3].z - 0.33333334f * (point3f64.z + point3f33.z);
                Point3f point3f71 = Functions.average(point3fArray[2], point3f37);
                Point3f point3f72 = Functions.average(point3fArray[5], point3f36);
                Point3f point3f73 = Functions.average(point3fArray[8], point3f35);
                float[][] fArrayArray = new float[9][];
                float[] fArray = new float[12];
                fArray[0] = 1.0f;
                fArray[9] = point3f71.x;
                fArray[10] = point3f71.y;
                fArray[11] = point3f71.z;
                fArrayArray[0] = fArray;
                float[] fArray2 = new float[12];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray2[2] = 1.0f;
                fArray2[3] = 1.0f;
                fArray2[9] = f14;
                fArray2[10] = f17;
                fArray2[11] = f20;
                fArrayArray[1] = fArray2;
                float[] fArray3 = new float[12];
                fArray3[2] = 1.0f;
                fArray3[3] = 1.0f;
                fArray3[9] = f15;
                fArray3[10] = f18;
                fArray3[11] = f21;
                fArrayArray[2] = fArray3;
                float[] fArray4 = new float[12];
                fArray4[4] = 1.0f;
                fArray4[9] = point3f72.x;
                fArray4[10] = point3f72.y;
                fArray4[11] = point3f72.z;
                fArrayArray[3] = fArray4;
                float[] fArray5 = new float[12];
                fArray5[2] = 1.0f;
                fArray5[4] = 1.0f;
                fArray5[5] = 1.0f;
                fArray5[6] = 1.0f;
                fArray5[9] = f23;
                fArray5[10] = f26;
                fArray5[11] = f29;
                fArrayArray[4] = fArray5;
                float[] fArray6 = new float[12];
                fArray6[2] = 1.0f;
                fArray6[6] = 1.0f;
                fArray6[9] = f24;
                fArray6[10] = f27;
                fArray6[11] = f30;
                fArrayArray[5] = fArray6;
                float[] fArray7 = new float[12];
                fArray7[7] = 1.0f;
                fArray7[9] = point3f73.x;
                fArray7[10] = point3f73.y;
                fArray7[11] = point3f73.z;
                fArrayArray[6] = fArray7;
                float[] fArray8 = new float[12];
                fArray8[3] = 1.0f;
                fArray8[6] = 1.0f;
                fArray8[7] = 1.0f;
                fArray8[8] = 1.0f;
                fArray8[9] = f32;
                fArray8[10] = f35;
                fArray8[11] = f38;
                fArrayArray[7] = fArray8;
                float[] fArray9 = new float[12];
                fArray9[3] = 1.0f;
                fArray9[6] = 1.0f;
                fArray9[9] = f33;
                fArray9[10] = f36;
                fArray9[11] = f39;
                fArrayArray[8] = fArray9;
                Point3f[] point3fArray8 = Functions.solve(fArrayArray);
                int n = 0;
                while (n < point3fArray8.length) {
                    System.out.println("" + n + ' ' + point3fArray8[n]);
                    ++n;
                }
                point3fArray2[0][0] = new Point3f(point3fArray4[1][0]);
                point3fArray2[0][1] = new Point3f(point3fArray4[1][1]);
                point3fArray2[0][2] = new Point3f(point3fArray4[1][2]);
                point3fArray2[0][3] = new Point3f(point3fArray4[1][3]);
                point3fArray2[0][4] = new Point3f(point3fArray4[0][5]);
                point3fArray2[0][5] = Functions.parallelogram(point3fArray4[1][0], point3fArray4[1][1], point3fArray4[0][5]);
                point3fArray2[0][6] = new Point3f(point3fArray8[5]);
                point3fArray2[0][7] = new Point3f(point3f62);
                point3fArray2[0][8] = new Point3f(point3fArray4[0][4]);
                point3fArray2[0][9] = new Point3f(point3fArray8[0]);
                point3fArray2[0][10] = new Point3f(point3fArray8[2]);
                point3fArray2[0][11] = new Point3f(point3f67);
                point3fArray2[0][12] = new Point3f(point3f53);
                point3fArray2[0][13] = new Point3f(point3f61);
                point3fArray2[0][14] = new Point3f(point3f65);
                point3fArray2[0][15] = new Point3f(point3f70);
                point3fArray2[1][0] = new Point3f(point3fArray4[2][0]);
                point3fArray2[1][1] = new Point3f(point3fArray4[2][1]);
                point3fArray2[1][2] = new Point3f(point3fArray4[2][2]);
                point3fArray2[1][3] = new Point3f(point3fArray4[2][3]);
                point3fArray2[1][4] = new Point3f(point3fArray4[1][5]);
                point3fArray2[1][5] = Functions.parallelogram(point3fArray4[2][0], point3fArray4[2][1], point3fArray4[1][5]);
                point3fArray2[1][6] = new Point3f(point3fArray8[8]);
                point3fArray2[1][7] = new Point3f(point3f63);
                point3fArray2[1][8] = new Point3f(point3fArray4[1][4]);
                point3fArray2[1][9] = new Point3f(point3fArray8[4]);
                point3fArray2[1][10] = new Point3f(point3fArray8[6]);
                point3fArray2[1][11] = new Point3f(point3f69);
                point3fArray2[1][12] = new Point3f(point3f56);
                point3fArray2[1][13] = new Point3f(point3f62);
                point3fArray2[1][14] = new Point3f(point3f67);
                point3fArray2[1][15] = new Point3f(point3f70);
                point3fArray2[2][0] = new Point3f(point3fArray4[0][0]);
                point3fArray2[2][1] = new Point3f(point3fArray4[0][1]);
                point3fArray2[2][2] = new Point3f(point3fArray4[0][2]);
                point3fArray2[2][3] = new Point3f(point3fArray4[0][3]);
                point3fArray2[2][4] = new Point3f(point3fArray4[2][5]);
                point3fArray2[2][5] = Functions.parallelogram(point3fArray4[0][0], point3fArray4[0][1], point3fArray4[2][5]);
                point3fArray2[2][6] = new Point3f(point3fArray8[1]);
                point3fArray2[2][7] = new Point3f(point3f61);
                point3fArray2[2][8] = new Point3f(point3fArray4[2][4]);
                point3fArray2[2][9] = new Point3f(point3fArray8[7]);
                point3fArray2[2][10] = new Point3f(point3fArray8[3]);
                point3fArray2[2][11] = new Point3f(point3f65);
                point3fArray2[2][12] = new Point3f(point3f59);
                point3fArray2[2][13] = new Point3f(point3f63);
                point3fArray2[2][14] = new Point3f(point3f69);
                point3fArray2[2][15] = new Point3f(point3f70);
                break;
            }
            case 6: {
                int n = -1;
                int n2 = 0;
                while (n2 < 6) {
                    if (n == -1 && this.acpPoint[n2].getHead().getStack().length > 2) {
                        n = n2;
                    }
                    n2 += 2;
                }
                if (n != -1) {
                    Patch.shift(point3fArray, (n /= 2) * 3 + 3);
                }
                point3fArray2 = new Point3f[1][16];
                point3fArray2[0][0] = point3fArray[0];
                point3fArray2[0][1] = point3fArray[1];
                point3fArray2[0][2] = point3fArray[2];
                point3fArray2[0][3] = point3fArray[3];
                point3fArray2[0][7] = point3fArray[4];
                point3fArray2[0][11] = point3fArray[5];
                point3fArray2[0][8] = point3fArray[7];
                point3fArray2[0][4] = point3fArray[8];
                float f = 0.001f;
                point3fArray2[0][15] = Bezier.evaluate(point3fArray[3], point3fArray[4], point3fArray[5], point3fArray[6], 1.0f - f);
                point3fArray2[0][12] = Bezier.evaluate(point3fArray[0], point3fArray[8], point3fArray[7], point3fArray[6], 1.0f - f);
                point3fArray2[0][13] = new Point3f();
                point3fArray2[0][14] = new Point3f();
                if (n != -1) {
                    Vector3f vector3f4 = new Vector3f(point3fArray2[0][1]);
                    vector3f4.sub(point3fArray2[0][0]);
                    Vector3f vector3f5 = new Vector3f(point3fArray2[0][2]);
                    vector3f5.sub(point3fArray2[0][3]);
                    Vector3f vector3f6 = new Vector3f();
                    vector3f6.set(vector3f4);
                    vector3f6.scale(0.6666667f);
                    point3fArray2[0][5] = new Point3f(point3fArray2[0][4]);
                    point3fArray2[0][5].add(vector3f6);
                    vector3f6.set(vector3f5);
                    vector3f6.scale(0.6666667f);
                    point3fArray2[0][6] = new Point3f(point3fArray2[0][7]);
                    point3fArray2[0][6].add(vector3f6);
                    vector3f6.set(vector3f4);
                    vector3f6.scale(0.33333334f);
                    point3fArray2[0][9] = new Point3f(point3fArray2[0][8]);
                    point3fArray2[0][9].add(vector3f6);
                    vector3f6.set(vector3f5);
                    vector3f6.scale(0.33333334f);
                    point3fArray2[0][10] = new Point3f(point3fArray2[0][11]);
                    point3fArray2[0][10].add(vector3f6);
                    vector3f6.set(vector3f4);
                    vector3f6.scale(f);
                    point3fArray2[0][13] = new Point3f(point3fArray2[0][12]);
                    point3fArray2[0][13].add(vector3f6);
                    vector3f6.set(vector3f5);
                    vector3f6.scale(f);
                    point3fArray2[0][14] = new Point3f(point3fArray2[0][15]);
                    point3fArray2[0][14].add(vector3f6);
                    break;
                }
                point3fArray2[0][13].interpolate(point3fArray2[0][12], point3fArray2[0][15], 0.6666667f);
                point3fArray2[0][14].interpolate(point3fArray2[0][12], point3fArray2[0][15], 0.6666667f);
                BezierPatch.computeInnerControlPoints(point3fArray2[0]);
                Point3f point3f74 = Functions.parallelogram(point3fArray[6], point3fArray[5], point3fArray[7]);
                point3fArray2[0][9].interpolate(point3fArray2[0][8], point3f74, 0.6666667f);
                point3fArray2[0][10].interpolate(point3fArray2[0][11], point3f74, 0.6666667f);
                break;
            }
        }
        return point3fArray2;
    }

    private final /* synthetic */ void this() {
        this.bDynamic = false;
        this.bValid = true;
    }

    public Patch(ControlPoint[] controlPointArray) {
        this.this();
        this.acpPoint = controlPointArray;
        if (MainFrame.getInstance() != null) {
            this.material = MainFrame.getInstance().getModel().getMaterial(0);
        }
    }

    static {
        int n = 0;
        while (n < 9) {
            Patch.ap3CoonsPatch9[n++] = new Point3f();
        }
        n = 0;
        while (n < 12) {
            Patch.ap3CoonsPatch12[n++] = new Point3f();
        }
        n = 0;
        while (n < 15) {
            Patch.ap3CoonsPatch15[n++] = new Point3f();
        }
        n = 0;
        while (n < 16) {
            Patch.aap3Patches1[0][n++] = new Point3f();
        }
    }
}

