/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import jpatch.boundary.JPatchSettings;
import jpatch.entity.AnimLight;
import jpatch.entity.AnimModel;
import jpatch.entity.Camera;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.Model;
import jpatch.renderer.AbstractRenderer;
import jpatch.renderer.PatchTesselator3;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RibRenderer3 {
    private BufferedWriter file;
    private List animModels;
    private List lights;
    private Camera camera;
    private PatchTesselator3 patchTesselator;

    public void writeToFile(File file, String string) {
        JPatchSettings jPatchSettings = JPatchSettings.getInstance();
        try {
            Object object;
            String[] stringArray = new String[]{"box", "triangle", "catmullrom", "gaussian", "sinc"};
            float f = jPatchSettings.fRenderAspectHeight / jPatchSettings.fRenderAspectWidth;
            float f2 = (float)jPatchSettings.iRenderWidth / (float)jPatchSettings.iRenderHeight * f;
            float[] fArray = jPatchSettings.cBackgroundColor.getRGBColorComponents(new float[3]);
            this.file = new BufferedWriter(new FileWriter(file));
            this.file.write("##RenderMan RIB-Structure 1.1\n");
            this.file.write("##Creator JPatch pre0.4 development version - http://www.jpatch.com\n");
            this.file.write("\n\n");
            this.file.write("FrameBegin 1\n");
            this.file.write("\n");
            this.file.write("Display \"" + string + "\" \"tiff\" \"rgb\" \"string compression\" \"none\" \n");
            this.file.write("Format " + jPatchSettings.iRenderWidth + ' ' + jPatchSettings.iRenderHeight + ' ' + f2 + '\n');
            this.file.write("PixelSamples " + jPatchSettings.ribSettings.iPixelSamplesX + ' ' + jPatchSettings.ribSettings.iPixelSamplesX + '\n');
            this.file.write("PixelFilter \"" + stringArray[jPatchSettings.ribSettings.iPixelFilter] + "\" " + jPatchSettings.ribSettings.iPixelFilterX + ' ' + jPatchSettings.ribSettings.iPixelFilterY + '\n');
            this.file.write("ShadingRate " + jPatchSettings.ribSettings.fShadingRate + '\n');
            if (jPatchSettings.ribSettings.iShadingInterpolation == 0) {
                this.file.write("ShadingInterpolation \"constant\"\n");
            } else {
                this.file.write("ShadingInterpolation \"smooth\"\n");
            }
            this.file.write("\n");
            this.file.write("Imager \"background\" \"color background\" [" + fArray[0] + ' ' + fArray[1] + ' ' + fArray[2] + "]\n");
            this.file.write("\n");
            Matrix4d matrix4d = new Matrix4d(this.camera.getTransform());
            matrix4d.invert();
            this.file.write("Projection \"perspective\" \"fov\" [" + this.camera.getFieldOfView() + "]\n");
            this.file.write("ScreenWindow -1 1 " + -f + ' ' + f + '\n');
            this.file.write("Transform [" + matrix4d.m00 + ' ' + matrix4d.m10 + ' ' + matrix4d.m20 + ' ' + matrix4d.m30 + ' ' + matrix4d.m01 + ' ' + matrix4d.m11 + ' ' + matrix4d.m21 + ' ' + matrix4d.m31 + ' ' + matrix4d.m02 + ' ' + matrix4d.m12 + ' ' + matrix4d.m22 + ' ' + matrix4d.m32 + ' ' + matrix4d.m03 + ' ' + matrix4d.m13 + ' ' + matrix4d.m23 + ' ' + matrix4d.m33 + "]\n");
            this.file.write("Orientation \"rh\"\n");
            this.file.write("\n");
            this.file.write("WorldBegin\n");
            this.file.write("\n");
            int n = 0;
            int n2 = this.lights.size();
            while (n < n2) {
                object = (AnimLight)this.lights.get(n);
                if (((AnimLight)object).isActive()) {
                    this.file.write(RibRenderer3.light((AnimLight)object));
                }
                ++n;
            }
            this.file.write("\n");
            Iterator iterator = this.animModels.iterator();
            while (iterator.hasNext()) {
                int n3;
                Object object2;
                PatchTesselator3.Vertex[] vertexArray;
                Object object3;
                AnimModel animModel = (AnimModel)iterator.next();
                object = animModel.getModel();
                Matrix4d matrix4d2 = animModel.getTransform();
                this.file.write("TransformBegin\n");
                this.file.write("Transform [" + matrix4d2.m00 + ' ' + matrix4d2.m10 + ' ' + matrix4d2.m20 + ' ' + matrix4d2.m30 + ' ' + matrix4d2.m01 + ' ' + matrix4d2.m11 + ' ' + matrix4d2.m21 + ' ' + matrix4d2.m31 + ' ' + matrix4d2.m02 + ' ' + matrix4d2.m12 + ' ' + matrix4d2.m22 + ' ' + matrix4d2.m32 + ' ' + matrix4d2.m03 + ' ' + matrix4d2.m13 + ' ' + matrix4d2.m23 + ' ' + matrix4d2.m33 + "]\n");
                this.file.write("\n");
                if (JPatchSettings.getInstance().ribSettings.iOutputMode != 3) {
                    int n4 = JPatchSettings.getInstance().ribSettings.iSubdivMode + animModel.getSubdivisionOffset();
                    if (n4 < 2) {
                        n4 = 2;
                    }
                    if (n4 > 5) {
                        n4 = 5;
                    }
                    boolean bl = false;
                    if (JPatchSettings.getInstance().ribSettings.iOutputMode != 2) {
                        bl = true;
                    }
                    this.patchTesselator.tesselate((Model)object, n4, null, bl);
                    object3 = ((Model)object).getMaterialList().iterator();
                    while (object3.hasNext()) {
                        JPatchMaterial jPatchMaterial = (JPatchMaterial)object3.next();
                        vertexArray = this.patchTesselator.getPerMaterialVertexArray(jPatchMaterial);
                        if (vertexArray.length <= 0) continue;
                        this.file.write(animModel.getRenderString("renderman", ""));
                        this.file.write("AttributeBegin\n");
                        this.file.write(AbstractRenderer.shader(jPatchMaterial.getMaterialProperties(), jPatchMaterial.getRenderString("renderman", "")));
                        switch (JPatchSettings.getInstance().ribSettings.iOutputMode) {
                            case 0: {
                                this.file.write("PointsPolygons [");
                                object2 = this.patchTesselator.getPerMaterialTriangleArray();
                                int n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    this.file.write("3 ");
                                    ++n5;
                                }
                                this.file.write("]\n[");
                                n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    this.file.write("" + (int)object2[n5][0] + ' ' + (int)object2[n5][1] + ' ' + (int)object2[n5][2] + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"P\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].p.x + ' ' + vertexArray[n5].p.y + ' ' + vertexArray[n5].p.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"vertex point Pref\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].r.x + ' ' + vertexArray[n5].r.y + ' ' + vertexArray[n5].r.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"N\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].n.x + ' ' + vertexArray[n5].n.y + ' ' + vertexArray[n5].n.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n");
                                break;
                            }
                            case 1: {
                                this.file.write("PointsPolygons [");
                                object2 = this.patchTesselator.getPerMaterialQuadArray();
                                int n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    this.file.write("" + object2[n5].length + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n[");
                                n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    n3 = 0;
                                    while (n3 < object2[n5].length) {
                                        this.file.write("" + (int)object2[n5][n3] + ' ');
                                        ++n3;
                                    }
                                    ++n5;
                                }
                                this.file.write("]\n\"P\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].p.x + ' ' + vertexArray[n5].p.y + ' ' + vertexArray[n5].p.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"vertex point Pref\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].r.x + ' ' + vertexArray[n5].r.y + ' ' + vertexArray[n5].r.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"N\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].n.x + ' ' + vertexArray[n5].n.y + ' ' + vertexArray[n5].n.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n");
                                break;
                            }
                            case 2: {
                                this.file.write("SubdivisionMesh \"catmull-clark\" [ ");
                                object2 = this.patchTesselator.getPerMaterialQuadArray();
                                int n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    this.file.write("" + object2[n5].length + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n[");
                                n5 = 0;
                                while (n5 < ((Point3f[][])object2).length) {
                                    n3 = 0;
                                    while (n3 < object2[n5].length) {
                                        this.file.write("" + (int)object2[n5][n3] + ' ');
                                        ++n3;
                                    }
                                    ++n5;
                                }
                                this.file.write("]\n[\"interpolateboundary\"] [0 0] [] [] \"P\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].p.x + ' ' + vertexArray[n5].p.y + ' ' + vertexArray[n5].p.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n\"vertex point Pref\" [");
                                n5 = 0;
                                while (n5 < vertexArray.length) {
                                    this.file.write("" + vertexArray[n5].r.x + ' ' + vertexArray[n5].r.y + ' ' + vertexArray[n5].r.z + ' ');
                                    ++n5;
                                }
                                this.file.write("]\n");
                                break;
                            }
                        }
                        this.file.write("AttributeEnd\n\n");
                    }
                } else {
                    this.file.write("Basis \"bezier\" 3 \"bezier\" 3\n");
                    Iterator iterator2 = ((Model)object).getMaterialList().iterator();
                    while (iterator2.hasNext()) {
                        object3 = (JPatchMaterial)iterator2.next();
                        boolean bl = false;
                        vertexArray = ((Model)object).getFirstPatch();
                        while (vertexArray != null) {
                            if (vertexArray.getMaterial() == object3) {
                                if (!bl) {
                                    this.file.write(animModel.getRenderString("renderman", ""));
                                    this.file.write("AttributeBegin\n");
                                    this.file.write(AbstractRenderer.shader(((JPatchMaterial)object3).getMaterialProperties(), ((JPatchMaterial)object3).getRenderString("renderman", "")));
                                    bl = true;
                                }
                                object2 = vertexArray.bicubicPatches();
                                Point3f[][] point3fArray = vertexArray.bicubicReferencePatches();
                                n3 = 0;
                                while (n3 < ((Point3f[][])object2).length) {
                                    Point3f[] point3fArray2 = object2[n3];
                                    this.file.write("Patch \"bicubic\" \"P\" [");
                                    String string2 = "";
                                    int n6 = 0;
                                    while (n6 < 16) {
                                        string2 = string2 + point3fArray2[n6].x + ' ' + point3fArray2[n6].y + ' ' + point3fArray2[n6].z;
                                        if (n6 != 15) {
                                            string2 = string2 + ' ';
                                        }
                                        ++n6;
                                    }
                                    this.file.write(string2 + "]\n");
                                    if (point3fArray != null) {
                                        point3fArray2 = point3fArray[n3];
                                        this.file.write("\"vertex point Pref\" [");
                                        string2 = "";
                                        n6 = 0;
                                        while (n6 < 16) {
                                            string2 = string2 + point3fArray2[n6].x + ' ' + point3fArray2[n6].y + ' ' + point3fArray2[n6].z;
                                            if (n6 != 15) {
                                                string2 = string2 + ' ';
                                            }
                                            ++n6;
                                        }
                                        this.file.write(string2 + "]\n");
                                    }
                                    ++n3;
                                }
                            }
                            vertexArray = vertexArray.getNext();
                        }
                        if (!bl) continue;
                        this.file.write("AttributeEnd\n");
                    }
                }
                this.file.write("TransformEnd\n\n");
            }
            this.file.write("WorldEnd\n");
            this.file.write("FrameEnd\n");
            this.file.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private static final String toRibVector(Tuple3d tuple3d) {
        return "[" + tuple3d.x + ' ' + tuple3d.y + ' ' + tuple3d.z + ']';
    }

    private static final String toRibVector(Tuple3f tuple3f) {
        return "[" + tuple3f.x + ' ' + tuple3f.y + ' ' + tuple3f.z + ']';
    }

    public static String light(AnimLight animLight) {
        String string = animLight.getRenderString("renderman", "");
        string = AbstractRenderer.light(animLight, string);
        string = string.replaceAll("\\$position", RibRenderer3.toRibVector(animLight.getPosition()));
        string = string.replaceAll("\\$color", RibRenderer3.toRibVector(animLight.getColor()));
        return string;
    }

    private final /* synthetic */ void this() {
        this.patchTesselator = new PatchTesselator3();
    }

    public RibRenderer3(List list, Camera camera, List list2) {
        this.this();
        this.animModels = list;
        this.camera = camera;
        this.lights = list2;
    }
}

