/*
 * Decompiled with CFR 0.152.
 */
package jpatch.renderer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import jpatch.boundary.JPatchTreeLeaf;
import jpatch.boundary.MainFrame;
import jpatch.entity.JPatchMaterial;
import jpatch.entity.MaterialProperties;
import jpatch.entity.Model;
import jpatch.renderer.PatchTesselator3;

public class WavefrontExport3 {
    public static final int TRIANGLES = 0;
    public static final int QUADS = 1;

    public void writeToFile(File file, File file2, int n, boolean bl, int n2) {
        Object object;
        Object object2;
        Object object3;
        BufferedWriter bufferedWriter;
        Model model = MainFrame.getInstance().getModel();
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            bufferedWriter.write("#generated with JPatch (http://www.jpatch.com)");
            bufferedWriter.newLine();
            object3 = model.getMaterialList().iterator();
            while (object3.hasNext()) {
                float f;
                object2 = (JPatchMaterial)object3.next();
                object = ((JPatchMaterial)object2).getMaterialProperties();
                bufferedWriter.newLine();
                bufferedWriter.write("newmtl " + ((JPatchTreeLeaf)object2).getName().replace(' ', '_'));
                bufferedWriter.newLine();
                bufferedWriter.write("Ka " + ((MaterialProperties)object).red * ((MaterialProperties)object).ambient + ' ' + ((MaterialProperties)object).green * ((MaterialProperties)object).ambient + ' ' + ((MaterialProperties)object).blue * ((MaterialProperties)object).ambient);
                bufferedWriter.newLine();
                bufferedWriter.write("Kd " + ((MaterialProperties)object).red * ((MaterialProperties)object).diffuse + ' ' + ((MaterialProperties)object).green * ((MaterialProperties)object).diffuse + ' ' + ((MaterialProperties)object).blue * ((MaterialProperties)object).diffuse);
                bufferedWriter.newLine();
                if (((MaterialProperties)object).specular != 0.0f) {
                    bufferedWriter.write("Ks " + ((MaterialProperties)object).specular * (1.0f - ((MaterialProperties)object).metallic * (1.0f - ((MaterialProperties)object).red)) + ' ' + ((MaterialProperties)object).specular * (1.0f - ((MaterialProperties)object).metallic * (1.0f - ((MaterialProperties)object).green)) + ' ' + ((MaterialProperties)object).specular * (1.0f - ((MaterialProperties)object).metallic * (1.0f - ((MaterialProperties)object).blue)));
                    bufferedWriter.newLine();
                    bufferedWriter.write("Ns " + ((MaterialProperties)object).roughness);
                    bufferedWriter.newLine();
                }
                if ((f = 1.0f - (((MaterialProperties)object).transmit + ((MaterialProperties)object).filter) / 2.0f) == 1.0f) continue;
                bufferedWriter.write("d " + f);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = new PatchTesselator3();
        ((PatchTesselator3)object3).tesselate(model, n, null, bl);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("#generated with JPatch (http://www.jpatch.com)");
            bufferedWriter.newLine();
            bufferedWriter.write("mtllib " + file2.getName());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            object2 = new StringBuffer();
            object = new StringBuffer();
            PatchTesselator3.Vertex[] vertexArray = ((PatchTesselator3)object3).getVertexArray();
            int n3 = 0;
            while (n3 < vertexArray.length) {
                ((StringBuffer)object2).append("v " + vertexArray[n3].p.x + ' ' + vertexArray[n3].p.y + ' ' + -vertexArray[n3].p.z + '\n');
                if (bl) {
                    ((StringBuffer)object).append("vn " + vertexArray[n3].n.x + ' ' + vertexArray[n3].n.y + ' ' + -vertexArray[n3].n.z + '\n');
                }
                ++n3;
            }
            bufferedWriter.write(((StringBuffer)object2).toString());
            if (bl) {
                bufferedWriter.write(((StringBuffer)object).toString());
            }
            Iterator iterator = model.getMaterialList().iterator();
            block10: while (iterator.hasNext()) {
                JPatchMaterial jPatchMaterial = (JPatchMaterial)iterator.next();
                bufferedWriter.write("usemtl " + jPatchMaterial.getName().replace(' ', '_'));
                bufferedWriter.newLine();
                switch (n2) {
                    case 0: {
                        int[][] nArray = ((PatchTesselator3)object3).getMaterialTriangleArray(jPatchMaterial);
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            if (bl) {
                                bufferedWriter.write("f " + (nArray[n4][0] + 1) + '/' + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + '/' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + '/' + (nArray[n4][2] + 1) + '\n');
                            } else {
                                bufferedWriter.write("f " + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + '\n');
                            }
                            ++n4;
                        }
                        continue block10;
                    }
                    case 1: {
                        int[][] nArray = ((PatchTesselator3)object3).getMaterialQuadArray(jPatchMaterial);
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            if (nArray[n4].length == 3) {
                                if (bl) {
                                    bufferedWriter.write("f " + (nArray[n4][0] + 1) + '/' + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + '/' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + '/' + (nArray[n4][2] + 1) + '\n');
                                } else {
                                    bufferedWriter.write("f " + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + '\n');
                                }
                            } else if (bl) {
                                bufferedWriter.write("f " + (nArray[n4][0] + 1) + '/' + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + '/' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + '/' + (nArray[n4][2] + 1) + ' ' + (nArray[n4][3] + 1) + '/' + (nArray[n4][3] + 1) + '\n');
                            } else {
                                bufferedWriter.write("f " + (nArray[n4][0] + 1) + ' ' + (nArray[n4][1] + 1) + ' ' + (nArray[n4][2] + 1) + ' ' + (nArray[n4][3] + 1) + '\n');
                            }
                            ++n4;
                        }
                        continue block10;
                    }
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }
}

