/*
 * Decompiled with CFR 0.152.
 */
package jpatch.test;

import java.util.ArrayList;
import java.util.Iterator;
import jpatch.boundary.JPatchTreeLeaf;
import jpatch.boundary.selection.PointSelection;
import jpatch.entity.ControlPoint;
import jpatch.entity.Curve;
import jpatch.entity.Model;
import jpatch.entity.Morph;
import jpatch.entity.Patch;

public class ModelTester {
    private ArrayList listCurves;
    private ArrayList listControlPoints;
    private ArrayList listPatches;
    private boolean bSuccess;

    public boolean test(Model model) {
        int n;
        Object object;
        Object object2;
        Object object3;
        this.bSuccess = true;
        this.listCurves = new ArrayList();
        this.listControlPoints = new ArrayList();
        Curve curve = model.getFirstCurve();
        while (curve != null) {
            this.listCurves.add(curve);
            object3 = curve.getStart();
            while (object3 != null) {
                this.listControlPoints.add(object3);
                object3 = ((ControlPoint)object3).getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        System.out.println(this.listCurves.size() + " curves");
        System.out.println(this.listControlPoints.size() + " control points");
        curve = model.getFirstCurve();
        while (curve != null) {
            if (curve.getModel() != model) {
                this.error("curve " + curve + " model is " + curve.getModel());
            }
            if ((object3 = curve.getStart()) == null) {
                this.error("Curve start for " + curve + " points to null");
                break;
            }
            if (((ControlPoint)object3).getPrev() != null && !((ControlPoint)object3).getLoop()) {
                this.error("Start of curve " + curve + " is not the first cp, but loop is false");
                break;
            }
            if (((ControlPoint)object3).getNext() == null) {
                this.error("Curve " + curve + " has just one controlPoint");
                break;
            }
            object2 = ((ControlPoint)object3).getPrev();
            while (object3 != null) {
                if (((ControlPoint)object3).getCurve() != curve) {
                    this.error("Cp " + object3 + " curve pointer points to wrong curve");
                }
                if (((ControlPoint)object3).getPrev() != object2) {
                    this.error("Cp " + object3 + " cpLast pointer is wrong");
                }
                if (((ControlPoint)object3).getLoop() && object3 != curve.getStart()) {
                    this.error("Cp " + object3 + " has loop flag set but is not start of curve!");
                }
                if (((ControlPoint)object3).getNextAttached() != null && !this.listControlPoints.contains(((ControlPoint)object3).getNextAttached())) {
                    this.error("Cp " + object3 + " cpNextAttached is unknown");
                }
                if (((ControlPoint)object3).getPrevAttached() != null && !this.listControlPoints.contains(((ControlPoint)object3).getPrevAttached())) {
                    this.error("Cp " + object3 + " cpPrevAttached is unknown");
                }
                if (((ControlPoint)object3).getParentHook() != null && !this.listControlPoints.contains(((ControlPoint)object3).getParentHook())) {
                    this.error("Cp " + object3 + " cpParentHook is unknown");
                }
                if (((ControlPoint)object3).getChildHook() != null && !this.listControlPoints.contains(((ControlPoint)object3).getChildHook())) {
                    this.error("Cp " + object3 + " cpChildHook is unknown");
                }
                if (((ControlPoint)object3).getNextAttached() != null && ((ControlPoint)object3).getNextAttached().getHookPos() != -1.0f) {
                    if (((ControlPoint)object3).getPrevAttached() != null) {
                        this.error("Target-Hook " + object3 + " has cpPrev!");
                    }
                    if (((ControlPoint)object3).getNext() != null && ((ControlPoint)object3).getPrev() != null) {
                        this.error("Target-Hook " + object3 + " is not start or end of curve");
                    }
                }
                if (((ControlPoint)object3).getChildHook() != null && ((ControlPoint)object3).getChildHook().getParentHook() != object3) {
                    this.error("Child hook of " + object3 + " does not point back!");
                }
                if (((ControlPoint)object3).getHookPos() != -1.0f) {
                    if (((ControlPoint)object3).getHookPos() == 0.0f) {
                        object = ((ControlPoint)object3).getParentHook();
                        if (((ControlPoint)object3).getPrev() != null) {
                            this.error("Start-Hook " + object3 + " is not start of curve!");
                        }
                        if (object == null) {
                            this.error("Start-Hook " + object3 + " has no parent hook!");
                        } else {
                            if (((ControlPoint)object).getChildHook() != object3) {
                                this.error("Start-Hook " + object3 + ": parent hook does not point back to us");
                            }
                            if (((ControlPoint)object3).getEnd().getParentHook() != ((ControlPoint)object).getNext()) {
                                this.error("Hook curve " + curve + ": parent hook of curve end is wrong");
                            }
                        }
                    } else if (((ControlPoint)object3).getHookPos() == 1.0f && ((ControlPoint)object3).getParentHook() == null) {
                        this.error("End-Hook " + object3 + " has no parent hook!");
                    }
                } else if (((ControlPoint)object3).getParentHook() != null) {
                    this.error("cp " + object3 + " is not a hook, but parentHook is not null");
                }
                object2 = object3;
                object3 = ((ControlPoint)object3).getNextCheckNextLoop();
            }
            curve = curve.getNext();
        }
        int n2 = 0;
        object3 = model.getSelectionIterator();
        while (object3.hasNext()) {
            object2 = (PointSelection)object3.next();
            object = ((PointSelection)object2).getControlPointArray();
            n = 0;
            while (n < ((ControlPoint[])object).length) {
                if (!this.listControlPoints.contains(object[n])) {
                    this.error("cp " + object[n] + " of selection " + ((JPatchTreeLeaf)object2).getName() + " is invalid");
                }
                if (!object[n].isHead()) {
                    this.error("cp " + object[n] + " of selection " + ((JPatchTreeLeaf)object2).getName() + " is not a head");
                }
                ++n;
            }
            ++n2;
        }
        System.out.println(n2 + " selections");
        int n3 = 0;
        object2 = model.getFirstPatch();
        while (object2 != null) {
            object = ((Patch)object2).getControlPoints();
            n = 0;
            while (n < ((ControlPoint[])object).length) {
                if (!this.listControlPoints.contains(object[n])) {
                    this.error("cp " + object[n] + " in patch " + object2 + " is invalid");
                }
                ++n;
            }
            ++n3;
            object2 = ((Patch)object2).getNext();
        }
        System.out.println(n3 + " patches");
        int n4 = 0;
        object = model.getMorphIterator();
        while (object.hasNext()) {
            Morph morph = (Morph)object.next();
            Iterator iterator = morph.getPointList().iterator();
            while (iterator.hasNext()) {
                ControlPoint controlPoint = (ControlPoint)iterator.next();
                if (!this.listControlPoints.contains(controlPoint)) {
                    this.error("cp " + controlPoint + " of morph " + morph.getName() + " is invalid");
                }
                if (controlPoint.isHead()) continue;
                this.error("cp " + controlPoint + " of morph " + morph.getName() + " is not a head");
            }
            ++n4;
        }
        System.out.println(n4 + " morphs");
        return this.bSuccess;
    }

    private final void error(String string) {
        System.err.println(string);
        this.bSuccess = false;
    }
}

