/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import patterns.AbstractPattern;
import patterns.Functions;
import patterns.RampUp;
import patterns.Slope;

public class FbmNoise
extends AbstractPattern {
    private final Slope slope;
    private final int iOctaves;
    private final float fLacunarity;
    private final float fGain;
    private final float fAtt;

    public FbmNoise(int octaves) {
        this(new RampUp(), octaves, 2.0f, 0.5f);
    }

    public FbmNoise(int octaves, float lacunarity, float gain) {
        this(new RampUp(), octaves, lacunarity, gain);
    }

    public FbmNoise(Slope slope, int octaves) {
        this(slope, octaves, 2.0f, 0.5f);
    }

    public FbmNoise(Slope slope, int octaves, float lacunarity, float gain) {
        this.slope = slope;
        this.iOctaves = octaves;
        this.fLacunarity = lacunarity;
        this.fGain = gain;
        this.fAtt = 0.5f / (2.0f - (float)Math.pow(gain, octaves - 1));
    }

    public float valueAt(float x, float y, float z) {
        return this.slope.valueAt(0.5f + this.fAtt * Functions.fBm3f(x, y, z, this.iOctaves, this.fLacunarity, this.fGain));
    }
}

