/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import patterns.Pattern;
import patterns.Vector3D;

public class PatternNormal3D
implements Vector3D {
    private Pattern pattern;
    private float epsilon = 1.0E-4f;
    private Point3f point = new Point3f();
    private Matrix4f m4Transform = new Matrix4f();
    private float size;

    public PatternNormal3D(Matrix4f transform, Pattern pattern, float size) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.size = size;
        this.m4Transform.set(transform);
    }

    public void transform(Matrix4f matrix) {
        this.m4Transform.mul(matrix);
    }

    public Vector3f vectorAt(float x, float y, float z) {
        this.point.set(x, y, z);
        this.m4Transform.transform(this.point);
        float f = this.pattern.valueAt(this.point.x, this.point.y, this.point.z);
        float dx = (this.pattern.valueAt(this.point.x + this.epsilon, this.point.y, this.point.z) - f) / this.epsilon;
        float dy = (this.pattern.valueAt(this.point.x, this.point.y + this.epsilon, this.point.z) - f) / this.epsilon;
        float dz = (this.pattern.valueAt(this.point.x, this.point.y, this.point.z + this.epsilon) - f) / this.epsilon;
        Vector3f v = new Vector3f(dx, dy, dz);
        v.scale(this.size);
        return v;
    }
}

