/*
 * Decompiled with CFR 0.152.
 */
package patterns;

import javax.vecmath.Color3f;
import patterns.ObjectMap;
import patterns.Pigment3D;

public class PigmentMap
extends ObjectMap {
    public void addEntry(float position, Pigment3D pigment) {
        super.addEntry(position, pigment);
    }

    public Color3f colorAt(float position, float x, float y, float z) {
        if (this.iState != 2) {
            throw new IllegalStateException("This colormap is not complete");
        }
        if (position <= 0.0f) {
            return ((Pigment3D)this.map[0].object).colorAt(x, y, z);
        }
        if (position >= 1.0f) {
            return ((Pigment3D)this.map[this.map.length - 1].object).colorAt(x, y, z);
        }
        int i = this.lowIndex(position);
        float a = this.map[i].position;
        float b = this.map[i + 1].position;
        float s = (position - a) / (b - a);
        Color3f ca = ((Pigment3D)this.map[i].object).colorAt(x, y, z);
        Color3f cb = ((Pigment3D)this.map[i + 1].object).colorAt(x, y, z);
        return new Color3f(ca.x + s * (cb.x - ca.x), ca.y + s * (cb.y - ca.y), ca.z + s * (cb.z - ca.z));
    }
}

