#version unofficial MegaPov 1.10;

#declare matMarble = material {
        texture {
                pigment {
                        marble
                        turbulence 0.5
                        rotate <5,5,5>
                        scale <1,5,1>
                        rotate <10,-10,0>
                        color_map {
                                [0.0 color rgb <0.8,0.5,0.3>]
                                [0.5 color rgb <0.9,0.7,0.6>]
                                [0.8 color rgb <1.0,0.8,0.7>]
                                [0.9 color rgb <0.9,0.9,0.9>]
                                [1.0 color rgb <1.0,1.0,1.0>]
                        }
                }
                finish {
                        ambient 0.1
                        diffuse 0.9
                        brilliance 1.2
                        specular 0.5
                        roughness 0.05
                }
        }
        texture {
                pigment {
                        transmit 1
                }
                finish {
                        reflection {
                                0.1, 0.5
                        }
                        conserve_energy
                }
        }
}

#declare matStairs = material {
	texture {
		pigment {
			bozo	
			turbulence 1
			rotate <5,5,5>
			scale 1
			color_map {
				[0.0 color rgb <0.5,0.5,0.5>]
				[0.5 color rgb <0.7,0.7,0.7>]
				[0.8 color rgb <0.6,0.6,0.6>]
				[0.9 color rgb <0.4,0.4,0.4>]
				[1.0 color rgb <0.3,0.3,0.3>]
			}
		}
		finish {
			ambient 0.1
			diffuse 0.9
			brilliance 1.2
			specular 0.5
			roughness 0.05
		}
	}
	texture {
		pigment {
			transmit 1
		}
		finish {
			reflection {
				0.1, 0.5
			}
			conserve_energy
		}
	}
}
#declare matWoodHor = material {
        texture {
                pigment {
                        marble
                        turbulence 0.5
                        rotate <5,5,5>
                        scale <2,5,2>
                        rotate <20,-20,0>
			rotate <0,90,0>
                        color_map {
                                [0.0 color rgb <0.7,0.35,0.0>]
				[0.2 color rgb <0.72,0.37,0.0>]
                                [0.5 color rgb <0.65,0.30,0.0>]
				[0.65 color rgb <0.67, 0.32, 0.0>]
                                [0.8 color rgb <0.60,0.25,0.0>]
                                [1.0 color rgb <0.40,0.15,0.0>]
                        }
                }
                finish {
                        ambient 0.1
                        diffuse 0.5
                        brilliance 1
                        specular 0.5
                        roughness 0.05
                }
        }
        texture {
                pigment {
                        transmit 1
                }
                finish {
                        reflection {
                                0.0, 0.25
                        }
			conserve_energy		
                }
        }
}
#declare matWood = material {
	texture {
                pigment {
                        marble
                        turbulence 0.5
                        rotate <5,5,5>
                        scale <2,5,2>
                        rotate <20,-20,0>
                        color_map {
                                [0.0 color rgb <0.50,0.20,0.0>]
                                [1.0 color rgb <0.40,0.15,0.0>]
                        }
                }
                finish {
                        ambient 0.05
                        diffuse 0.4
                        brilliance 1
                        specular 0.7
                        roughness 0.03
                }
        }
        texture {
                pigment {
                        transmit 1
                }
                finish {
                        reflection {
                                0.0, 0.10
                        }
			conserve_energy
                }
        }
}
#declare matStone = material {
	texture {
		pigment {
			color rgb <0.9,0.9,0.9>
		}
		normal {
			bumps 0.2
			scale 0.3
			turbulence 0.5
		}
		finish {
			ambient 0.1
			diffuse 0.9
			specular 0.5
			roughness 0.1
		}
	}
}

#declare pigmBlackTile = pigment {
	marble
	turbulence 1 lambda 2.5 omega 0.55
	color_map {
		[0.0 color rgb 0.1]
		[0.2 color rgb 0.2]
		[0.8 color rgb 0.3]
		[1.0 color rgb 0.4]
	}
	scale <2,3,4>
	rotate <30,40,50>
}

#declare pigmWhiteTile = pigment {
        marble
        turbulence 1 lambda 2.5 omega 0.55
        color_map {
                [0.0 color rgb 1.0]
                [0.2 color rgb 0.9]
                [0.8 color rgb 0.8]
                [1.0 color rgb 0.7]
        }
	scale <2,3,4>
	rotate <10,20,30>
}

#declare txTiles = texture {
	 pigment {
                uv_mapping
                checker
                pigment { pigmWhiteTile } pigment { pigmBlackTile }
                scale 5 * sqrt(2)
                rotate <90,0,0>
                rotate <0,0,45>
        }
        finish {
                ambient 0.1
                diffuse 0.5
		reflection 0.3
                brilliance 1.2
                specular 0.5
                roughness 0.05
        }
}

#declare txReflection = texture {
	pigment {
                transmit 1
        }
        finish {
                reflection {
                       0.0, 0.3
                }
                conserve_energy
       }
}

#declare matTiles = material {
        texture { txTiles }
        //texture { txReflection }
}

#declare txSilver = texture {
	pigment { color rgb 1 }
	finish {
		ambient 0.1
		diffuse 0.1 brilliance 2
		specular 2 roughness 0.01
		reflection 0.8
	}
}

#declare matFloorMorph = material {
	texture {
		gradient y
		texture_map {
			[0.0 txTiles]
			[0.2 txTiles]
			[0.4 txSilver ]
			[1.0 txSilver ]
		}
		translate <0,-0.05,0>
		scale <1,10,1>
	}
}

#declare txChrome = texture {
	pigment { color rgb <1.0, 1.0, 1.0> }
	finish {
		ambient 0.1
		diffuse 0.4 brilliance 1.5
		specular 1 roughness 0.075 metallic 1
		reflection 0.6 metallic 1
	}
}

#declare txRubber = texture {
	pigment { color rgb 0.5 }
	finish {
		ambient 0.1
		diffuse 0.8
		specular 0.5 roughness 0.05
	}
}

#declare txChecker = texture {
	pigment { checker pigment { pigmWhiteTile } pigment { pigmBlackTile }
	rotate <45, 0, 0> scale <1000, 0.025, 2.5> translate <500, 0, 0> }
	translate <0, jpatchFrame / 900, 0>
	finish { ambient 0.5 diffuse 0.5 reflection 0.2 }
}

#declare txGradientChrome = texture {
	gradient y
	texture_map {
		[0.0 txChecker]
		[0.05 txChrome]
		[1.0 txChrome]
	}
	translate <0, -jpatchFrame / 900, 0>
	scale <1, 100, 1>
}

#declare txGradientRubber = texture {
        gradient y
        texture_map {
                [0.0 txChecker]
                [0.05 txRubber]
                [1.0 txRubber]
        }
        translate <0, -jpatchFrame / 900, 0>
        scale <1, 100, 1>
}

#declare matRubber = material { texture { txRubber } }
#declare matWheels = material { texture { txChrome } }
#declare matChassis = material { texture { txChrome } }


#declare matPicture1 = material {
	texture {
		pigment {
			image_map { png "water.png" }
			rotate <0,90,0>
			scale <1,30,40>
			translate <0,-9,20>
		}
		finish {
			ambient 0
			diffuse 1
		}
	}
}
#declare matPicture2 = material {
        texture {
                pigment {
                        image_map { png "waterfall.png" }
                        rotate <0,-90,0>
                        scale <1,30,-40>
			translate <0,-9,-20>
                }
                finish {
                        ambient 0
                        diffuse 1
                }
        }
}
#declare matIrtcLogo = material {
        texture {
                pigment {
                        image_map { png "irtc.png" }
                        rotate <0,180,0>
                        scale <40,20,1>
                        translate <-20,-5,0>
                }
                finish {
                        ambient 0
                        diffuse 1
                }
        }
}
#declare matOutside = material {
	texture {
		pigment {
			gradient y
			color_map {
				[0.0 color rgb <0.2, 0.2, 0.3>]
				[1.0 color rgb <2.0, 2.0, 2.4>]
			}
			scale <1,200,1>
			translate <0,-40,0>
		}
		finish {
			ambient 1
			diffuse 0
		}
	}
}
#declare pigmSkin = pigment {
	color rgb <1.0,0.7,0.6>
}
#declare pigmHair = pigment {
	color rgb <0.3,0.3,0.5>
}
#declare txSkin1 = texture {
	pigment { pigmSkin }
	finish {
		ambient 0.1
		diffuse 0.7 brilliance 0.6
		specular 0.05 roughness 0.1 metallic 0.5
	}
}
#declare txSkin2 = texture {
        pigment { pigmSkin }
        finish {
                ambient 0.3
                diffuse 0.7 brilliance 0.6
                specular 0.05 roughness 0.1 metallic 0.5
        }
}
#declare txSkin3 = texture {
        pigment { color rgb 0.5 + 0.5 * <1.0, 0.7, 0.6>}
        finish {
                ambient 0.9
                diffuse 0.7 brilliance 0.6
                specular 0.05 roughness 0.1 metallic 0.5
        }
}

#declare txHair1 = texture {
        pigment { color rgb <0, 0, 0.5> }
        finish {
                ambient 0.0
                diffuse 0.0
                specular 0.2 roughness 0.1 metallic 1
        }
}
#declare txHair2 = texture {
        pigment { color rgb <0, 0, 0.5> }
        finish {
                ambient 0.5
                diffuse 0.0
                specular 0.2 roughness 0.1 metallic 1
        }
}
#declare txHair3 = texture {
        pigment { color rgb 0.75 }
        finish {
                ambient 1.0
                diffuse 0.0
                specular 0.2 roughness 0.1 metallic 1
        }
}

#declare matSkin = material {
	texture {
		aoi 
		texture_map {
			[0.0 txSkin1 ]
			[0.2 txSkin1 ]
			[0.4 txSkin2 ]
			[0.5 txSkin3 ]
			[1.0 txSkin3 ]
		}
	}
}

#declare matHair = material {
        texture {
                aoi
                texture_map {
                        [0.0 txHair1 ]
                        [0.1 txHair1 ]
			[0.4 txHair2 ]
                        [0.5 txHair3 ]
			[1.0 txHair3 ]
                }
        }
}
#declare matScreen = material {
        texture {
                pigment {
			average
			pigment_map {
				[0.95 image_map { png "screen.png" interpolate 2 once}
                        	rotate <0,0,0>
                        	scale <4,3,1>
                        	translate <-2,2,0>
				]
				[0.05 color rgb 1]
			}
                }
                finish {
                        ambient 1
                        diffuse 0
			specular 0.1 roughness 0.1
                }
        }
}

