/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xpath.axes.ContextNodeList;

public class PrintTraceListener
implements TraceListener {
    PrintWriter m_pw;
    public boolean m_traceTemplates = false;
    public boolean m_traceElements = false;
    public boolean m_traceGeneration = false;
    public boolean m_traceSelection = false;

    public PrintTraceListener(PrintWriter pw) {
        this.m_pw = pw;
    }

    public void generated(GenerateEvent ev) {
        if (this.m_traceGeneration) {
            switch (ev.m_eventtype) {
                case 1: {
                    this.m_pw.println("STARTDOCUMENT");
                    break;
                }
                case 2: {
                    this.m_pw.println("ENDDOCUMENT");
                    break;
                }
                case 3: {
                    this.m_pw.println("STARTELEMENT: " + ev.m_name);
                    break;
                }
                case 4: {
                    this.m_pw.println("ENDELEMENT: " + ev.m_name);
                    break;
                }
                case 5: {
                    String chars = new String(ev.m_characters, ev.m_start, ev.m_length);
                    this.m_pw.println("CHARACTERS: " + chars);
                    break;
                }
                case 10: {
                    String chars = new String(ev.m_characters, ev.m_start, ev.m_length);
                    this.m_pw.println("CDATA: " + chars);
                    break;
                }
                case 8: {
                    this.m_pw.println("COMMENT: " + ev.m_data);
                    break;
                }
                case 7: {
                    this.m_pw.println("PI: " + ev.m_name + ", " + ev.m_data);
                    break;
                }
                case 9: {
                    this.m_pw.println("ENTITYREF: " + ev.m_name);
                    break;
                }
                case 6: {
                    this.m_pw.println("IGNORABLEWHITESPACE");
                    break;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void selected(SelectionEvent ev) throws TransformerException {
        block10: {
            block11: {
                block12: {
                    if (!this.m_traceSelection) break block10;
                    ete = ev.m_styleNode;
                    if (ev.m_styleNode.getLineNumber() == 0) {
                        parent = (ElemTemplateElement)ete.getParentNode();
                        if (parent == ete.getStylesheetRoot().getDefaultRootRule()) {
                            this.m_pw.print("(default root rule) ");
                        } else if (parent == ete.getStylesheetRoot().getDefaultTextRule()) {
                            this.m_pw.print("(default text rule) ");
                        } else if (parent == ete.getStylesheetRoot().getDefaultRule()) {
                            this.m_pw.print("(default rule) ");
                        }
                        this.m_pw.print(String.valueOf(ete.getNodeName()) + ", " + ev.m_attributeName + "='" + ev.m_xpath.getPatternString() + "': ");
                    } else {
                        this.m_pw.print("Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + ": " + ete.getNodeName() + ", " + ev.m_attributeName + "='" + ev.m_xpath.getPatternString() + "': ");
                    }
                    ev.m_selection;
                    if (ev.m_selection.getType() != 4) break block11;
                    this.m_pw.println();
                    nl = ev.m_selection.nodeset();
                    if (!(nl instanceof ContextNodeList)) break block12;
                    try {
                        nl = ((ContextNodeList)nl).cloneWithReset();
                    }
                    catch (CloneNotSupportedException v0) {
                        this.m_pw.println("     [Can't trace nodelist because it it threw a CloneNotSupportedException]");
                        return;
                    }
                    pos = nl.nextNode();
                    if (pos != null) ** GOTO lbl34
                    this.m_pw.println("     [empty node list]");
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        this.m_pw.println("     " + pos);
                        pos = nl.nextNode();
lbl34:
                        // 2 sources

                        ** while (pos != null)
                    }
lbl35:
                    // 1 sources

                    break block10;
                }
                this.m_pw.println("     [Can't trace nodelist because it isn't a ContextNodeList]");
                break block10;
            }
            this.m_pw.println(ev.m_selection.str());
        }
    }

    public void trace(TracerEvent ev) {
        switch (ev.m_styleNode.getXSLToken()) {
            case 78: {
                if (!this.m_traceElements) break;
                this.m_pw.print("Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + " -- " + ev.m_styleNode.getNodeName() + ": ");
                ElemTextLiteral etl = (ElemTextLiteral)ev.m_styleNode;
                String chars = new String(etl.getChars(), 0, etl.getChars().length);
                this.m_pw.println("    " + chars.trim());
                break;
            }
            case 19: {
                if (!this.m_traceTemplates && !this.m_traceElements) break;
                ElemTemplate et = (ElemTemplate)ev.m_styleNode;
                this.m_pw.print("Line #" + et.getLineNumber() + ", " + "Column #" + et.getColumnNumber() + ": " + et.getNodeName() + " ");
                if (et.getMatch() != null) {
                    this.m_pw.print("match='" + et.getMatch().getPatternString() + "' ");
                }
                if (et.getName() != null) {
                    this.m_pw.print("name='" + et.getName() + "' ");
                }
                this.m_pw.println();
                break;
            }
            default: {
                if (!this.m_traceElements) break;
                this.m_pw.println("Line #" + ev.m_styleNode.getLineNumber() + ", " + "Column #" + ev.m_styleNode.getColumnNumber() + ": " + ev.m_styleNode.getNodeName());
            }
        }
    }
}

