/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.TransformerImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class QueuedSAXEvent {
    static final int DOC = 1;
    static final int ELEM = 2;
    protected TraceManager m_traceManager;
    protected TransformerImpl m_transformer;
    protected ContentHandler m_contentHandler;
    public boolean isPending = false;
    public boolean isEnded = false;
    private int m_type;

    public QueuedSAXEvent(int type) {
        this.m_type = type;
    }

    void clearPending() {
        this.isPending = false;
    }

    protected void fireGenerateEvent(int type, String name, Attributes attrs) {
        if (this.m_traceManager != null) {
            GenerateEvent ge = new GenerateEvent(this.m_transformer, type, name, attrs);
            this.m_traceManager.fireGenerateEvent(ge);
        }
    }

    void flush() throws SAXException {
        this.clearPending();
    }

    ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    int getType() {
        return this.m_type;
    }

    void reset() {
        this.isPending = false;
    }

    void setContentHandler(ContentHandler ch) {
        this.m_contentHandler = ch;
    }

    void setPending(boolean b) {
        this.isPending = b;
        this.isEnded = this.isPending ^ true;
    }

    void setTraceManager(TraceManager traceManager) {
        this.m_traceManager = traceManager;
    }

    void setTransformer(TransformerImpl transformer) {
        this.m_transformer = transformer;
    }
}

