/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.Node;

public class ReverseAxesWalker
extends AxesWalker {
    public ReverseAxesWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    protected void countProximityPosition(int i) {
        if (i < this.m_proximityPositions.length) {
            int n = i;
            this.m_proximityPositions[n] = this.m_proximityPositions[n] - 1;
        }
    }

    public int getLastPos(XPathContext xctxt) {
        int count = 0;
        AxesWalker savedWalker = this.m_lpi.getLastUsedWalker();
        try {
            try {
                Node next;
                ReverseAxesWalker clone = (ReverseAxesWalker)this.clone();
                clone.setRoot(this.getRoot());
                clone.setPredicateCount(this.getPredicateCount() - 1);
                clone.setPrevWalker(null);
                clone.setNextWalker(null);
                this.m_lpi.setLastUsedWalker(clone);
                while ((next = clone.nextNode()) != null) {
                    ++count;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            Object var5_6 = null;
            this.m_lpi.setLastUsedWalker(savedWalker);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_lpi.setLastUsedWalker(savedWalker);
            throw throwable;
        }
        return count;
    }

    protected int getProximityPosition(int predicateIndex) {
        if (predicateIndex < 0) {
            return -1;
        }
        if (this.m_proximityPositions[predicateIndex] <= 0) {
            AxesWalker savedWalker = this.m_lpi.getLastUsedWalker();
            try {
                try {
                    Node next;
                    ReverseAxesWalker clone = (ReverseAxesWalker)this.clone();
                    clone.setRoot(this.getRoot());
                    clone.setPredicateCount(predicateIndex);
                    clone.setPrevWalker(null);
                    clone.setNextWalker(null);
                    this.m_lpi.setLastUsedWalker(clone);
                    int count = 1;
                    while ((next = clone.nextNode()) != null) {
                        ++count;
                    }
                    int n = predicateIndex;
                    this.m_proximityPositions[n] = this.m_proximityPositions[n] + count;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                }
                Object var4_6 = null;
                this.m_lpi.setLastUsedWalker(savedWalker);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.m_lpi.setLastUsedWalker(savedWalker);
                throw throwable;
            }
        }
        return this.m_proximityPositions[predicateIndex];
    }

    public boolean isReverseAxes() {
        return true;
    }

    public void setRoot(Node root) {
        super.setRoot(root);
    }
}

