/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.FunctionDef1Arg;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class FuncNormalizeSpace
extends FunctionDef1Arg {
    public XObject execute(XPathContext xctxt) throws TransformerException {
        String s1 = this.getArg0AsString(xctxt);
        return new XString(this.fixWhiteSpace(s1, true, true, false));
    }

    protected String fixWhiteSpace(String string, boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        char[] buf = string.toCharArray();
        int len = buf.length;
        boolean edit = false;
        int s = 0;
        while (s < len) {
            if (FuncNormalizeSpace.isSpace(buf[s])) break;
            ++s;
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (FuncNormalizeSpace.isSpace(c)) {
                if (!pres) {
                    if (c != ' ') {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && d >= 1 && buf[d - 1] == ' ') {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && d > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        return edit ? new String(buf, start, d - start) : string;
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }
}

