/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;

public class TagUtility {
    private static final int uppercase = -32;
    public static HashMap capitalizationMap = new HashMap();

    private TagUtility() {
    }

    public static String getFrameDescription(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("Identifier is null");
        }
        String returnValue = null;
        if (identifier.length() > 2) {
            String id;
            if (identifier.length() == 4 && (returnValue = (String)TagConstant.id3v2_4FrameIdToString.get(id = identifier.substring(0, 4))) == null) {
                returnValue = (String)TagConstant.id3v2_3FrameIdToString.get(id);
            }
            if (returnValue == null) {
                returnValue = (String)TagConstant.id3v2_2FrameIdToString.get(identifier.substring(0, 3));
            }
            if (returnValue == null) {
                returnValue = (String)TagConstant.lyrics3v2FieldIdToString.get(identifier.substring(0, 3));
            }
        }
        return returnValue;
    }

    public static boolean isID3v2_2FrameIdentifier(String identifier) {
        if (identifier.length() < 3) {
            return false;
        }
        if (identifier.length() == 3) {
            return TagConstant.id3v2_2FrameIdToString.containsKey(identifier);
        }
        if ((identifier = identifier.toUpperCase()).charAt(3) >= 'A' && identifier.charAt(3) <= 'Z') {
            return TagConstant.id3v2_2FrameIdToString.containsKey(identifier.substring(0, 4));
        }
        return TagConstant.id3v2_2FrameIdToString.containsKey(identifier.subSequence(0, 3));
    }

    public static boolean isID3v2_3FrameIdentifier(String identifier) {
        if (identifier.length() < 4) {
            return false;
        }
        return TagConstant.id3v2_3FrameIdToString.containsKey(identifier.substring(0, 4));
    }

    public static boolean isID3v2_4FrameIdentifier(String identifier) {
        if (identifier.length() < 4) {
            return false;
        }
        return TagConstant.id3v2_4FrameIdToString.containsKey(identifier.substring(0, 4));
    }

    public static boolean isLyrics3v2FieldIdentifier(String identifier) {
        if (identifier.length() < 3) {
            return false;
        }
        return TagConstant.lyrics3v2FieldIdToString.containsKey(identifier.substring(0, 3));
    }

    public static boolean isMatchingParenthesis(String str) {
        if (str != null) {
            TagOptionSingleton option = TagOptionSingleton.getInstance();
            int length = str.length();
            int i = 0;
            while (i < length) {
                char ch = str.charAt(i);
                if (option.isCloseParenthesis("" + ch)) {
                    return false;
                }
                if (option.isOpenParenthesis("" + ch) && (i = TagUtility.findMatchingParenthesis(str, i)) < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static long getWholeNumber(Object value) {
        long number;
        if (value instanceof String) {
            number = Long.parseLong((String)value);
        } else if (value instanceof Byte) {
            number = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            number = ((Short)value).shortValue();
        } else if (value instanceof Integer) {
            number = ((Integer)value).intValue();
        } else if (value instanceof Long) {
            number = (Long)value;
        } else {
            throw new IllegalArgumentException("Unsupported value class: " + value.getClass().getName());
        }
        return number;
    }

    public static String addTimeStampToTextArea(String text, int origPos) {
        if (text.length() == 0) {
            text = "[00:00]";
        } else {
            int i = origPos;
            if (text.charAt(i = Math.min(i, text.length() - 1)) == '\n') {
                --i;
            }
            while (i > 0) {
                if (text.charAt(i) == '\n') break;
                --i;
            }
            if (i == 0) {
                text = "[00:00]" + text;
            } else {
                String before = text.substring(0, ++i);
                String after = text.substring(i);
                text = before + "[00:00]" + after;
            }
        }
        return text;
    }

    public static String appendBeforeExtension(String filename, String addition) {
        if (addition == null) {
            return filename;
        }
        if (filename == null) {
            return addition;
        }
        int index = filename.lastIndexOf(46);
        if (index < 0) {
            return filename + addition;
        }
        return filename.substring(0, index) + addition + filename.substring(index);
    }

    public static String convertFrameID2_2to2_3(String identifier) {
        if (identifier.length() < 3) {
            return null;
        }
        return (String)TagConstant.id3v2_2ToId3v2_3.get(identifier.subSequence(0, 3));
    }

    public static String convertFrameID2_2to2_4(String identifier) {
        if (identifier.length() < 3) {
            return null;
        }
        String id = (String)TagConstant.id3v2_2ToId3v2_3.get(identifier.substring(0, 3));
        if (id != null) {
            id = (String)TagConstant.id3v2_3ToId3v2_4.get(id);
        }
        return id;
    }

    public static String convertFrameID2_3to2_2(String identifier) {
        if (identifier.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_3ToId3v2_2.get(identifier.substring(0, 4));
    }

    public static String convertFrameID2_3to2_4(String identifier) {
        if (identifier.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_3ToId3v2_4.get(identifier.substring(0, 4));
    }

    public static String convertFrameID2_4to2_2(String identifier) {
        if (identifier.length() < 4) {
            return null;
        }
        String id = (String)TagConstant.id3v2_4ToId3v2_3.get(identifier.substring(0, 4));
        if (id != null) {
            id = (String)TagConstant.id3v2_3ToId3v2_2.get(id);
        }
        return id;
    }

    public static String convertFrameID2_4to2_3(String identifier) {
        if (identifier.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_4ToId3v2_3.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws FileNotFoundException, IOException {
        if (source == null) {
            throw new NullPointerException("Source is null");
        }
        if (destination == null) {
            throw new NullPointerException("Destination is null");
        }
        if (!source.exists()) {
            throw new NullPointerException("Source file not found.");
        }
        FileInputStream fio = null;
        BufferedInputStream bio = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            if (destination.exists()) {
                destination.delete();
            }
            fio = new FileInputStream(source);
            bio = new BufferedInputStream(fio);
            fos = new FileOutputStream(destination);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[1024];
            int b = bio.read(buffer);
            while (b != -1) {
                bos.write(buffer, 0, b);
                b = bio.read(buffer);
            }
        }
        finally {
            if (bio != null) {
                bio.close();
            }
            if (bos != null) {
                bos.flush();
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (fio != null) {
                fio.close();
            }
        }
    }

    public static Object copyObject(Object copyObject) {
        if (copyObject == null) {
            return null;
        }
        try {
            Class[] constructorParameterArray = new Class[]{copyObject.getClass()};
            Constructor<?> constructor = copyObject.getClass().getConstructor(constructorParameterArray);
            Object[] parameterArray = new Object[]{copyObject};
            return constructor.newInstance(parameterArray);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("NoSuchMethodException: Error finding constructor to create copy");
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("IllegalAccessException: No access to run constructor to create copy");
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("InstantiationException: Unable to instantiate constructor to copy");
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("InvocationTargetException: Unable to invoke constructor to create copy");
        }
    }

    public static int findMatchingParenthesis(String str, int index) {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        if (index < 0 || index >= str.length()) {
            throw new IndexOutOfBoundsException("Index to image string is out of bounds: offset = " + index + ", string.length()" + str.length());
        }
        TagOptionSingleton option = TagOptionSingleton.getInstance();
        Stack<String> stack = new Stack<String>();
        int length = -1;
        if (str != null && index >= 0) {
            length = str.length();
            if (length == 0) {
                return 0;
            }
            int i = index;
            while (i < length) {
                char ch = str.charAt(i);
                String chString = ch + "";
                if (option.isOpenParenthesis(chString)) {
                    stack.push(chString);
                }
                if (option.isCloseParenthesis(chString)) {
                    if (stack.size() <= 0) {
                        return -1;
                    }
                    String open = (String)stack.pop();
                    if (!option.getCloseParenthesis(open).equals(chString)) {
                        return -1;
                    }
                }
                if (stack.size() <= 0) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static long findNumber(String str) throws TagException {
        return TagUtility.findNumber(str, 0);
    }

    public static long findNumber(String str, int offset) throws TagException {
        if (str == null) {
            throw new NullPointerException("String is null");
        }
        if (offset < 0 || offset >= str.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + offset + ", string.length()" + str.length());
        }
        int i = offset;
        while (i < str.length()) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9' || str.charAt(i) == '-') break;
            ++i;
        }
        int j = i + 1;
        while (j < str.length()) {
            if (str.charAt(j) < '0' || str.charAt(j) > '9') break;
            ++j;
        }
        if (j > str.length() || j <= i) {
            throw new TagException("Unable to find integer in string: " + str);
        }
        long num = Long.parseLong(str.substring(i, j));
        return num;
    }

    public static String padString(String str, int length, char ch, boolean padBefore) {
        int i;
        if (length < 0) {
            return str;
        }
        if (length == 0) {
            if (str == null) {
                return "";
            }
            return str;
        }
        int strLength = -1;
        if (str != null) {
            strLength = str.length();
        }
        if (strLength >= length) {
            return str;
        }
        char[] buffer = new char[length];
        int next = 0;
        if (padBefore) {
            i = 0;
            while (i < length - strLength) {
                buffer[next++] = ch;
                ++i;
            }
        }
        i = 0;
        while (i < str.length()) {
            buffer[next++] = str.charAt(i);
            ++i;
        }
        if (!padBefore) {
            int i2 = 0;
            while (i2 < length - strLength) {
                buffer[next++] = ch;
                ++i2;
            }
        }
        return new String(buffer);
    }

    public static String replaceEOLNwithCRLF(String text) {
        String newText = null;
        if (text != null) {
            newText = "";
            int oldPos = 0;
            int newPos = text.indexOf(10);
            while (newPos >= 0) {
                newText = newText + text.substring(oldPos, newPos) + TagConstant.CRLF;
                oldPos = ++newPos;
                newPos = text.indexOf(10, oldPos);
            }
            newText = newText + text.substring(oldPos);
        }
        return newText;
    }

    public static String replaceWord(String source, String oldString, String newString) {
        if (source == null) {
            throw new NullPointerException("Source is null");
        }
        if (oldString == null) {
            throw new NullPointerException("Old string (string to be replaced) is null");
        }
        if (source.length() > 0 && oldString.length() > 0) {
            if (newString == null) {
                newString = "";
            }
            StringBuffer str = new StringBuffer(source);
            int index = str.indexOf(oldString);
            int length = oldString.length();
            while (index >= 0) {
                if (index == 0 && Character.isWhitespace(str.charAt(index + length)) || Character.isWhitespace(str.charAt(index - 1)) && index + length >= str.length() || Character.isWhitespace(str.charAt(index - 1)) && Character.isWhitespace(str.charAt(index + length))) {
                    str.replace(index, index + length, newString);
                }
                index = str.indexOf(oldString, index);
            }
            source = str.toString();
        }
        return source;
    }

    public static String stripChar(String str, char ch) {
        if (str != null) {
            char[] buffer = new char[str.length()];
            int next = 0;
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) != ch) {
                    buffer[next++] = str.charAt(i);
                }
                ++i;
            }
            return new String(buffer, 0, next);
        }
        return null;
    }

    public static String toSentenceCase(String str, boolean keepUppercase) {
        String token;
        if (str == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(str);
        int numberTokens = tokenizer.countTokens();
        int countedTokens = 0;
        StringBuffer newString = new StringBuffer();
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            newString.append(TagUtility.capitalizeWord(token, keepUppercase));
            newString.append(' ');
            ++countedTokens;
        }
        while (tokenizer.hasMoreTokens() && countedTokens < numberTokens) {
            token = tokenizer.nextToken();
            ++countedTokens;
            if (capitalizationMap.containsKey(token.toLowerCase())) {
                newString.append(capitalizationMap.get(token.toLowerCase()));
            } else if (keepUppercase && token.toUpperCase().equals(token)) {
                newString.append(token);
            } else {
                newString.append(token.toLowerCase());
            }
            newString.append(' ');
        }
        if (newString.length() > 0) {
            newString.deleteCharAt(newString.length() - 1);
        }
        return newString.toString();
    }

    public static String toTitleCase(String str, boolean keepUppercase) {
        String token;
        if (str == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(str);
        int numberTokens = tokenizer.countTokens();
        int countedTokens = 0;
        StringBuffer newString = new StringBuffer();
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            newString.append(TagUtility.capitalizeWord(token, keepUppercase));
            newString.append(' ');
            ++countedTokens;
        }
        while (tokenizer.hasMoreTokens() && countedTokens < numberTokens - 1) {
            token = tokenizer.nextToken();
            ++countedTokens;
            if (capitalizationMap.containsKey(token.toLowerCase())) {
                newString.append(capitalizationMap.get(token.toLowerCase()));
            } else {
                newString.append(TagUtility.capitalizeWord(token, keepUppercase));
            }
            newString.append(' ');
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            newString.append(TagUtility.capitalizeWord(token, keepUppercase));
            newString.append(' ');
            ++countedTokens;
        }
        if (newString.length() > 0) {
            newString.deleteCharAt(newString.length() - 1);
        }
        return newString.toString();
    }

    public static String truncate(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return null;
        }
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    private static StringBuffer capitalizeWord(String word, boolean keepUppercase) {
        if (word == null) {
            return null;
        }
        StringBuffer wordBuffer = new StringBuffer();
        int index = 0;
        if (keepUppercase && word.toUpperCase().equals(word)) {
            wordBuffer.append(word);
        } else {
            word = word.toLowerCase();
            int len = word.length();
            char ch = word.charAt(index);
            while ((ch < 'a' || ch > 'z') && index < len - 1) {
                ch = word.charAt(++index);
            }
            if (index < len) {
                wordBuffer.append(word.substring(0, index));
                wordBuffer.append((char)(ch + uppercase));
                wordBuffer.append(word.substring(index + 1));
            } else {
                wordBuffer.append(word);
            }
        }
        return wordBuffer;
    }

    static {
        Iterator iterator = TagOptionSingleton.getInstance().getUpperLowerCaseWordListIterator();
        while (iterator.hasNext()) {
            String word = (String)iterator.next();
            capitalizationMap.put(word.toLowerCase(), word);
        }
    }
}

