/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameTag
extends AbstractMP3Tag {
    private AbstractFilenameComposite composite = null;
    private ID3v2_4 id3tag = null;
    private MP3File mp3file = null;
    private String extension = null;

    public FilenameTag(FilenameTag copyObject) {
        super(copyObject);
        this.composite = (AbstractFilenameComposite)TagUtility.copyObject(copyObject.composite);
        this.id3tag = new ID3v2_4(copyObject.id3tag);
        this.mp3file = new MP3File(copyObject.mp3file);
        this.extension = new String(copyObject.extension);
    }

    protected FilenameTag() {
    }

    public void setComposite(AbstractFilenameComposite composite) {
        this.composite = composite;
    }

    public AbstractFilenameComposite getComposite() {
        return this.composite;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (frame != null) {
            if (this.id3tag == null) {
                this.id3tag = new ID3v2_4();
            }
            this.id3tag.setFrame(frame);
            if (this.composite != null) {
                this.composite.setFrame(frame);
            }
        }
    }

    public AbstractID3v2Frame getFrame(String identifier) {
        if (this.id3tag != null) {
            return this.id3tag.getFrame(identifier);
        }
        return null;
    }

    public Iterator getFrameOfType(String identifier) {
        return this.id3tag.getFrameOfType(identifier);
    }

    public void setId3tag(ID3v2_4 id3tag) {
        this.id3tag = id3tag;
        if (id3tag != null) {
            Iterator iterator = id3tag.iterator();
            while (iterator.hasNext()) {
                this.composite.setFrame((AbstractID3v2Frame)iterator.next());
            }
            if (this.composite != null) {
                this.composite.matchAgainstTag(id3tag);
            }
        }
    }

    public ID3v2_4 getId3tag() {
        return this.id3tag;
    }

    public String getIdentifier() {
        return "FilenameTagv1.00";
    }

    public void setMp3file(MP3File mp3file) {
        this.mp3file = mp3file;
    }

    public MP3File getMp3file() {
        return this.mp3file;
    }

    public int getSize() {
        return this.composeFilename().length();
    }

    public void append(AbstractMP3Tag tag) {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public void append(RandomAccessFile file) throws TagException, IOException {
        throw new UnsupportedOperationException("Method append() not yet implemented.");
    }

    public String composeFilename() {
        if (this.composite != null) {
            return this.composite.composeFilename().trim() + "." + this.extension;
        }
        return null;
    }

    public void delete(RandomAccessFile file) throws IOException {
        throw new UnsupportedOperationException("Method delete() not yet implemented.");
    }

    public boolean hasFrame(String identifier) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrame(identifier);
        }
        return false;
    }

    public boolean hasFrameOfType(String identifier) {
        if (this.id3tag != null) {
            return this.id3tag.hasFrameOfType(identifier);
        }
        return false;
    }

    public Iterator iterator() {
        if (this.composite != null) {
            return this.composite.iterator();
        }
        return null;
    }

    public void overwrite(AbstractMP3Tag tag) {
        throw new UnsupportedOperationException("Method overwrite() not yet implemented.");
    }

    public void overwrite(RandomAccessFile file) throws TagException, IOException {
        this.write(file);
    }

    public void read(RandomAccessFile file) throws IOException, TagException {
        throw new UnsupportedOperationException("Method read() not yet implemented.");
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        throw new UnsupportedOperationException("Method seek() not yet implemented.");
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next().toString() + "\n";
        }
        return string;
    }

    public void write(AbstractMP3Tag tag) {
        throw new UnsupportedOperationException("Method write() not yet implemented.");
    }

    public void write(RandomAccessFile file) throws IOException, TagException {
        File originalFile = this.getMp3file().getMp3file();
        File newFile = new File(originalFile.getParentFile(), this.composeFilename());
        if (!newFile.getName().equals(originalFile.getName())) {
            file.getFD().sync();
            file.getChannel().close();
            file.close();
            file = null;
            TagUtility.copyFile(originalFile, newFile);
            if (!originalFile.delete()) {
                throw new TagException("Unable to delete original file: " + originalFile.getName());
            }
        }
    }
}

