/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiter;
import org.farng.mp3.filename.FilenameEndWordDelimiter;
import org.farng.mp3.filename.FilenameParenthesis;
import org.farng.mp3.filename.FilenameStartWordDelimiter;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.filename.FilenameToken;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameTagBuilder {
    public static AbstractFilenameComposite createCompositeFromToken(String token) throws TagException {
        String[] splitToken = null;
        AbstractFilenameComposite composite = null;
        splitToken = FilenameTagBuilder.parseParenthesis(token);
        if (splitToken != null) {
            composite = new FilenameParenthesis();
            ((FilenameParenthesis)composite).setOpenDelimiter(splitToken[0]);
            AbstractFilenameComposite beforeComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[2]);
            ((FilenameDelimiter)composite).setBeforeComposite(beforeComposite);
            AbstractFilenameComposite middleComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[3]);
            ((FilenameParenthesis)composite).setMiddleComposite(middleComposite);
            AbstractFilenameComposite afterComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[4]);
            ((FilenameParenthesis)composite).setAfterComposite(afterComposite);
            composite.setOriginalToken(token);
            return composite;
        }
        splitToken = FilenameTagBuilder.parseDelimiter(token);
        if (splitToken != null) {
            composite = new FilenameDelimiter();
            ((FilenameDelimiter)composite).setDelimiter(splitToken[0]);
            AbstractFilenameComposite beforeComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[1]);
            ((FilenameDelimiter)composite).setBeforeComposite(beforeComposite);
            AbstractFilenameComposite afterComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[2]);
            ((FilenameDelimiter)composite).setAfterComposite(afterComposite);
            composite.setOriginalToken(token);
            return composite;
        }
        splitToken = FilenameTagBuilder.parseStartWordDelimiter(token);
        if (splitToken != null) {
            composite = new FilenameStartWordDelimiter();
            ((FilenameDelimiter)composite).setDelimiter(splitToken[0]);
            AbstractFilenameComposite beforeComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[1]);
            ((FilenameStartWordDelimiter)composite).setBeforeComposite(beforeComposite);
            AbstractFilenameComposite afterComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[2]);
            ((FilenameStartWordDelimiter)composite).setAfterComposite(afterComposite);
            composite.setOriginalToken(token);
            return composite;
        }
        splitToken = FilenameTagBuilder.parseEndWordDelimiter(token);
        if (splitToken != null) {
            composite = new FilenameEndWordDelimiter();
            ((FilenameDelimiter)composite).setDelimiter(splitToken[0]);
            AbstractFilenameComposite beforeComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[1]);
            ((FilenameEndWordDelimiter)composite).setBeforeComposite(beforeComposite);
            AbstractFilenameComposite afterComposite = FilenameTagBuilder.createCompositeFromToken(splitToken[2]);
            ((FilenameEndWordDelimiter)composite).setAfterComposite(afterComposite);
            composite.setOriginalToken(token);
            return composite;
        }
        if (token != null && token.trim().length() > 0) {
            composite = new FilenameToken();
            ((FilenameToken)composite).setToken(token.trim());
            composite.setOriginalToken(token);
            return composite;
        }
        return null;
    }

    public static FilenameTag createEmptyFilenameTag() {
        FilenameTag filenameTag = new FilenameTag();
        filenameTag.setId3tag(new ID3v2_4());
        return filenameTag;
    }

    public static FilenameTag createFilenameTagFromMP3File(MP3File mp3File) throws Exception {
        if (mp3File.getMp3file() == null) {
            return null;
        }
        FilenameTag filenameTag = new FilenameTag();
        String filename = mp3File.getMp3file().getName();
        int index = filename.lastIndexOf(46);
        if (index >= 0) {
            filenameTag.setExtension(filename.substring(index + 1));
            filename = filename.substring(0, index);
        }
        AbstractFilenameComposite composite = FilenameTagBuilder.createCompositeFromToken(filename);
        FilenameTagBuilder.updateCompositeFromAllTag(composite, mp3File);
        FilenameTagBuilder.updateCompositeFromAllOption(composite);
        ID3v2_4 id3tag = composite.createId3Tag();
        filenameTag.setMp3file(mp3File);
        filenameTag.setComposite(composite);
        filenameTag.setId3tag(id3tag);
        return filenameTag;
    }

    public static void updateCompositeFromAllOption(AbstractFilenameComposite composite) {
        Iterator iterator = TagOptionSingleton.getInstance().getKeywordIterator();
        while (iterator.hasNext()) {
            composite.matchAgainstKeyword((Class)iterator.next());
        }
    }

    public static void updateCompositeFromAllTag(AbstractFilenameComposite composite, MP3File mp3File) {
        composite.matchAgainstTag(mp3File.getID3v1Tag());
        composite.matchAgainstTag(mp3File.getID3v2Tag());
        composite.matchAgainstTag(mp3File.getLyrics3Tag());
    }

    private static String[] parseDelimiter(String token) {
        String[] tokenArray = null;
        if (token != null && token.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getFilenameDelimiterIterator();
            while (iterator.hasNext()) {
                String delimiter = (String)iterator.next();
                int index = token.indexOf(delimiter);
                if (index < 0) continue;
                tokenArray = new String[]{delimiter, token.substring(0, index), token.substring(index + delimiter.length())};
            }
        }
        return tokenArray;
    }

    private static String[] parseEndWordDelimiter(String token) {
        String[] tokenArray = null;
        if (token != null && token.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getEndWordDelimiterIterator();
            while (iterator.hasNext()) {
                String delimiter = (String)iterator.next();
                int index = token.endsWith(delimiter) ? token.substring(0, token.length() - delimiter.length()).indexOf(delimiter) : token.indexOf(delimiter);
                if (index <= 0) continue;
                tokenArray = new String[]{delimiter, token.substring(0, index), token.substring(index)};
            }
        }
        return tokenArray;
    }

    private static String[] parseParenthesis(String token) throws TagException {
        String[] tokenArray = null;
        if (token != null && token.length() > 0) {
            TagOptionSingleton option = TagOptionSingleton.getInstance();
            String tempOpen = "";
            String open = "";
            String close = "";
            int openIndex = token.length();
            int closeIndex = -1;
            Iterator iterator = option.getOpenParenthesisIterator();
            while (iterator.hasNext()) {
                tempOpen = (String)iterator.next();
                int tempIndex = token.indexOf(tempOpen);
                if (tempIndex < 0 || tempIndex >= openIndex) continue;
                openIndex = tempIndex;
                open = tempOpen;
            }
            if (openIndex >= 0 && openIndex < token.length()) {
                close = option.getCloseParenthesis(open);
                closeIndex = TagUtility.findMatchingParenthesis(token, openIndex);
                if (closeIndex < 0) {
                    throw new TagException("Unmatched parenthesis in \"" + token + "\" at position : " + openIndex);
                }
                tokenArray = new String[]{open, close, token.substring(0, openIndex), token.substring(openIndex + open.length(), closeIndex), token.substring(closeIndex + close.length())};
            }
        }
        return tokenArray;
    }

    private static String[] parseStartWordDelimiter(String token) {
        String[] tokenArray = null;
        if (token != null && token.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getStartWordDelimiterIterator();
            while (iterator.hasNext()) {
                String delimiter = (String)iterator.next();
                int index = token.startsWith(delimiter) ? token.indexOf(delimiter, delimiter.length()) : token.indexOf(delimiter);
                if (index <= 0) continue;
                tokenArray = new String[]{delimiter, token.substring(0, index), token.substring(index)};
            }
        }
        return tokenArray;
    }
}

